/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.usergroup;

import de.justsoftware.people.authorization.NotAllowed;
import de.justsoftware.people.business.event.ProfilesCreatedEvent;
import de.justsoftware.people.business.event.ProfilesDeletedEvent;
import de.justsoftware.people.business.event.UserGroupCreatedOrPublishedEvent;
import de.justsoftware.people.business.event.UserGroupDeletedEvent;
import de.justsoftware.people.business.event.UserGroupMembersUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupRolesUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupUpdatedEvent;
import de.justsoftware.people.business.usergroup.UserGroupPublisher;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.business.usergroup.model.Membership;
import de.justsoftware.people.business.usergroup.model.UserGroup;
import de.justsoftware.people.exceptions.NotFoundException;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.model.UserGroupId;
import de.justsoftware.people.model.UserGroupRole;
import de.justsoftware.people.persistence.UserGroupMemberRepository;
import de.justsoftware.people.persistence.UserGroupRepository;
import de.justsoftware.people.persistence.UserGroupRoleRepository;
import de.justsoftware.people.persistence.model.DbUserGroup;
import de.justsoftware.people.persistence.model.DbUserGroupMember;
import de.justsoftware.people.persistence.model.DbUserGroupRole;
import de.justsoftware.people.persistence.transaction.TransactionSupport;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.people.utils.KafkaUtilsKt;
import de.justsoftware.people.utils.RepositoryUtilKt;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import jakarta.persistence.EntityManager;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 Y2\u00020\u0001:\u0001YB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0016J \u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0016J$\u0010'\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0\u0019H\u0017J\u001c\u0010+\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0\u00192\u0006\u0010,\u001a\u00020-H\u0012J$\u0010.\u001a\u00020&2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\f\u00102\u001a\b\u0012\u0004\u0012\u00020100H\u0017J,\u0010.\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010/\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020 0\u001bH\u0017J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u00104\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0016000\u00192\f\u00105\u001a\b\u0012\u0004\u0012\u00020 0\u001bH\u0016J\u0010\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\u0016H\u0017J\u0010\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020&2\u0006\u0010<\u001a\u00020)H\u0016J\u0018\u0010=\u001a\u00020&2\u0006\u00107\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001c\u0010>\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J.\u0010>\u001a\u001a\u0012\u0004\u0012\u00020\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0\u00190\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0016J$\u0010?\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0\u0019H\u0017J\"\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00140\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bH\u0016J\b\u0010B\u001a\u00020\u001eH\u0016J\u0016\u0010C\u001a\u00020&2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00140EH\u0017J\u001e\u0010F\u001a\u00020&2\u0014\u0010G\u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0006\u0012\u0004\u0018\u00010\u001e0HH\u0017J\u0010\u0010I\u001a\u00020&2\u0006\u0010J\u001a\u00020KH\u0017J\u0010\u0010L\u001a\u00020&2\u0006\u0010M\u001a\u00020NH\u0017J,\u0010O\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020 0\u001bH\u0012J2\u0010P\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0\u00192\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0RH\u0012J\u0016\u0010T\u001a\u00020&2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020 0\u001bH\u0012J\u001c\u0010V\u001a\b\u0012\u0004\u0012\u00020W002\f\u00105\u001a\b\u0012\u0004\u0012\u00020 0\u001bH\u0012J\u0012\u0010X\u001a\u0004\u0018\u00010-2\u0006\u0010!\u001a\u00020\"H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lde/justsoftware/people/business/usergroup/UserGroupService;", "", "userGroupRepository", "Lde/justsoftware/people/persistence/UserGroupRepository;", "userGroupRoleRepository", "Lde/justsoftware/people/persistence/UserGroupRoleRepository;", "userGroupMemberRepository", "Lde/justsoftware/people/persistence/UserGroupMemberRepository;", "userGroupPublisher", "Lde/justsoftware/people/business/usergroup/UserGroupPublisher;", "transactionSupport", "Lde/justsoftware/people/persistence/transaction/TransactionSupport;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "entityManager", "Ljakarta/persistence/EntityManager;", "<init>", "(Lde/justsoftware/people/persistence/UserGroupRepository;Lde/justsoftware/people/persistence/UserGroupRoleRepository;Lde/justsoftware/people/persistence/UserGroupMemberRepository;Lde/justsoftware/people/business/usergroup/UserGroupPublisher;Lde/justsoftware/people/persistence/transaction/TransactionSupport;Lorg/springframework/context/ApplicationEventPublisher;Ljakarta/persistence/EntityManager;)V", "findUserGroup", "Ljava/util/Optional;", "Lde/justsoftware/people/business/usergroup/model/UserGroup;", "userGroupId", "Lde/justsoftware/people/model/UserGroupId;", "getUserGroup", "findAllByIds", "", "userGroupIds", "", "createUserGroup", "name", "", "creator", "Lde/justsoftware/people/model/ProfileId;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "createOrGetAllTenantUsersGroup", "getAllTenantUsersGroupId", "deleteAllUserGroupsOfTenant", "", "publishUserGroup", "permissions", "Lde/justsoftware/permission/client/model/Role;", "Lde/justsoftware/people/model/UserGroupRole;", "getDefaultPermissions", "userGroup", "Lde/justsoftware/people/persistence/model/DbUserGroup;", "updateMembers", "membersToAdd", "", "Lde/justsoftware/people/business/usergroup/model/Membership;", "membersToDelete", "getMembersOfGroup", "getUserGroupsForProfiles", "profileIds", "deleteUserGroup", "groupId", "deleteOldNotYetImportedGroups", "olderThan", "Ljava/time/Duration;", "deleteUserGroupPermissionRole", "role", "renameUserGroup", "getUserGroupRoles", "setUserGroupRoles", "userGroupRoles", "getUserGroups", "getUserGroupMembershipChecksum", "forAllUserGroups", "userGroupConsumer", "Ljava/util/function/Consumer;", "onTenantChanged", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "onProfilesCreatedEvent", "event", "Lde/justsoftware/people/business/event/ProfilesCreatedEvent;", "onProfilesDeletedEvent", "profilesDeletedEvent", "Lde/justsoftware/people/business/event/ProfilesDeletedEvent;", "updateAllTenantUsersGroupMembers", "setUserGroupRolesAndPublishedPermissions", "waitForOffsetsBuilder", "Ljava/util/stream/Stream$Builder;", "Lde/justsoftware/permission/client/kafka/WaitForOffsets;", "removeDeletedProfilesFromUserGroups", "deletedProfileIds", "findUserGroupMembersByProfileIds", "Lde/justsoftware/people/persistence/model/DbUserGroupMember;", "findAllTenantUsersGroup", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nUserGroupService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserGroupService.kt\nde/justsoftware/people/business/usergroup/UserGroupService\n+ 2 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,510:1\n17#2:511\n17#2:553\n17#2:557\n17#2:563\n17#2:581\n17#2:587\n17#2:632\n1628#3,3:512\n1216#3,2:515\n1246#3,4:517\n1498#3:521\n1528#3,3:522\n1531#3,3:532\n1498#3:535\n1528#3,3:536\n1531#3,3:546\n1628#3,3:554\n1628#3,3:558\n1863#3,2:561\n1628#3,3:564\n1498#3:567\n1528#3,3:568\n1531#3,3:578\n1628#3,3:582\n1863#3,2:585\n1628#3,3:588\n1557#3:598\n1628#3,3:599\n1368#3:602\n1454#3,5:603\n1498#3:608\n1528#3,3:609\n1531#3,3:619\n1246#3,4:624\n1557#3:628\n1628#3,3:629\n1628#3,3:633\n1557#3:636\n1628#3,3:637\n1368#3:640\n1454#3,5:641\n1216#3,2:646\n1246#3,4:648\n1557#3:659\n1628#3,3:660\n1368#3:663\n1454#3,5:664\n1863#3,2:669\n1498#3:675\n1528#3,3:676\n1531#3,3:686\n1557#3:691\n1628#3,3:692\n1557#3:695\n1628#3,3:696\n1863#3,2:699\n381#4,7:525\n381#4,7:539\n381#4,7:571\n535#4:591\n520#4,6:592\n381#4,7:612\n462#4:622\n412#4:623\n535#4:652\n520#4,6:653\n381#4,7:679\n216#5,2:549\n216#5,2:551\n216#5,2:671\n216#5,2:673\n216#5,2:689\n*S KotlinDebug\n*F\n+ 1 UserGroupService.kt\nde/justsoftware/people/business/usergroup/UserGroupService\n*L\n79#1:511\n206#1:553\n214#1:557\n241#1:563\n260#1:581\n298#1:587\n346#1:632\n79#1:512,3\n80#1:515,2\n80#1:517,4\n178#1:521\n178#1:522,3\n178#1:532,3\n179#1:535\n179#1:536,3\n179#1:546,3\n206#1:554,3\n214#1:558,3\n214#1:561,2\n241#1:564,3\n252#1:567\n252#1:568,3\n252#1:578,3\n260#1:582,3\n282#1:585,2\n298#1:588,3\n332#1:598\n332#1:599,3\n334#1:602\n334#1:603,5\n335#1:608\n335#1:609,3\n335#1:619,3\n336#1:624,4\n345#1:628\n345#1:629,3\n346#1:633,3\n359#1:636\n359#1:637,3\n361#1:640\n361#1:641,5\n362#1:646,2\n362#1:648,4\n474#1:659\n474#1:660,3\n476#1:663\n476#1:664,5\n142#1:669,2\n462#1:675\n462#1:676,3\n462#1:686,3\n467#1:691\n467#1:692,3\n468#1:695\n468#1:696,3\n469#1:699,2\n178#1:525,7\n179#1:539,7\n252#1:571,7\n304#1:591\n304#1:592,6\n335#1:612,7\n336#1:622\n336#1:623\n447#1:652\n447#1:653,6\n462#1:679,7\n180#1:549,2\n187#1:551,2\n404#1:671,2\n409#1:673,2\n463#1:689,2\n*E\n"})
public class UserGroupService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserGroupRepository userGroupRepository;
    @NotNull
    private final UserGroupRoleRepository userGroupRoleRepository;
    @NotNull
    private final UserGroupMemberRepository userGroupMemberRepository;
    @NotNull
    private final UserGroupPublisher userGroupPublisher;
    @NotNull
    private final TransactionSupport transactionSupport;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final EntityManager entityManager;
    @NotNull
    private static final Consumer<WaitForOffsets> NOOP_OFFSETS_CONSUMER = UserGroupService::NOOP_OFFSETS_CONSUMER$lambda$60;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupService.class);
    @NotNull
    private static final String TENANT_USER_GROUP_NAME = " ";

    public UserGroupService(@NotNull UserGroupRepository userGroupRepository, @NotNull UserGroupRoleRepository userGroupRoleRepository, @NotNull UserGroupMemberRepository userGroupMemberRepository, @NotNull UserGroupPublisher userGroupPublisher, @NotNull TransactionSupport transactionSupport, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)userGroupRepository, (String)"userGroupRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupRoleRepository, (String)"userGroupRoleRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepository, (String)"userGroupMemberRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupPublisher, (String)"userGroupPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionSupport, (String)"transactionSupport");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        this.userGroupRepository = userGroupRepository;
        this.userGroupRoleRepository = userGroupRoleRepository;
        this.userGroupMemberRepository = userGroupMemberRepository;
        this.userGroupPublisher = userGroupPublisher;
        this.transactionSupport = transactionSupport;
        this.applicationEventPublisher = applicationEventPublisher;
        this.entityManager = entityManager;
    }

    @NotNull
    public Optional<UserGroup> findUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Optional<UserGroup> optional = this.userGroupRepository.findById(userGroupId.getId()).map(arg_0 -> UserGroupService.findUserGroup$lambda$1(UserGroupService::findUserGroup$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return optional;
    }

    @NotNull
    public UserGroup getUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Object t = this.findUserGroup(userGroupId).orElseThrow(() -> UserGroupService.getUserGroup$lambda$2(userGroupId));
        Intrinsics.checkNotNullExpressionValue(t, (String)"orElseThrow(...)");
        return (UserGroup)t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<UserGroupId, UserGroup> findAllByIds(@NotNull Set<UserGroupId> userGroupIds) {
        void $this$associateByTo$iv$iv;
        DbUserGroup p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Iterable iterable = userGroupIds;
        Object object = this.userGroupRepository;
        boolean $i$f$mapToSet = false;
        void var5_6 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UserGroupId userGroupId = (UserGroupId)item$iv$iv;
            collection = destination$iv$iv;
            boolean $i$f$findAllByIds$stub_for_inlining = false;
            boolean bl = false;
            collection.add((UUID)p0.getId());
        }
        List list = object.findAllById((Iterable)((Set)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $this$associateBy$iv = list;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            p0 = (DbUserGroup)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            DbUserGroup it = (DbUserGroup)element$iv$iv;
            collection = new UserGroupId(it.getId());
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            UserGroup userGroup = DbUserGroup.Companion.toUserGroup(it);
            object.put(collection, userGroup);
        }
        return destination$iv$iv;
    }

    @Transactional
    @NotNull
    public UserGroupId createUserGroup(@NotNull String name, @NotNull ProfileId creator, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Object object = this.userGroupRepository.save((Object)new DbUserGroup(uUID, (UUID)tenantId.getId(), name, (Long)creator.getId(), false, false, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        DbUserGroup userGroup = (DbUserGroup)object;
        UserGroupId userGroupId = new UserGroupId(userGroup.getId());
        this.publishUserGroup(userGroupId, this.getDefaultPermissions(userGroup));
        return userGroupId;
    }

    @NotNull
    public synchronized UserGroupId createOrGetAllTenantUsersGroup(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbUserGroup dbUserGroup = this.findAllTenantUsersGroup(tenantId);
        if (dbUserGroup == null) {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            Object object = this.userGroupRepository.save((Object)new DbUserGroup(uUID, (UUID)tenantId.getId(), TENANT_USER_GROUP_NAME, null, true, false, null));
            DbUserGroup it = (DbUserGroup)object;
            boolean bl = false;
            UserGroupId userGroupId = new UserGroupId(it.getId());
            this.publishUserGroup(userGroupId, MapsKt.mapOf((Pair)TuplesKt.to((Object)userGroupId.asPermissionRole(), (Object)UserGroupRole.READER)));
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"also(...)");
            dbUserGroup = (DbUserGroup)object2;
        }
        DbUserGroup usersGroup = dbUserGroup;
        return new UserGroupId(usersGroup.getId());
    }

    @NotNull
    public UserGroupId getAllTenantUsersGroupId(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbUserGroup dbUserGroup = this.findAllTenantUsersGroup(tenantId);
        if (dbUserGroup == null) {
            boolean bl = false;
            String string = "No all tenant users group available for tenant " + tenantId;
            throw new IllegalStateException(string.toString());
        }
        UUID uUID = dbUserGroup.getId();
        return new UserGroupId(uUID);
    }

    public void deleteAllUserGroupsOfTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        LOGGER.info("Deleting all user groups of tenant '" + tenantId + "'...");
        this.transactionSupport.doInTransaction(() -> UserGroupService.deleteAllUserGroupsOfTenant$lambda$8(this, tenantId));
    }

    @Transactional
    public void publishUserGroup(@NotNull UserGroupId userGroupId, @NotNull Map<Role, ? extends UserGroupRole> permissions) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        UserGroup userGroup = this.getUserGroup(userGroupId);
        Stream.Builder offsetConsumer = Stream.builder();
        this.userGroupPublisher.publishUserGroup(userGroup, (Consumer)offsetConsumer);
        Intrinsics.checkNotNull(offsetConsumer);
        this.setUserGroupRolesAndPublishedPermissions(userGroupId, permissions, offsetConsumer);
        this.transactionSupport.doAfterCommit(() -> UserGroupService.publishUserGroup$lambda$9(this, userGroupId));
    }

    private Map<Role, UserGroupRole> getDefaultPermissions(DbUserGroup userGroup) {
        HashMap userGroupRoles = new HashMap();
        UserGroupId allTenantUsersGroupId = this.getAllTenantUsersGroupId(new TenantId(userGroup.getTenantId()));
        ((Map)userGroupRoles).put(Role.userGroupRole((UUID)((UUID)allTenantUsersGroupId.getId())), UserGroupRole.READER);
        Long creatorId = userGroup.getCreatorId();
        if (creatorId != null) {
            ((Map)userGroupRoles).put(Role.profileRole((long)creatorId), UserGroupRole.MANAGER);
        }
        return userGroupRoles;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateMembers(@NotNull List<Membership> membersToAdd, @NotNull List<Membership> membersToDelete) {
        List members;
        UserGroupId userGroupId;
        Map.Entry element$iv;
        void $this$groupByTo$iv$iv;
        Membership p0;
        List list;
        void $this$groupByTo$iv$iv2;
        Intrinsics.checkNotNullParameter(membersToAdd, (String)"membersToAdd");
        Intrinsics.checkNotNullParameter(membersToDelete, (String)"membersToDelete");
        Iterable $this$groupBy$iv = membersToAdd;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object;
            Membership p02 = (Membership)element$iv$iv;
            boolean $i$f$updateMembers$stub_for_inlining$142 = false;
            boolean bl = false;
            UserGroupId key$iv$iv = p02.getUserGroupId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Membership $i$f$updateMembers$stub_for_inlining$142 = (Membership)element$iv$iv;
            list = list$iv$iv;
            boolean $i$f$updateMembers$stub_for_inlining$11 = false;
            boolean bl3 = false;
            list.add(p0.getProfileId());
        }
        Map membersToAddByGroup = destination$iv$iv;
        Iterable $this$groupBy$iv2 = membersToDelete;
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void p03;
            Object object;
            p0 = (Membership)element$iv$iv;
            boolean $i$f$updateMembers$stub_for_inlining$152 = false;
            boolean bl = false;
            UserGroupId key$iv$iv = p0.getUserGroupId();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Membership $i$f$updateMembers$stub_for_inlining$152 = (Membership)element$iv$iv;
            list = list$iv$iv;
            boolean $i$f$updateMembers$stub_for_inlining$13 = false;
            boolean bl5 = false;
            list.add(p03.getProfileId());
        }
        Map membersToDeleteByGroup = destination$iv$iv2;
        Map $this$forEach$iv = membersToAddByGroup;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            userGroupId = (UserGroupId)entry.getKey();
            members = (List)entry.getValue();
            this.updateMembers(userGroupId, CollectionsKt.toSet((Iterable)members), SetsKt.emptySet());
        }
        $this$forEach$iv = membersToDeleteByGroup;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            userGroupId = (UserGroupId)entry.getKey();
            members = (List)entry.getValue();
            this.updateMembers(userGroupId, SetsKt.emptySet(), CollectionsKt.toSet((Iterable)members));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateMembers(@NotNull UserGroupId userGroupId, @NotNull Set<ProfileId> membersToAdd, @NotNull Set<ProfileId> membersToDelete) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Intrinsics.checkNotNullParameter(membersToAdd, (String)"membersToAdd");
        Intrinsics.checkNotNullParameter(membersToDelete, (String)"membersToDelete");
        Iterable $this$mapToSet$iv = this.userGroupMemberRepository.findByUserGroupId((UUID)userGroupId.getId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId(it.getProfileId()));
        }
        Set currentGroupMembers = (Set)destination$iv$iv;
        Set newMembers = SetsKt.minus(membersToAdd, (Iterable)currentGroupMembers);
        Set filteredMembersToDelete = CollectionsKt.intersect((Iterable)membersToDelete, (Iterable)currentGroupMembers);
        this.userGroupMemberRepository.saveAll((Iterable)Companion.toDbUserGroupMembers$people_api((Collection)Companion.toDbUserGroupMemberIds$people_api((Collection)newMembers, userGroupId)));
        Iterable $this$mapToSet$iv2 = filteredMembersToDelete;
        boolean $i$f$mapToSet2 = false;
        Iterable $i$f$mapTo22 = $this$mapToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(((Number)it.getId()).longValue());
        }
        Iterable $this$forEach$iv = CollectionsKt.chunked((Iterable)((Set)destination$iv$iv2), (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl = false;
            this.userGroupMemberRepository.deleteByUserGroupIdAndProfileIds((UUID)userGroupId.getId(), CollectionsKt.toSet((Iterable)it));
        }
        boolean entriesProcessed = this.userGroupPublisher.publishUserGroupMemberships(userGroupId, newMembers, filteredMembersToDelete);
        if (!entriesProcessed) {
            LOGGER.warn("Permission has not processed all user group changes. Aborting SOLR reindex. Potentially inconsistent state. In emergencies you can trigger a SOLR index for profiles manually.");
            return;
        }
        this.transactionSupport.doAfterCommit(() -> UserGroupService.updateMembers$lambda$19(this, userGroupId, newMembers, filteredMembersToDelete));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProfileId> getMembersOfGroup(@NotNull UserGroupId userGroupId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Iterable $this$mapToSet$iv = this.userGroupMemberRepository.findByUserGroupId((UUID)userGroupId.getId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId(it.getProfileId()));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, List<UserGroupId>> getUserGroupsForProfiles(@NotNull Set<ProfileId> profileIds) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable $this$groupBy$iv = this.findUserGroupMembersByProfileIds(profileIds);
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            DbUserGroupMember it2 = (DbUserGroupMember)element$iv$iv;
            boolean $i$a$-groupBy-UserGroupService$getUserGroupsForProfiles$32 = false;
            ProfileId key$iv$iv = new ProfileId(it2.getProfileId());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            DbUserGroupMember $i$a$-groupBy-UserGroupService$getUserGroupsForProfiles$32 = (DbUserGroupMember)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(new UserGroupId(it.getUserGroupId()));
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteUserGroup(@NotNull UserGroupId groupId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Iterable $this$mapToSet$iv = this.userGroupMemberRepository.findByUserGroupId((UUID)groupId.getId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId(it.getProfileId()));
        }
        Set membersOfGroup = (Set)destination$iv$iv;
        this.userGroupMemberRepository.deleteByUserGroupId((UUID)groupId.getId());
        Role role = Role.userGroupRole((UUID)((UUID)groupId.getId()));
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"userGroupRole(...)");
        this.deleteUserGroupPermissionRole(role);
        this.userGroupRepository.deleteById(groupId.getId());
        this.transactionSupport.doAfterCommit(() -> UserGroupService.deleteUserGroup$lambda$24(this, groupId, membersOfGroup));
    }

    public void deleteOldNotYetImportedGroups(@NotNull Duration olderThan) {
        Intrinsics.checkNotNullParameter((Object)olderThan, (String)"olderThan");
        LOGGER.info("Scheduled deletion of old not yet imported groups");
        Iterable $this$forEach$iv = this.userGroupRepository.findNotYetImportedGroups();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbUserGroup it = (DbUserGroup)element$iv;
            boolean bl = false;
            Instant maxCreatedAtAge = Instant.now().minus(olderThan);
            Instant instant = it.getCreatedAt();
            boolean bl2 = instant != null ? instant.isBefore(maxCreatedAtAge) : false;
            if (!bl2) continue;
            this.deleteUserGroup(new UserGroupId(it.getId()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void deleteUserGroupPermissionRole(@NotNull Role role) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        String string = role.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Iterable $this$mapToSet$iv = this.userGroupRoleRepository.findAllByRole(string);
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbUserGroupRole dbUserGroupRole = (DbUserGroupRole)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UserGroupId(it.getUserGroupId()));
        }
        Set userGroupIds = (Set)destination$iv$iv;
        if (userGroupIds.isEmpty()) {
            return;
        }
        Map userGroupRoles = this.getUserGroupRoles(userGroupIds);
        for (UserGroupId userGroupId : userGroupIds) {
            Map map;
            if ((Map)userGroupRoles.get(userGroupId) != null) {
                void $this$filterTo$iv$iv;
                Map $this$filter$iv;
                boolean $i$f$filter = false;
                Map bl = $this$filter$iv;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry entry = element$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Role key = (Role)entry.getKey();
                    if (!(!Intrinsics.areEqual((Object)role, (Object)key))) continue;
                    destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                map = destination$iv$iv2;
            } else {
                map = MapsKt.emptyMap();
            }
            Map newRoles = map;
            this.setUserGroupRoles(userGroupId, newRoles);
        }
    }

    public void renameUserGroup(@NotNull UserGroupId groupId, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        UserGroup userGroup = this.getUserGroup(groupId);
        if (userGroup.isAllTenantUsers()) {
            throw new NotAllowed("You must not rename the group with id '" + groupId + "'. It is an allTenantUsers group.");
        }
        DbUserGroup dbUserGroup = DbUserGroup.copy$default((DbUserGroup)DbUserGroup.Companion.toDbUserGroup(userGroup), null, null, (String)name, null, (boolean)false, (boolean)false, null, (int)123, null);
        this.userGroupRepository.save((Object)dbUserGroup);
        this.userGroupPublisher.publishUserGroup(DbUserGroup.Companion.toUserGroup(dbUserGroup), NOOP_OFFSETS_CONSUMER);
        this.transactionSupport.doAfterCommit(() -> UserGroupService.renameUserGroup$lambda$28(this, groupId));
    }

    @NotNull
    public Map<Role, UserGroupRole> getUserGroupRoles(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Map map = (Map)this.getUserGroupRoles(SetsKt.setOf((Object)userGroupId)).get(userGroupId);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<UserGroupId, Map<Role, UserGroupRole>> getUserGroupRoles(@NotNull Set<UserGroupId> userGroupIds) {
        void $this$mapValuesTo$iv$iv;
        Object $this$groupByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Iterable $this$map$iv = userGroupIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            UserGroupId userGroupId = (UserGroupId)item$iv$iv;
            object = destination$iv$iv;
            boolean $i$f$getUserGroupRoles$stub_for_inlining$29 = false;
            boolean bl = false;
            object.add((UUID)p0.getId());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        UserGroupRoleRepository $i$f$map22 = this.userGroupRoleRepository;
        boolean $i$f$flatMap22 = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Collection p0 = (Collection)element$iv$iv;
            boolean $i$f$getUserGroupRoles$stub_for_inlining$30 = false;
            boolean bl = false;
            Iterable list$iv$iv = $i$f$map22.findAllByUserGroupIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv2;
        boolean $i$f$groupBy = false;
        Iterable $i$f$flatMap22 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator $i$f$flatMapTo22 = $this$groupByTo$iv$iv.iterator();
        while ($i$f$flatMapTo22.hasNext()) {
            void it;
            Object object2;
            Object element$iv$iv = $i$f$flatMapTo22.next();
            DbUserGroupRole it2 = (DbUserGroupRole)element$iv$iv;
            boolean $i$a$-groupBy-UserGroupService$getUserGroupRoles$52 = false;
            UserGroupId key$iv$iv = new UserGroupId(it2.getUserGroupId());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            DbUserGroupRole $i$a$-groupBy-UserGroupService$getUserGroupRoles$52 = (DbUserGroupRole)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add(TuplesKt.to((Object)Role.create((String)it.getRole()), (Object)it.getUserGroupRole()));
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object3;
            boolean bl2 = false;
            List values = (List)entry.getValue();
            Map map = MapsKt.toMap((Iterable)values);
            object.put(k, map);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void setUserGroupRoles(@NotNull UserGroupId userGroupId, @NotNull Map<Role, ? extends UserGroupRole> userGroupRoles) {
        void $this$mapToSet$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        Intrinsics.checkNotNullParameter(userGroupRoles, (String)"userGroupRoles");
        Stream.Builder builder = Stream.builder();
        Intrinsics.checkNotNullExpressionValue(builder, (String)"builder(...)");
        this.setUserGroupRolesAndPublishedPermissions(userGroupId, userGroupRoles, builder);
        Iterable iterable = this.userGroupMemberRepository.findByUserGroupId((UUID)userGroupId.getId());
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            collection = destination$iv$iv;
            boolean $i$f$setUserGroupRoles$stub_for_inlining$34 = false;
            boolean bl = false;
            collection.add(p0.getProfileId());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            long p0 = ((Number)item$iv$iv).longValue();
            collection = destination$iv$iv;
            boolean $i$f$setUserGroupRoles$stub_for_inlining$35 = false;
            boolean bl = false;
            collection.add(new ProfileId(p0));
        }
        Set membersOfGroup = (Set)destination$iv$iv;
        this.transactionSupport.doAfterCommit(() -> UserGroupService.setUserGroupRoles$lambda$36(this, userGroupId, membersOfGroup));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<UserGroupId, UserGroup> getUserGroups(@NotNull Set<UserGroupId> userGroupIds) {
        void $this$associateByTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Iterable $this$map$iv = userGroupIds;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            UserGroupId userGroupId = (UserGroupId)item$iv$iv;
            object = destination$iv$iv;
            boolean $i$f$getUserGroups$stub_for_inlining$37 = false;
            boolean bl = false;
            object.add((UUID)p0.getId());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        UserGroupRepository $i$f$map22 = this.userGroupRepository;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Iterable p0 = (Iterable)element$iv$iv;
            boolean $i$f$getUserGroups$stub_for_inlining$38 = false;
            boolean bl = false;
            Iterable list$iv$iv = $i$f$map22.findAllById(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$flatMapTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            DbUserGroup list$iv$iv = (DbUserGroup)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            DbUserGroup it = (DbUserGroup)element$iv$iv;
            UserGroupId userGroupId = new UserGroupId(it.getId());
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            UserGroup userGroup = DbUserGroup.Companion.toUserGroup(it);
            object.put(userGroupId, userGroup);
        }
        return destination$iv$iv2;
    }

    @NotNull
    public String getUserGroupMembershipChecksum() {
        if (RepositoryUtilKt.isPostgres((EntityManager)this.entityManager)) {
            String string = this.userGroupMemberRepository.getUserGroupMembershipChecksumPostgres();
            if (string == null) {
                string = "";
            }
            return string;
        }
        return "";
    }

    @Transactional
    public void forAllUserGroups(@NotNull Consumer<UserGroup> userGroupConsumer) {
        Intrinsics.checkNotNullParameter(userGroupConsumer, (String)"userGroupConsumer");
        this.userGroupRepository.streamAll().map(arg_0 -> UserGroupService.forAllUserGroups$lambda$42(UserGroupService::forAllUserGroups$lambda$41, arg_0)).forEach(userGroupConsumer);
    }

    @KafkaListener(id="just.people.tenantConsumer", containerFactory="tenantListenerFactory", topics={"just.tenants"}, idIsGroup=false)
    public void onTenantChanged(@NotNull ConsumerRecords<TenantId, String> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        KafkaUtilsKt.filterAndLogDeserializationErrors(records).forEach(arg_0 -> UserGroupService.onTenantChanged$lambda$43(this, arg_0));
    }

    @Async
    @EventListener
    public void onProfilesCreatedEvent(@NotNull ProfilesCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.transactionSupport.doInTransaction(() -> UserGroupService.onProfilesCreatedEvent$lambda$48(event, this));
    }

    @Async
    @EventListener
    public void onProfilesDeletedEvent(@NotNull ProfilesDeletedEvent profilesDeletedEvent) {
        Intrinsics.checkNotNullParameter((Object)profilesDeletedEvent, (String)"profilesDeletedEvent");
        this.removeDeletedProfilesFromUserGroups(profilesDeletedEvent.getProfileIds());
    }

    private void updateAllTenantUsersGroupMembers(TenantId tenantId, Set<ProfileId> membersToAdd, Set<ProfileId> membersToDelete) {
        UserGroupId allTenantUsersGroup = this.createOrGetAllTenantUsersGroup(tenantId);
        this.updateMembers(allTenantUsersGroup, membersToAdd, membersToDelete);
    }

    /*
     * WARNING - void declaration
     */
    private void setUserGroupRolesAndPublishedPermissions(UserGroupId userGroupId, Map<Role, ? extends UserGroupRole> userGroupRoles, Stream.Builder<WaitForOffsets> waitForOffsetsBuilder) {
        void $this$filterTo$iv$iv;
        Map map = (Map)this.getUserGroupRoles(SetsKt.setOf((Object)userGroupId)).get(userGroupId);
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map oldUserGroupRoles = map;
        this.transactionSupport.doInTransaction(() -> UserGroupService.setUserGroupRolesAndPublishedPermissions$lambda$49(this, userGroupId, userGroupRoles));
        Map $this$filter$iv = oldUserGroupRoles;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            Role role = (Role)entry.getKey();
            UserGroupRole userGroupRole = (UserGroupRole)entry.getValue();
            if (!(!userGroupRoles.containsKey(role) || userGroupRoles.get(role) != userGroupRole)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map userGroupRolesToDelete = destination$iv$iv;
        this.userGroupPublisher.publishUserGroupRoles(userGroupId, userGroupRoles, userGroupRolesToDelete, (Consumer)waitForOffsetsBuilder);
        new WaitForOffsets(waitForOffsetsBuilder.build()).waitForOffsets();
    }

    private void removeDeletedProfilesFromUserGroups(Set<ProfileId> deletedProfileIds) {
        this.transactionSupport.doInTransaction(() -> UserGroupService.removeDeletedProfilesFromUserGroups$lambda$57(this, deletedProfileIds));
    }

    /*
     * WARNING - void declaration
     */
    private List<DbUserGroupMember> findUserGroupMembersByProfileIds(Set<ProfileId> profileIds) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = profileIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$findUserGroupMembersByProfileIds$stub_for_inlining$58 = false;
            boolean bl = false;
            collection.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = CollectionsKt.chunked((Iterable)((List)destination$iv$iv), (int)1000);
        UserGroupMemberRepository userGroupMemberRepository = this.userGroupMemberRepository;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Collection p0 = (Collection)element$iv$iv;
            boolean $i$f$findUserGroupMembersByProfileIds$stub_for_inlining$59 = false;
            boolean bl = false;
            Iterable list$iv$iv = userGroupMemberRepository.findByProfileIdIn(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private DbUserGroup findAllTenantUsersGroup(TenantId tenantId) {
        return (DbUserGroup)CollectionsKt.firstOrNull((List)this.userGroupRepository.findByAllTenantUsersIsTrueAndTenantId((UUID)tenantId.getId()));
    }

    private static final UserGroup findUserGroup$lambda$0(DbUserGroup it) {
        Intrinsics.checkNotNull((Object)it);
        return DbUserGroup.Companion.toUserGroup(it);
    }

    private static final UserGroup findUserGroup$lambda$1(Function1 $tmp0, Object p0) {
        return (UserGroup)$tmp0.invoke(p0);
    }

    private static final NotFoundException getUserGroup$lambda$2(UserGroupId $userGroupId) {
        return new NotFoundException("Could not find user group " + $userGroupId, $userGroupId.toString());
    }

    private static final void deleteAllUserGroupsOfTenant$lambda$8(UserGroupService this$0, TenantId $tenantId) {
        List userGroups = this$0.userGroupRepository.findIdsByTenantId((UUID)$tenantId.getId()).toList();
        Intrinsics.checkNotNull(userGroups);
        Iterable $this$forEach$iv = userGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this$0.deleteUserGroup(new UserGroupId(it));
        }
        LOGGER.info("Deleted " + userGroups.size() + " user group(s) of tenant '" + $tenantId + "'.");
    }

    private static final void publishUserGroup$lambda$9(UserGroupService this$0, UserGroupId $userGroupId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserGroupCreatedOrPublishedEvent((Object)this$0, $userGroupId));
    }

    private static final void updateMembers$lambda$19(UserGroupService this$0, UserGroupId $userGroupId, Set $newMembers, Set $filteredMembersToDelete) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserGroupMembersUpdatedEvent((Object)this$0, $userGroupId, $newMembers, $filteredMembersToDelete));
    }

    private static final void deleteUserGroup$lambda$24(UserGroupService this$0, UserGroupId $groupId, Set $membersOfGroup) {
        this$0.userGroupPublisher.publishUserGroupDeleted($groupId, $membersOfGroup);
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserGroupDeletedEvent((Object)this$0, $groupId, $membersOfGroup));
    }

    private static final void renameUserGroup$lambda$28(UserGroupService this$0, UserGroupId $groupId) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserGroupUpdatedEvent((Object)this$0, $groupId));
    }

    private static final void setUserGroupRoles$lambda$36(UserGroupService this$0, UserGroupId $userGroupId, Set $membersOfGroup) {
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new UserGroupRolesUpdatedEvent((Object)this$0, $userGroupId, $membersOfGroup));
    }

    private static final UserGroup forAllUserGroups$lambda$41(DbUserGroup it) {
        Intrinsics.checkNotNull((Object)it);
        return DbUserGroup.Companion.toUserGroup(it);
    }

    private static final UserGroup forAllUserGroups$lambda$42(Function1 $tmp0, Object p0) {
        return (UserGroup)$tmp0.invoke(p0);
    }

    private static final void onTenantChanged$lambda$43(UserGroupService this$0, ConsumerRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        if (record.value() == null) {
            Object object = record.key();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key(...)");
            this$0.deleteAllUserGroupsOfTenant((TenantId)object);
        } else {
            Object object = record.key();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"key(...)");
            this$0.createOrGetAllTenantUsersGroup((TenantId)object);
        }
    }

    private static final HashSet onProfilesCreatedEvent$lambda$48$lambda$46$lambda$44(TenantId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new HashSet();
    }

    private static final HashSet onProfilesCreatedEvent$lambda$48$lambda$46$lambda$45(Function1 $tmp0, Object p0) {
        return (HashSet)$tmp0.invoke(p0);
    }

    private static final void onProfilesCreatedEvent$lambda$48(ProfilesCreatedEvent $event, UserGroupService this$0) {
        Map.Entry entry;
        Map.Entry element$iv;
        HashMap<Object, HashSet> profilesToAdd = new HashMap<Object, HashSet>();
        Map $this$forEach$iv = $event.getCreatedProfiles();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            ProfileId profileId = (ProfileId)entry.getKey();
            TenantId tenantId = (TenantId)entry.getValue();
            if (tenantId == null) continue;
            profilesToAdd.computeIfAbsent(tenantId, arg_0 -> UserGroupService.onProfilesCreatedEvent$lambda$48$lambda$46$lambda$45(UserGroupService::onProfilesCreatedEvent$lambda$48$lambda$46$lambda$44, arg_0)).add(profileId);
        }
        $this$forEach$iv = profilesToAdd;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            TenantId tenantId = (TenantId)entry.getKey();
            HashSet profileIds = (HashSet)entry.getValue();
            this$0.updateAllTenantUsersGroupMembers(tenantId, (Set)profileIds, SetsKt.emptySet());
        }
    }

    private static final void setUserGroupRolesAndPublishedPermissions$lambda$49(UserGroupService this$0, UserGroupId $userGroupId, Map $userGroupRoles) {
        this$0.userGroupRoleRepository.deleteByUserGroupId((UUID)$userGroupId.getId());
        this$0.userGroupRoleRepository.saveAll((Iterable)Companion.toDbUserGroupRoles$people_api($userGroupRoles, $userGroupId));
    }

    /*
     * WARNING - void declaration
     */
    private static final void removeDeletedProfilesFromUserGroups$lambda$57(UserGroupService this$0, Set $deletedProfileIds) {
        Iterable $this$mapTo$iv$iv;
        List membersToDelete;
        Map.Entry element$iv;
        Object object;
        Object $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this$0.findUserGroupMembersByProfileIds($deletedProfileIds);
        boolean $i$f$groupBy = false;
        Object object2 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object object3;
            Object element$iv$iv = iterator.next();
            DbUserGroupMember it2 = (DbUserGroupMember)element$iv$iv;
            boolean $i$a$-groupBy-UserGroupService$removeDeletedProfilesFromUserGroups$1$profilesToDelete$32 = false;
            UserGroupId key$iv$iv = new UserGroupId(it2.getUserGroupId());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            DbUserGroupMember $i$a$-groupBy-UserGroupService$removeDeletedProfilesFromUserGroups$1$profilesToDelete$32 = (DbUserGroupMember)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add(new ProfileId(it.getProfileId()));
        }
        Map profilesToDelete = destination$iv$iv;
        Object $this$forEach$iv = profilesToDelete;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Map.Entry $i$f$groupByTo2 = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            UserGroupId userGroupId = (UserGroupId)$i$f$groupByTo2.getKey();
            membersToDelete = (List)$i$f$groupByTo2.getValue();
            this$0.updateMembers(userGroupId, SetsKt.emptySet(), CollectionsKt.toSet((Iterable)membersToDelete));
        }
        Iterable $this$map$iv = $deletedProfileIds;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            membersToDelete = (ProfileId)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$removeDeletedProfilesFromUserGroups$lambda$57$stub_for_inlining$54 = false;
            object.add(((Number)p0.getId()).longValue());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            long p0 = ((Number)item$iv$iv).longValue();
            object = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$removeDeletedProfilesFromUserGroups$lambda$57$stub_for_inlining$55 = false;
            object.add(Role.profileRole((long)p0));
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        object2 = $this$forEach$iv.iterator();
        while (object2.hasNext()) {
            element$iv = object2.next();
            Role p0 = (Role)element$iv;
            boolean bl = false;
            boolean $i$f$removeDeletedProfilesFromUserGroups$lambda$57$stub_for_inlining$56 = false;
            this$0.deleteUserGroupPermissionRole(p0);
        }
    }

    private static final void NOOP_OFFSETS_CONSUMER$lambda$60(WaitForOffsets it) {
    }
}

