/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.application;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.application.ProfileApplicationService;
import de.justsoftware.people.application.model.AbsenceDto;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.config.ConfigService;
import de.justsoftware.people.config.FeatureConfig;
import de.justsoftware.people.config.UnsupportedFeatureException;
import de.justsoftware.people.model.Absence;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0016J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J*\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/people/application/ProfileApplicationService;", "", "profileService", "Lde/justsoftware/people/business/profile/ProfileService;", "configService", "Lde/justsoftware/people/config/ConfigService;", "<init>", "(Lde/justsoftware/people/business/profile/ProfileService;Lde/justsoftware/people/config/ConfigService;)V", "saveBirthdayReminderForProfile", "", "authCtx", "Lde/justsoftware/people/authorization/AuthorizationContext;", "reminderProfileId", "Lde/justsoftware/people/model/ProfileId;", "deleteBirthdayReminderForProfile", "getAbsenceInformation", "Lde/justsoftware/people/application/model/AbsenceDto;", "profileId", "changeAbsenceStatus", "absenceStatus", "", "changeAbsenceNote", "absenceNote", "", "", "profileIds", "", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nProfileApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileApplicationService.kt\nde/justsoftware/people/application/ProfileApplicationService\n+ 2 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,116:1\n17#2:117\n23#2:121\n1628#3,3:118\n1619#3:122\n1863#3:123\n1864#3:125\n1620#3:126\n1246#3,4:129\n1#4:124\n462#5:127\n412#5:128\n*S KotlinDebug\n*F\n+ 1 ProfileApplicationService.kt\nde/justsoftware/people/application/ProfileApplicationService\n*L\n96#1:117\n97#1:121\n96#1:118,3\n97#1:122\n97#1:123\n97#1:125\n97#1:126\n102#1:129,4\n97#1:124\n102#1:127\n102#1:128\n*E\n"})
public class ProfileApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final ConfigService configService;

    public ProfileApplicationService(@NotNull ProfileService profileService, @NotNull ConfigService configService) {
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        this.profileService = profileService;
        this.configService = configService;
    }

    public void saveBirthdayReminderForProfile(@NotNull AuthorizationContext authCtx, @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        authCtx.check(Role.read((String)reminderProfileId.toString()));
        ProfileId profileId = authCtx.getProfileId();
        Intrinsics.checkNotNullExpressionValue((Object)profileId, (String)"getProfileId(...)");
        this.profileService.saveBirthdayReminder(profileId, reminderProfileId);
    }

    public void deleteBirthdayReminderForProfile(@NotNull AuthorizationContext authCtx, @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        authCtx.check(Role.read((String)reminderProfileId.toString()));
        ProfileId profileId = authCtx.getProfileId();
        Intrinsics.checkNotNullExpressionValue((Object)profileId, (String)"getProfileId(...)");
        this.profileService.deleteBirthdayReminder(profileId, reminderProfileId);
    }

    @NotNull
    public AbsenceDto getAbsenceInformation(@NotNull AuthorizationContext authCtx, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        FeatureConfig featureConfig = this.configService.getFeatureConfig(tenantId);
        if (!featureConfig.isAbsenceStatusEnabled() && !featureConfig.isAbsenceNoteEnabled()) {
            throw new UnsupportedFeatureException("Feature is not enabled");
        }
        authCtx.check(Role.read((String)profileId.toString()));
        return AbsenceDto.Companion.toAbsenceDto(this.profileService.getAbsenceInformation(profileId), featureConfig);
    }

    @NotNull
    public AbsenceDto changeAbsenceStatus(@NotNull AuthorizationContext authCtx, @NotNull ProfileId profileId, boolean absenceStatus) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        FeatureConfig featureConfig = this.configService.getFeatureConfig(tenantId);
        if (!featureConfig.isAbsenceStatusEnabled()) {
            throw new UnsupportedFeatureException("Feature is not enabled");
        }
        if (!Intrinsics.areEqual((Object)profileId, (Object)authCtx.getProfileId())) {
            authCtx.check(Role.manage((String)profileId.toString()));
        }
        return AbsenceDto.Companion.toAbsenceDto(this.profileService.changeAbsenceStatus(profileId, absenceStatus), featureConfig);
    }

    @NotNull
    public AbsenceDto changeAbsenceNote(@NotNull AuthorizationContext authCtx, @NotNull ProfileId profileId, @NotNull String absenceNote) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)absenceNote, (String)"absenceNote");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        FeatureConfig featureConfig = this.configService.getFeatureConfig(tenantId);
        if (!featureConfig.isAbsenceNoteEnabled()) {
            throw new UnsupportedFeatureException("Feature is not enabled");
        }
        if (!Intrinsics.areEqual((Object)profileId, (Object)authCtx.getProfileId())) {
            authCtx.check(Role.manage((String)profileId.toString()));
        }
        if (!(absenceNote.length() <= 50)) {
            boolean bl = false;
            String string = "Absence information must be between 0 and 50 characters";
            throw new IllegalArgumentException(string.toString());
        }
        return AbsenceDto.Companion.toAbsenceDto(this.profileService.changeAbsenceNote(profileId, absenceNote), featureConfig);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, AbsenceDto> getAbsenceInformation(@NotNull AuthorizationContext authCtx, @NotNull Set<ProfileId> profileIds) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Collection<Object> collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        FeatureConfig featureConfig = this.configService.getFeatureConfig(tenantId);
        if (!featureConfig.isAbsenceStatusEnabled() && !featureConfig.isAbsenceNoteEnabled()) {
            throw new UnsupportedFeatureException("Feature is not enabled");
        }
        Iterable iterable = profileIds;
        Object object2 = authCtx;
        boolean $i$f$mapToSet = false;
        void var8_7 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profileId;
            object = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Role.read((String)profileId.toString()));
        }
        ImmutableMap immutableMap = object2.has((Set)destination$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"has(...)");
        ImmutableMap authorizedProfileIds = immutableMap;
        Set set = authorizedProfileIds.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-entries>(...)");
        Object $this$mapNotNullToSet$iv = set;
        boolean $i$f$mapNotNullToSet = false;
        $this$mapTo$iv$iv = $this$mapNotNullToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)entry);
            Role role = (Role)entry.getKey();
            AuthorizationResult result = (AuthorizationResult)entry.getValue();
            if ((result == AuthorizationResult.OK ? Companion.access$parseRole((Companion)Companion, (Role)role) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set filteredProfileIds = (Set)destination$iv$iv;
        $this$mapNotNullToSet$iv = this.profileService.getAbsenceInformationForProfiles(filteredProfileIds);
        boolean $i$f$mapValues = false;
        $this$mapNotNullTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            element$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object2 = object3;
            boolean bl4 = false;
            AbsenceDto absenceDto = AbsenceDto.Companion.toAbsenceDto((Absence)it.getValue(), featureConfig);
            object2.put(collection, absenceDto);
        }
        return destination$iv$iv;
    }
}

