/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import de.justsoftware.notificationclient.model.NotificationMail;
import de.justsoftware.notificationclient.model.NotificationMailItem;
import de.justsoftware.notificationservice.business.NotificationConfigProperties;
import de.justsoftware.notificationservice.model.ClusterPosition;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.DeliveryStatusRepository;
import de.justsoftware.notificationservice.persistence.NotificationRepository;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatus;
import de.justsoftware.notificationservice.persistence.model.DbNotification;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
class NotificationMailService {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationMailService.class);
    private ScheduledFuture<?> _activeNotificationMailCron;
    private final TaskScheduler _taskScheduler;
    private final RestOperations _jucoServiceInternalRestOperations;
    private final NotificationConfigProperties _notificationConfigProperties;
    private final NotificationRepository _notificationRepository;
    private final DeliveryStatusRepository _deliveryStatusRepository;
    private final int _notificationMailReceiverBatchSize;
    private final ClusterPosition _clusterPosition;

    @Autowired
    NotificationMailService(TaskScheduler notificationMailJobTaskScheduler, @Qualifier(value="JUCO_SERVICE_INTERNAL_REST_OPERATIONS") RestOperations restOperations, NotificationConfigProperties notificationConfigProperties, NotificationRepository notificationRepository, DeliveryStatusRepository deliveryStatusRepository, @Value(value="${service.notificationMailReceiverBatchSize : 100}") int notificationMailReceiverBatchSize, @Value(value="${service.clusterPosition}") ClusterPosition clusterPosition) {
        this._taskScheduler = notificationMailJobTaskScheduler;
        this._jucoServiceInternalRestOperations = restOperations;
        this._notificationConfigProperties = notificationConfigProperties;
        this._notificationRepository = notificationRepository;
        this._deliveryStatusRepository = deliveryStatusRepository;
        this._notificationMailReceiverBatchSize = notificationMailReceiverBatchSize;
        this._clusterPosition = clusterPosition;
    }

    @PostConstruct
    void afterPropertiesSet() {
        if (this._clusterPosition == ClusterPosition.SECONDARY) {
            return;
        }
        this._notificationConfigProperties.addMailCronListener(() -> this.startMailCron());
        this.startMailCron();
    }

    private void startMailCron() {
        String cronExpression;
        if (this._activeNotificationMailCron != null) {
            this._activeNotificationMailCron.cancel(false);
            LOG.info("Active NotificationMailCron was canceled due to a Zookeeper change.");
        }
        if ((cronExpression = this._notificationConfigProperties.getMailCron()) == null || cronExpression.isEmpty()) {
            LOG.info("Cron expression is empty. NotificationMailCron won't be started.");
            return;
        }
        try {
            LOG.info("Starting MailCron with {}.", (Object)cronExpression);
            this._activeNotificationMailCron = this._taskScheduler.schedule(() -> this.sendUnreadNotificationMails(), (Trigger)new CronTrigger(cronExpression));
        }
        catch (IllegalArgumentException e) {
            LOG.error("An illegal argument exception was raised. Make sure the supplied cron expression is valid.", (Throwable)e);
        }
    }

    @VisibleForTesting
    void sendNotificationMails(List<NotificationMail> notificationMails) throws RestClientException {
        LOG.info(String.format("Trying to send %d notification mails.", notificationMails.size()));
        ResponseEntity response = this._jucoServiceInternalRestOperations.postForEntity("/notification/mail", notificationMails, Void.class, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new RestClientException("Failed to send notification mails. Juco Internal REST API returned StatusCode: " + response.getStatusCode().value());
        }
        LOG.info("Successfully sent notification mails.");
    }

    @VisibleForTesting
    void sendUnreadNotificationMails() {
        List receivers = this._deliveryStatusRepository.distinctReceivers();
        Lists.partition((List)receivers, (int)this._notificationMailReceiverBatchSize).forEach(receiverBatch -> {
            List statusBatch = this._deliveryStatusRepository.getStatusWithActiveTriggerForReceivers((Iterable)receiverBatch);
            Map<String, List<DbDeliveryStatus>> statusBatchByReceiver = statusBatch.stream().collect(Collectors.groupingBy(DbDeliveryStatus::getReceiverId));
            Map countsBatch = this._deliveryStatusRepository.countByReceiverIdsAndStatusAsMap((Iterable)ImmutableSet.copyOf((Collection)receiverBatch), NotificationStatus.OPEN);
            List notifications = this._notificationRepository.findAllById((Iterable)statusBatch.stream().map(DbDeliveryStatus::getNotificationId).collect(ImmutableSet.toImmutableSet()));
            ImmutableMap notificationMap = (ImmutableMap)notifications.stream().collect(ImmutableMap.toImmutableMap(DbNotification::getId, (Function)Functions.identity()));
            List mails = statusBatchByReceiver.entrySet().stream().map(entry -> {
                String receiverId = (String)entry.getKey();
                List mailItems = ((List)entry.getValue()).stream().map(ds -> NotificationMailService.getNotificationMailItem((DbNotification)((DbNotification)notificationMap.get((Object)ds.getNotificationId())))).filter((Predicate<NotificationMailItem>)Predicates.notNull()).sorted(Comparator.comparing(NotificationMailItem::getTimestamp).reversed()).collect(Collectors.toList());
                int additionalMailCount = countsBatch.containsKey(receiverId) ? (Integer)countsBatch.get(receiverId) - mailItems.size() : 0;
                return new NotificationMail(receiverId, mailItems, additionalMailCount);
            }).collect(Collectors.toList());
            try {
                this.sendNotificationMails(mails);
            }
            catch (RestClientException e) {
                LOG.error("An error occurred while sending notification mails", (Throwable)e);
                LOG.warn(String.format("Marking %d mail(s) as sent anyways to prevent repeat spamming of the recipients", statusBatch.size()));
            }
            finally {
                this._deliveryStatusRepository.disableMailTriggers((Iterable)statusBatch);
            }
        });
    }

    @CheckForNull
    private static NotificationMailItem getNotificationMailItem(DbNotification dbNotification) {
        if (dbNotification == null) {
            return null;
        }
        return new NotificationMailItem(dbNotification.getAppId(), dbNotification.getDefaultTitle(), dbNotification.getDefaultText(), dbNotification.getTimestamp(), dbNotification.getLocalizedTitle(), dbNotification.getLocalizedText(), dbNotification.getDefaultSecondaryText(), dbNotification.getLocalizedSecondaryText(), dbNotification.getMailAuthorName(), dbNotification.getDefaultMailContainerName(), dbNotification.getLocalizedMailContainerName(), dbNotification.getDefaultMailReplacementText(), dbNotification.getLocalizedMailReplacementText(), dbNotification.getType(), dbNotification.getTargetId(), dbNotification.getPayload());
    }
}

