/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.internals.StreamsConfigUtils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamsProducer;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.ThreadMetrics;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;

class ActiveTaskCreator {
    private final TopologyMetadata topologyMetadata;
    private final StreamsConfig applicationConfig;
    private final StreamsMetricsImpl streamsMetrics;
    private final StateDirectory stateDirectory;
    private final ChangelogReader storeChangelogReader;
    private final ThreadCache cache;
    private final Time time;
    private final KafkaClientSupplier clientSupplier;
    private final String threadId;
    private final Logger log;
    private final Sensor createTaskSensor;
    private final StreamsProducer threadProducer;
    private final Map<TaskId, StreamsProducer> taskProducers;
    private final StreamsConfigUtils.ProcessingMode processingMode;
    private final boolean stateUpdaterEnabled;
    private final boolean processingThreadsEnabled;

    ActiveTaskCreator(TopologyMetadata topologyMetadata, StreamsConfig applicationConfig, StreamsMetricsImpl streamsMetrics, StateDirectory stateDirectory, ChangelogReader storeChangelogReader, ThreadCache cache, Time time, KafkaClientSupplier clientSupplier, String threadId, UUID processId, Logger log, boolean stateUpdaterEnabled, boolean processingThreadsEnabled) {
        this.topologyMetadata = topologyMetadata;
        this.applicationConfig = applicationConfig;
        this.streamsMetrics = streamsMetrics;
        this.stateDirectory = stateDirectory;
        this.storeChangelogReader = storeChangelogReader;
        this.cache = cache;
        this.time = time;
        this.clientSupplier = clientSupplier;
        this.threadId = threadId;
        this.log = log;
        this.stateUpdaterEnabled = stateUpdaterEnabled;
        this.processingThreadsEnabled = processingThreadsEnabled;
        this.createTaskSensor = ThreadMetrics.createTaskSensor(threadId, streamsMetrics);
        this.processingMode = StreamsConfigUtils.processingMode(applicationConfig);
        if (this.processingMode == StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_ALPHA) {
            this.threadProducer = null;
            this.taskProducers = new HashMap<TaskId, StreamsProducer>();
        } else {
            log.info("Creating thread producer client");
            String threadIdPrefix = String.format("stream-thread [%s] ", Thread.currentThread().getName());
            LogContext logContext = new LogContext(threadIdPrefix);
            this.threadProducer = new StreamsProducer(applicationConfig, threadId, clientSupplier, null, processId, logContext, time);
            this.taskProducers = Collections.emptyMap();
        }
    }

    public void reInitializeThreadProducer() {
        this.threadProducer.resetProducer();
    }

    StreamsProducer streamsProducerForTask(TaskId taskId) {
        if (this.processingMode != StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_ALPHA) {
            throw new IllegalStateException("Expected EXACTLY_ONCE to be enabled, but the processing mode was " + (Object)((Object)this.processingMode));
        }
        StreamsProducer taskProducer = this.taskProducers.get(taskId);
        if (taskProducer == null) {
            throw new IllegalStateException("Unknown TaskId: " + taskId);
        }
        return taskProducer;
    }

    StreamsProducer threadProducer() {
        if (this.processingMode == StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_ALPHA) {
            throw new IllegalStateException("Expected AT_LEAST_ONCE or EXACTLY_ONCE_V2 to be enabled, but the processing mode was " + (Object)((Object)this.processingMode));
        }
        return this.threadProducer;
    }

    public Collection<Task> createTasks(Consumer<byte[], byte[]> consumer, Map<TaskId, Set<TopicPartition>> tasksToBeCreated) {
        ArrayList<Task> createdTasks = new ArrayList<Task>();
        for (Map.Entry<TaskId, Set<TopicPartition>> newTaskAndPartitions : tasksToBeCreated.entrySet()) {
            TaskId taskId = newTaskAndPartitions.getKey();
            LogContext logContext = this.getLogContext(taskId);
            Set<TopicPartition> partitions = newTaskAndPartitions.getValue();
            ProcessorTopology topology = this.topologyMetadata.buildSubtopology(taskId);
            ProcessorStateManager stateManager = new ProcessorStateManager(taskId, Task.TaskType.ACTIVE, StreamsConfigUtils.eosEnabled(this.applicationConfig), logContext, this.stateDirectory, this.storeChangelogReader, topology.storeToChangelogTopic(), partitions, this.stateUpdaterEnabled);
            ProcessorContextImpl context = new ProcessorContextImpl(taskId, this.applicationConfig, stateManager, this.streamsMetrics, this.cache);
            createdTasks.add(this.createActiveTask(taskId, partitions, consumer, logContext, topology, stateManager, context));
        }
        return createdTasks;
    }

    private RecordCollector createRecordCollector(TaskId taskId, LogContext logContext, ProcessorTopology topology) {
        StreamsProducer streamsProducer;
        if (this.processingMode == StreamsConfigUtils.ProcessingMode.EXACTLY_ONCE_ALPHA) {
            this.log.info("Creating producer client for task {}", (Object)taskId);
            streamsProducer = new StreamsProducer(this.applicationConfig, this.threadId, this.clientSupplier, taskId, null, logContext, this.time);
            this.taskProducers.put(taskId, streamsProducer);
        } else {
            streamsProducer = this.threadProducer;
        }
        return new RecordCollectorImpl(logContext, taskId, streamsProducer, this.applicationConfig.defaultProductionExceptionHandler(), this.streamsMetrics, topology);
    }

    StreamTask createActiveTaskFromStandby(StandbyTask standbyTask, Set<TopicPartition> inputPartitions, Consumer<byte[], byte[]> consumer) {
        if (!inputPartitions.equals(standbyTask.inputPartitions)) {
            this.log.warn("Detected unmatched input partitions for task {} when recycling it from standby to active", (Object)standbyTask.id);
        }
        standbyTask.prepareRecycle();
        standbyTask.stateMgr.transitionTaskType(Task.TaskType.ACTIVE, this.getLogContext(standbyTask.id));
        RecordCollector recordCollector = this.createRecordCollector(standbyTask.id, this.getLogContext(standbyTask.id), standbyTask.topology);
        StreamTask task = new StreamTask(standbyTask.id, inputPartitions, standbyTask.topology, consumer, standbyTask.config, this.streamsMetrics, this.stateDirectory, this.cache, this.time, standbyTask.stateMgr, recordCollector, standbyTask.processorContext, standbyTask.logContext, this.processingThreadsEnabled);
        this.log.trace("Created active task {} from recycled standby task with assigned partitions {}", (Object)task.id, inputPartitions);
        this.createTaskSensor.record();
        return task;
    }

    private StreamTask createActiveTask(TaskId taskId, Set<TopicPartition> inputPartitions, Consumer<byte[], byte[]> consumer, LogContext logContext, ProcessorTopology topology, ProcessorStateManager stateManager, InternalProcessorContext<Object, Object> context) {
        RecordCollector recordCollector = this.createRecordCollector(taskId, logContext, topology);
        StreamTask task = new StreamTask(taskId, inputPartitions, topology, consumer, this.topologyMetadata.getTaskConfigFor(taskId), this.streamsMetrics, this.stateDirectory, this.cache, this.time, stateManager, recordCollector, context, logContext, this.processingThreadsEnabled);
        this.log.trace("Created active task {} with assigned partitions {}", (Object)taskId, inputPartitions);
        this.createTaskSensor.record();
        return task;
    }

    void closeThreadProducerIfNeeded() {
        if (this.threadProducer != null) {
            try {
                this.threadProducer.close();
            }
            catch (RuntimeException e) {
                throw new StreamsException("Thread producer encounter error trying to close.", e);
            }
        }
    }

    void closeAndRemoveTaskProducerIfNeeded(TaskId id) {
        StreamsProducer taskProducer = this.taskProducers.remove(id);
        if (taskProducer != null) {
            try {
                taskProducer.close();
            }
            catch (RuntimeException e) {
                throw new StreamsException("[" + id + "] task producer encounter error trying to close.", e, id);
            }
        }
    }

    Map<MetricName, Metric> producerMetrics() {
        Collection<StreamsProducer> producers = this.threadProducer != null ? Collections.singleton(this.threadProducer) : this.taskProducers.values();
        return ClientUtils.producerMetrics(producers);
    }

    Set<String> producerClientIds() {
        if (this.threadProducer != null) {
            return Collections.singleton(ClientUtils.getThreadProducerClientId(this.threadId));
        }
        return this.taskProducers.keySet().stream().map(taskId -> ClientUtils.getTaskProducerClientId(this.threadId, taskId)).collect(Collectors.toSet());
    }

    private LogContext getLogContext(TaskId taskId) {
        String threadIdPrefix = String.format("stream-thread [%s] ", Thread.currentThread().getName());
        String logPrefix = threadIdPrefix + String.format("%s [%s] ", "stream-task", taskId);
        return new LogContext(logPrefix);
    }

    public double totalProducerBlockedTime() {
        if (this.threadProducer != null) {
            return this.threadProducer.totalBlockedTime();
        }
        return this.taskProducers.values().stream().mapToDouble(StreamsProducer::totalBlockedTime).sum();
    }
}

