/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.controller.PartitionReassignmentReplicas;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;

class PartitionReassignmentRevert {
    private final List<Integer> replicas;
    private final List<Integer> isr;
    private final boolean unclean;

    PartitionReassignmentRevert(PartitionRegistration registration) {
        PartitionReassignmentReplicas ongoingReassignment = new PartitionReassignmentReplicas(Replicas.toList(registration.removingReplicas), Replicas.toList(registration.addingReplicas), Replicas.toList(registration.replicas));
        this.replicas = ongoingReassignment.originalReplicas();
        this.isr = Replicas.toList(registration.isr);
        this.isr.removeAll(ongoingReassignment.adding());
        if (this.isr.isEmpty()) {
            if (this.replicas.isEmpty()) {
                throw new InvalidReplicaAssignmentException("Invalid replica assignment: addingReplicas contains all replicas.");
            }
            this.isr.add(this.replicas.get(0));
            this.unclean = true;
        } else {
            this.unclean = false;
        }
    }

    List<Integer> replicas() {
        return this.replicas;
    }

    List<Integer> isr() {
        return this.isr;
    }

    boolean unclean() {
        return this.unclean;
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.isr, this.unclean);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PartitionReassignmentRevert)) {
            return false;
        }
        PartitionReassignmentRevert other = (PartitionReassignmentRevert)o;
        return this.replicas.equals(other.replicas) && this.isr.equals(other.isr) && this.unclean == other.unclean;
    }

    public String toString() {
        return "PartitionReassignmentRevert(replicas=" + this.replicas + ", isr=" + this.isr + ", unclean=" + this.unclean + ")";
    }
}

