/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.monitoring.business;

import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import de.justsoftware.onx.monitoring.business.ToroHealthIndicator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

@Component(value="memcached")
@ParametersAreNonnullByDefault
public class MemcachedHealthIndicator
extends ToroHealthIndicator {
    public static final String NAME = "memcached";
    private final MemcachedClientCache _memcachedClient;

    @Autowired
    public MemcachedHealthIndicator(MemcachedClientCache memcachedClient) {
        this._memcachedClient = memcachedClient;
    }

    protected void doHealthCheck(Health.Builder builder) {
        try {
            this._memcachedClient.testCache();
            builder.up();
        }
        catch (InterruptedException e) {
            String message = "Cache request failed due to thread interruption";
            this.handleError(builder, NAME, "Cache request failed due to thread interruption", (Throwable)e);
        }
        catch (ExecutionException e) {
            String message = "Cache request failed due to execution";
            this.handleError(builder, NAME, "Cache request failed due to execution", (Throwable)e);
        }
        catch (TimeoutException e) {
            String message = "Cache request failed due to timeout";
            this.handleError(builder, NAME, "Cache request failed due to timeout", (Throwable)e);
        }
    }
}

