/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.search.authorization.AuthorizationContext;
import de.justsoftware.search.config.AuthorizationContextResolver;
import de.justsoftware.search.exception.UnauthorizedException;
import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.TenantId;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J\u001c\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J\u001c\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/search/config/AuthorizationContextResolver;", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "toroBaseUrl", "", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "rest", "Lorg/springframework/web/client/RestTemplate;", "<init>", "(Ljava/lang/String;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/springframework/web/client/RestTemplate;)V", "supportsParameter", "", "parameter", "Lorg/springframework/core/MethodParameter;", "resolveArgument", "Lde/justsoftware/search/authorization/AuthorizationContext;", "mavContainer", "Lorg/springframework/web/method/support/ModelAndViewContainer;", "webRequest", "Lorg/springframework/web/context/request/NativeWebRequest;", "binderFactory", "Lorg/springframework/web/bind/support/WebDataBinderFactory;", "currentPersonInfo", "", "authentication", "Lorg/springframework/security/oauth2/server/resource/authentication/BearerTokenAuthentication;", "profileId", "Lde/justsoftware/search/shared/model/ProfileId;", "Lde/justsoftware/jwtfilter/JwtAuthenticationToken;", "tenantId", "Lde/justsoftware/search/shared/model/TenantId;", "Companion", "search-service"})
@SourceDebugExtension(value={"SMAP\nAuthorizationContextResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationContextResolver.kt\nde/justsoftware/search/config/AuthorizationContextResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LoggerUtils.kt\nde/justsoftware/search/util/LoggerUtilsKt\n*L\n1#1,152:1\n1187#2,2:153\n1261#2,4:155\n8#3:159\n7#3,3:160\n*S KotlinDebug\n*F\n+ 1 AuthorizationContextResolver.kt\nde/justsoftware/search/config/AuthorizationContextResolver\n*L\n89#1:153,2\n89#1:155,4\n149#1:159\n149#1:160,3\n*E\n"})
public final class AuthorizationContextResolver
implements HandlerMethodArgumentResolver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final RestTemplate rest;
    @NotNull
    private static final Logger LOG;

    public AuthorizationContextResolver(@NotNull String toroBaseUrl, @NotNull ObjectMapper objectMapper, @NotNull RestTemplate rest) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        this.toroBaseUrl = toroBaseUrl;
        this.objectMapper = objectMapper;
        this.rest = rest;
    }

    public /* synthetic */ AuthorizationContextResolver(String string, ObjectMapper objectMapper, RestTemplate restTemplate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            restTemplate = new RestTemplate();
        }
        this(string, objectMapper, restTemplate);
    }

    public boolean supportsParameter(@NotNull MethodParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return Intrinsics.areEqual(AuthorizationContext.class, (Object)parameter.getParameterType());
    }

    @NotNull
    public AuthorizationContext resolveArgument(@NotNull MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, @NotNull NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws UnauthorizedException {
        AuthorizationContext authorizationContext;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter((Object)webRequest, (String)"webRequest");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnauthorizedException("You must be logged in to perform this request");
        }
        Authentication authentication2 = authentication;
        Authentication authentication3 = authentication2;
        if (authentication3 instanceof JwtAuthenticationToken) {
            authorizationContext = new AuthorizationContext(this.profileId((JwtAuthenticationToken)authentication2), this.tenantId((JwtAuthenticationToken)authentication2));
        } else if (authentication3 instanceof BearerTokenAuthentication) {
            Map currentPersonInfo = this.currentPersonInfo((BearerTokenAuthentication)authentication2);
            authorizationContext = new AuthorizationContext(this.profileId(currentPersonInfo), this.tenantId(currentPersonInfo));
        } else {
            LOG.warn("We received an unknown type of authentication: " + authentication2.getClass().getName());
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return authorizationContext;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> currentPersonInfo(BearerTokenAuthentication authentication) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + ((OAuth2AccessToken)authentication.getToken()).getTokenValue());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.rest.exchange(this.toroBaseUrl + "/api/v1/person/current", HttpMethod.GET, request, String.class, new Object[0]);
        boolean bl = false;
        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.warn("Failed to retrieve person info from toro internal API: " + response.getStatusCode());
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        Iterable iterable = ((Map)this.objectMapper.readValue((String)response.getBody(), Map.class)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var9_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Object key = entry.getKey();
            Object value = entry.getValue();
            entry = TuplesKt.to((Object)String.valueOf(key), (Object)String.valueOf(value));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv;
    }

    private final ProfileId profileId(JwtAuthenticationToken authentication) {
        ProfileId profileId;
        String principal = authentication.getPrincipal().toString();
        try {
            profileId = ProfileId.Companion.fromCanonicalId(principal);
        }
        catch (IllegalStateException ex) {
            LOG.warn("We received an unparsable profile ID: '" + principal + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return profileId;
    }

    private final ProfileId profileId(Map<String, String> currentPersonInfo) {
        ProfileId profileId;
        String profileIdString = currentPersonInfo.get("id");
        if (profileIdString == null) {
            LOG.warn("Failed to extract profile id from internal toro API response");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            profileId = ProfileId.Companion.fromCanonicalId(profileIdString);
        }
        catch (IllegalStateException ex) {
            LOG.warn("Received an unparsable profile ID from toro: '" + profileIdString + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return profileId;
    }

    private final TenantId tenantId(JwtAuthenticationToken authentication) {
        TenantId tenantId;
        Object object = authentication.getCustomJwtClaims().get((Object)"tenantId");
        if (object == null) {
            throw new UnauthorizedException("You must be logged in a valid tenant");
        }
        Object tenantId2 = object;
        try {
            tenantId = TenantId.Companion.fromCanonicalId(tenantId2.toString());
        }
        catch (IllegalStateException ex) {
            LOG.warn("We received an unparsable tenant ID: '" + tenantId2 + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return tenantId;
    }

    private final TenantId tenantId(Map<String, String> currentPersonInfo) {
        TenantId tenantId;
        String tenantIdString = currentPersonInfo.get("tenantId");
        if (tenantIdString == null) {
            LOG.warn("Failed to extract tenant id from internal toro API response");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        try {
            tenantId = TenantId.Companion.fromCanonicalId(tenantIdString);
        }
        catch (IllegalStateException ex) {
            LOG.warn("Received an unparsable tenant ID from toro: '" + tenantIdString + "'");
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        return tenantId;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

