/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.persistence;

import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@FunctionalInterface
@ParametersAreNonnullByDefault
public interface RowMapper<T> {
    @Nonnull
    public T mapRow(ResultSet var1) throws SQLException;

    @Nonnull
    default public <R> RowMapper<R> map(Function<T, R> f) {
        return rs -> f.apply(this.mapRow(rs));
    }

    @Nonnull
    public static <K, V> RowMapper<Map.Entry<K, V>> entryMapper(RowMapper<K> keyRowMapper, RowMapper<V> valueRowMapper) {
        return rs -> Maps.immutableEntry((Object)keyRowMapper.mapRow(rs), (Object)valueRowMapper.mapRow(rs));
    }

    @Nonnull
    public static RowMapper<String> stringCol(String column) {
        return rs -> rs.getString(column);
    }

    @Nonnull
    public static RowMapper<Long> longCol(String column) {
        return rs -> rs.getLong(column);
    }
}

