/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.kafka.impl;

import com.google.common.base.Suppliers;
import de.justsoftware.permission.kafka.KafkaConfigurationProvider;
import de.justsoftware.permission.persistence.NodeStateDAO;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
@DependsOn(value={"liquibase"})
public class KafkaConfigurationProviderImpl
implements KafkaConfigurationProvider {
    private static final Integer KAFKA_PRODUCER_BUFFER_MEMORY = 0x2000000;
    private static final Integer KAFKA_PRODUCER_BATCH_SIZE = 16384;
    private final String _bootstrapServers;
    private final int _maxChunkSize;
    private final Supplier<String> _consumerGroupIdentifierSupplier;
    private final boolean _kafkaEnabled;

    @Autowired
    public KafkaConfigurationProviderImpl(@Nullable @Value(value="${kafka.boostrapServers:}") String bootstrapServers, @Value(value="${kafka.consumerMaxChunkSize:500}") int maxChunkSize, @Value(value="${kafka.enabled:true}") boolean kafkaEnabled, NodeStateDAO keyValueDAO) {
        this._kafkaEnabled = kafkaEnabled;
        this._bootstrapServers = StringUtils.trimToNull((String)bootstrapServers);
        this._maxChunkSize = maxChunkSize;
        this._consumerGroupIdentifierSupplier = Suppliers.memoize(() -> keyValueDAO.getValueOrStoreDefault("KAFKA_CONSUMER_GROUP_IDENTIFIER", UUID.randomUUID().toString()));
    }

    @CheckForNull
    private Properties consumerConfig(@Nullable String groupId, int maxChunkSize) {
        if (this._bootstrapServers == null) {
            return null;
        }
        Properties props = new Properties();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("enable.auto.commit", "false");
        props.put("auto.offset.reset", "earliest");
        props.put("max.poll.records", (Object)maxChunkSize);
        if (groupId != null) {
            props.put("group.id", groupId);
        }
        return props;
    }

    public Properties producerConfig() {
        if (this._bootstrapServers == null) {
            return null;
        }
        Properties props = new Properties();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("acks", "all");
        props.put("retries", (Object)0);
        props.put("batch.size", KAFKA_PRODUCER_BATCH_SIZE);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", KAFKA_PRODUCER_BUFFER_MEMORY);
        return props;
    }

    public Consumer<String, String> stringConsumer(@Nullable String groupId) {
        return this.stringConsumer(groupId, this._maxChunkSize);
    }

    public Consumer<String, String> stringConsumer(@Nullable String groupId, int maxChunkSize) {
        return this.consumer(groupId, (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer(), maxChunkSize);
    }

    @CheckForNull
    private <K, V> Consumer<K, V> consumer(@Nullable String groupId, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, int maxChunkSize) {
        Properties config = this.consumerConfig(groupId, maxChunkSize);
        if (config == null) {
            return null;
        }
        return new KafkaConsumer(config, keyDeserializer, valueDeserializer);
    }

    public String getKafkaGroupIdentifier() {
        return (String)this._consumerGroupIdentifierSupplier.get();
    }

    public boolean isKafkaEnabled() {
        return this._kafkaEnabled;
    }
}

