/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.post;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.InputArgument;
import de.justsoftware.news.domain.attachment.AttachmentDataLoader;
import de.justsoftware.news.domain.channel.ChannelDataLoader;
import de.justsoftware.news.domain.post.AllowedPostActionsDataLoader;
import de.justsoftware.news.domain.post.CommentCountByPostIds;
import de.justsoftware.news.domain.post.CommentDataLoader;
import de.justsoftware.news.domain.post.CommentKey;
import de.justsoftware.news.domain.post.CommentNotificationsEnabledBatchLoader;
import de.justsoftware.news.domain.post.PollDataLoader;
import de.justsoftware.news.domain.post.PollKeyContext;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.reaction.ReactionDataLoader;
import de.justsoftware.news.domain.user.ProfileDataLoader;
import de.justsoftware.news.graphql.generated.types.Attachment;
import de.justsoftware.news.graphql.generated.types.Channel;
import de.justsoftware.news.graphql.generated.types.Comment;
import de.justsoftware.news.graphql.generated.types.Likes;
import de.justsoftware.news.graphql.generated.types.Poll;
import de.justsoftware.news.graphql.generated.types.Post;
import de.justsoftware.news.graphql.generated.types.Profile;
import de.justsoftware.news.graphql.generated.types.Reaction;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.util.Sort;
import graphql.execution.DataFetcherResult;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u00052\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\b\u001a\u00020\tH\u0017\u00a8\u0006!"}, d2={"Lde/justsoftware/news/domain/post/PostDataFetcher;", "", "<init>", "()V", "attachments", "Ljava/util/concurrent/CompletableFuture;", "", "Lde/justsoftware/news/graphql/generated/types/Attachment;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "author", "Lde/justsoftware/news/graphql/generated/types/Profile;", "editor", "channel", "Lde/justsoftware/news/graphql/generated/types/Channel;", "comments", "Lde/justsoftware/news/graphql/generated/types/Comment;", "sort", "Lde/justsoftware/news/util/Sort;", "commentNotificationsEnabled", "", "poll", "Lde/justsoftware/news/graphql/generated/types/Poll;", "reactions", "Lde/justsoftware/news/graphql/generated/types/Reaction;", "commentCount", "", "allowedActions", "", "Lde/justsoftware/news/domain/post/model/PostAction;", "likes", "Lgraphql/execution/DataFetcherResult;", "Lde/justsoftware/news/graphql/generated/types/Likes;", "news-service"})
public class PostDataFetcher {
    @DgsData(parentType="Post", field="attachments")
    @NotNull
    public CompletableFuture<List<Attachment>> attachments(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(AttachmentDataLoader.class);
        PostId postId = ((Post)dfe.getSourceOrThrow()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="author")
    @NotNull
    public CompletableFuture<Profile> author(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        ProfileId authorId = ((Post)dfe.getSourceOrThrow()).getAuthorId();
        CompletableFuture completableFuture = dataLoader.load((Object)authorId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="editor")
    @NotNull
    public CompletableFuture<Profile> editor(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        ProfileId profileId = ((Post)dfe.getSourceOrThrow()).getEditorId();
        if (profileId == null) {
            CompletableFuture<Profile> completableFuture = CompletableFuture.supplyAsync(PostDataFetcher::editor$lambda$0);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
            return completableFuture;
        }
        ProfileId editorId = profileId;
        DataLoader dataLoader = dfe.getDataLoader(ProfileDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)editorId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="channel")
    @NotNull
    public CompletableFuture<Channel> channel(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ChannelDataLoader.class);
        ChannelId channelId = ((Post)dfe.getSourceOrThrow()).getChannelId();
        CompletableFuture completableFuture = dataLoader.load((Object)channelId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="comments")
    @NotNull
    public CompletableFuture<Comment> comments(@InputArgument @NotNull Sort sort, @NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Post post = (Post)dfe.getSourceOrThrow();
        DataLoader dataLoader = dfe.getDataLoader(CommentDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)new CommentKey(post.getId(), sort, post.getTranslationContext().getTargetLanguage()));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="commentNotificationsEnabled")
    @NotNull
    public CompletableFuture<Boolean> commentNotificationsEnabled(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = ((Post)dfe.getSourceOrThrow()).getId();
        DataLoader dataLoader = dfe.getDataLoader(CommentNotificationsEnabledBatchLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="poll")
    @NotNull
    public CompletableFuture<Poll> poll(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(PollDataLoader.class);
        Post post = (Post)dfe.getSourceOrThrow();
        CompletableFuture completableFuture = dataLoader.load((Object)post.getId(), (Object)new PollKeyContext(post.getTranslationContext().getSourceLanguage(), post.getTranslationContext().getTargetLanguage()));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="reactions")
    @NotNull
    public CompletableFuture<Reaction> reactions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataLoader dataLoader = dfe.getDataLoader(ReactionDataLoader.class);
        PostId postId = ((Post)dfe.getSourceOrThrow()).getId();
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="commentCount")
    @NotNull
    public CompletableFuture<Integer> commentCount(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = ((Post)dfe.getSourceOrThrow()).getId();
        DataLoader dataLoader = dfe.getDataLoader(CommentCountByPostIds.class);
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="allowedActions")
    @NotNull
    public CompletableFuture<Set<PostAction>> allowedActions(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        PostId postId = ((Post)dfe.getSourceOrThrow()).getId();
        DataLoader dataLoader = dfe.getDataLoader(AllowedPostActionsDataLoader.class);
        CompletableFuture completableFuture = dataLoader.load((Object)postId);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"load(...)");
        return completableFuture;
    }

    @DgsData(parentType="Post", field="likes")
    @NotNull
    public DataFetcherResult<Likes> likes(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        DataFetcherResult dataFetcherResult = DataFetcherResult.newResult().data((Object)new Likes(null, null, null, 7, null)).localContext((Object)((Post)dfe.getSourceOrThrow()).getId()).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetcherResult, (String)"build(...)");
        return dataFetcherResult;
    }

    private static final Profile editor$lambda$0() {
        return null;
    }
}

