/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.wiki.service;

import de.justsoftware.mobile.gateway.common.service.UrlService;
import de.justsoftware.mobile.gateway.exception.InvalidWikiIdType;
import de.justsoftware.mobile.gateway.settings.model.PlatformSettings;
import de.justsoftware.mobile.gateway.settings.service.SettingsService;
import de.justsoftware.mobile.gateway.util.NumbersKt;
import de.justsoftware.mobile.gateway.wiki.generated.apis.WikiControllerApi;
import de.justsoftware.mobile.gateway.wiki.generated.models.ArticleDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.ChapterDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.Direction;
import de.justsoftware.mobile.gateway.wiki.generated.models.Sort;
import de.justsoftware.mobile.gateway.wiki.generated.models.SubscriptionDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.TranslatablePageDtoPreviewDtoObject;
import de.justsoftware.mobile.gateway.wiki.generated.models.TranslatablePageDtoWikiPreviewDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.TranslationMetaDataArticleDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.TranslationMetaDataChapterDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.TranslationMetaDataWikiDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.UpdateSubscriptionDto;
import de.justsoftware.mobile.gateway.wiki.generated.models.WikiDto;
import de.justsoftware.mobile.gateway.wiki.model.local.LinkValidationResult;
import de.justsoftware.mobile.gateway.wiki.model.local.ParentTitle;
import de.justsoftware.mobile.gateway.wiki.model.local.Subscription;
import de.justsoftware.mobile.gateway.wiki.model.local.UpdateWikiArticleData;
import de.justsoftware.mobile.gateway.wiki.model.local.Wiki;
import de.justsoftware.mobile.gateway.wiki.model.local.WikiArticle;
import de.justsoftware.mobile.gateway.wiki.model.local.WikiChapter;
import de.justsoftware.mobile.gateway.wiki.model.local.WikiIdType;
import de.justsoftware.mobile.gateway.wiki.model.local.WikiIdTypeKt;
import de.justsoftware.mobile.gateway.wiki.model.local.WikiItem;
import de.justsoftware.mobile.gateway.wiki.model.remote.ArticleDtosKt;
import de.justsoftware.mobile.gateway.wiki.model.remote.ChapterDtosKt;
import de.justsoftware.mobile.gateway.wiki.model.remote.SubscriptionDtosKt;
import de.justsoftware.mobile.gateway.wiki.model.remote.TranslatablePageDtoPreviewDtoObjectsKt;
import de.justsoftware.mobile.gateway.wiki.model.remote.TranslatablePageDtoWikiPreviewDtosKt;
import de.justsoftware.mobile.gateway.wiki.model.remote.UpdateWikiArticleDtosKt;
import de.justsoftware.mobile.gateway.wiki.service.WikiService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\u0011H\u0016J*\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\u0011H\u0016J\u0016\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110'H\u0016J\u001a\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lde/justsoftware/mobile/gateway/wiki/service/WikiService;", "", "urlService", "Lde/justsoftware/mobile/gateway/common/service/UrlService;", "wikiControllerApi", "Lde/justsoftware/mobile/gateway/wiki/generated/apis/WikiControllerApi;", "settingsService", "Lde/justsoftware/mobile/gateway/settings/service/SettingsService;", "<init>", "(Lde/justsoftware/mobile/gateway/common/service/UrlService;Lde/justsoftware/mobile/gateway/wiki/generated/apis/WikiControllerApi;Lde/justsoftware/mobile/gateway/settings/service/SettingsService;)V", "getWikiTeasers", "", "Lde/justsoftware/mobile/gateway/wiki/model/local/WikiItem;", "offset", "", "limit", "translationLanguage", "", "getSubscribedWikiItems", "getWiki", "Lde/justsoftware/mobile/gateway/wiki/model/local/Wiki;", "wikiId", "updateSubscription", "Lde/justsoftware/mobile/gateway/wiki/model/local/Subscription;", "isSubscribed", "", "getWikiChapter", "Lde/justsoftware/mobile/gateway/wiki/model/local/WikiChapter;", "chapterId", "getWikiArticle", "Lde/justsoftware/mobile/gateway/wiki/model/local/WikiArticle;", "articleId", "tenantId", "updateWikiArticle", "updateWikiArticleData", "Lde/justsoftware/mobile/gateway/wiki/model/local/UpdateWikiArticleData;", "validateInternalLinks", "Lde/justsoftware/mobile/gateway/wiki/model/local/LinkValidationResult;", "linkIds", "", "getParentTitle", "Lde/justsoftware/mobile/gateway/wiki/model/local/ParentTitle;", "wikiItemId", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nWikiService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WikiService.kt\nde/justsoftware/mobile/gateway/wiki/service/WikiService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public class WikiService {
    @NotNull
    private final UrlService urlService;
    @NotNull
    private final WikiControllerApi wikiControllerApi;
    @NotNull
    private final SettingsService settingsService;

    public WikiService(@NotNull UrlService urlService, @NotNull WikiControllerApi wikiControllerApi, @NotNull SettingsService settingsService) {
        Intrinsics.checkNotNullParameter((Object)urlService, (String)"urlService");
        Intrinsics.checkNotNullParameter((Object)wikiControllerApi, (String)"wikiControllerApi");
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        this.urlService = urlService;
        this.wikiControllerApi = wikiControllerApi;
        this.settingsService = settingsService;
    }

    @NotNull
    public List<WikiItem> getWikiTeasers(int offset, int limit, @Nullable String translationLanguage) {
        return TranslatablePageDtoWikiPreviewDtosKt.toWikiItems((TranslatablePageDtoWikiPreviewDto)this.wikiControllerApi.getWikiPreviews(Integer.valueOf(limit > 0 ? NumbersKt.ceilDiv((int)offset, (int)limit) : 0), Integer.valueOf(limit), Sort.SUBSCRIBED, Direction.DESCENDING, translationLanguage));
    }

    @NotNull
    public List<WikiItem> getSubscribedWikiItems(int offset, int limit, @Nullable String translationLanguage) {
        return TranslatablePageDtoPreviewDtoObjectsKt.toWikiItems((TranslatablePageDtoPreviewDtoObject)WikiControllerApi.getSubscribedItems$default((WikiControllerApi)this.wikiControllerApi, null, (Integer)200, (String)translationLanguage, (int)1, null), (int)offset, (int)limit);
    }

    @NotNull
    public Wiki getWiki(@NotNull String wikiId, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        return (Wiki)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public Subscription updateSubscription(@NotNull String wikiId, boolean isSubscribed) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        return SubscriptionDtosKt.toSubscription((SubscriptionDto)this.wikiControllerApi.createOrUpdateSubscription(new UpdateSubscriptionDto(isSubscribed, wikiId)));
    }

    @NotNull
    public WikiChapter getWikiChapter(@NotNull String chapterId, @Nullable String translationLanguage) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        ChapterDto chapterDto = this.wikiControllerApi.getChapter(chapterId, translationLanguage);
        ParentTitle parentTitle = this.getParentTitle(chapterDto.getParentId(), translationLanguage);
        return ChapterDtosKt.toWikiChapter((ChapterDto)chapterDto, (ParentTitle)parentTitle, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public WikiArticle getWikiArticle(@NotNull String articleId, @Nullable String translationLanguage, @NotNull String tenantId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        PlatformSettings platformSettings = this.settingsService.getPlatformSettings(tenantId);
        ArticleDto articleDto = WikiControllerApi.getArticle$default((WikiControllerApi)this.wikiControllerApi, (String)articleId, null, (String)translationLanguage, (int)2, null);
        ParentTitle parentTitle = this.getParentTitle(articleDto.getParentId(), translationLanguage);
        return ArticleDtosKt.toWikiArticle((ArticleDto)articleDto, (ParentTitle)parentTitle, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (boolean)platformSettings.getMobileEditWikiArticleEnabled());
    }

    @NotNull
    public WikiArticle updateWikiArticle(@NotNull String articleId, @NotNull UpdateWikiArticleData updateWikiArticleData, @Nullable String translationLanguage, @NotNull String tenantId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updateWikiArticleData, (String)"updateWikiArticleData");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        PlatformSettings platformSettings = this.settingsService.getPlatformSettings(tenantId);
        if (!platformSettings.getMobileEditWikiArticleEnabled()) {
            throw new NotImplementedError(null, 1, null);
        }
        this.wikiControllerApi.updateArticle(articleId, UpdateWikiArticleDtosKt.toUpdateArticleDto((UpdateWikiArticleData)updateWikiArticleData));
        return this.getWikiArticle(articleId, translationLanguage, tenantId);
    }

    @NotNull
    public LinkValidationResult validateInternalLinks(@NotNull Set<String> linkIds) {
        Intrinsics.checkNotNullParameter(linkIds, (String)"linkIds");
        Map p0 = this.wikiControllerApi.getLinkStatus(linkIds);
        boolean bl = false;
        return new LinkValidationResult(p0);
    }

    private ParentTitle getParentTitle(String wikiItemId, String translationLanguage) {
        WikiIdType wikiIdType = WikiIdTypeKt.getWikiIdType((String)wikiItemId);
        return switch (wikiIdType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[wikiIdType.ordinal()]) {
            case 1 -> {
                TranslationMetaDataWikiDto v2;
                WikiDto wikiDto = this.wikiControllerApi.getWiki(wikiItemId, translationLanguage);
                boolean $i$a$-let-WikiService$getParentTitle$1 = false;
                yield new ParentTitle(wikiDto.getTitle(), (v2 = wikiDto.getTranslationMetaData()) != null && (v2 = v2.getSourceData()) != null ? v2.getTitle() : null);
            }
            case 2 -> {
                TranslationMetaDataChapterDto v3;
                ChapterDto chapterDto = this.wikiControllerApi.getChapter(wikiItemId, translationLanguage);
                boolean $i$a$-let-WikiService$getParentTitle$2 = false;
                yield new ParentTitle(chapterDto.getTitle(), (v3 = chapterDto.getTranslationMetaData()) != null && (v3 = v3.getSourceData()) != null ? v3.getTitle() : null);
            }
            case 3 -> {
                TranslationMetaDataArticleDto v4;
                ArticleDto articleDto = WikiControllerApi.getArticle$default((WikiControllerApi)this.wikiControllerApi, (String)wikiItemId, null, (String)translationLanguage, (int)2, null);
                boolean $i$a$-let-WikiService$getParentTitle$3 = false;
                yield new ParentTitle(articleDto.getTitle(), (v4 = articleDto.getTranslationMetaData()) != null && (v4 = v4.getSourceData()) != null ? v4.getTitle() : null);
            }
            case -1 -> throw new InvalidWikiIdType(wikiItemId);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ WikiControllerApi access$getWikiControllerApi$p(WikiService $this) {
        return $this.wikiControllerApi;
    }

    public static final /* synthetic */ UrlService access$getUrlService$p(WikiService $this) {
        return $this.urlService;
    }
}

