/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.service;

import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiAttributes;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiConfiguration;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiProfile;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfileApiSection;
import de.justsoftware.mobile.gateway.people.model.remote.LegacyProfilePersonalData;
import de.justsoftware.mobile.gateway.people.service.LegacyProfileApiGatewayService;
import de.justsoftware.mobile.gateway.util.UrisKt;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u0003H\u0012J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0012J \u0010%\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0012R\u0010\u0010\u0002\u001a\u00020\u00038\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService;", "", "toroBaseUrl", "", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/reactive/function/client/WebClient;)V", "getProfile", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiProfile;", "profileId", "getProfileAttributes", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiAttributes;", "getProfileAttributeSection", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiSection;", "sectionName", "getProfileConfiguration", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfileApiConfiguration;", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "deleteUserImage", "getPersonalData", "Lde/justsoftware/mobile/gateway/people/model/remote/LegacyProfilePersonalData;", "updatePersonalData", "personalData", "deleteAttributeBlock", "", "blockIndex", "", "profileUri", "Ljava/net/URI;", "profileConfigurationUri", "updateUserImageUri", "deleteUserImageUri", "personalDataUri", "getProfileAttributeSectionUri", "deleteAttributeBlockUri", "Companion", "mobile-gateway"})
@SourceDebugExtension(value={"SMAP\nLegacyProfileApiGatewayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyProfileApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService\n+ 2 WebClients.kt\nde/justsoftware/mobile/gateway/util/WebClientsKt\n*L\n1#1,96:1\n52#2:97\n52#2:98\n52#2:99\n71#2:100\n83#2:101\n95#2:102\n52#2:103\n92#2:104\n95#2:105\n*S KotlinDebug\n*F\n+ 1 LegacyProfileApiGatewayService.kt\nde/justsoftware/mobile/gateway/people/service/LegacyProfileApiGatewayService\n*L\n26#1:97\n35#1:98\n38#1:99\n44#1:100\n44#1:101\n51#1:102\n54#1:103\n60#1:104\n63#1:105\n*E\n"})
public class LegacyProfileApiGatewayService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Value(value="${just.toro.baseUrl}")
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final WebClient webClient;
    @NotNull
    private static final String PROFILE_BASE = "/profile/api/v1";
    @NotNull
    private static final String UPDATE_IMAGE_PARAMETER_NAME = "image";

    public LegacyProfileApiGatewayService(@Value(value="${just.toro.baseUrl}") @NotNull String toroBaseUrl, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.toroBaseUrl = toroBaseUrl;
        this.webClient = webClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiProfile getProfile(@NotNull String profileId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.profileUri(profileId);
        boolean $i$f$get = false;
        return (LegacyProfileApiProfile)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    @NotNull
    public LegacyProfileApiAttributes getProfileAttributes(@NotNull String profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        LegacyProfileApiAttributes legacyProfileApiAttributes = this.getProfile(profileId).getProfileAttributes();
        if (legacyProfileApiAttributes == null) {
            legacyProfileApiAttributes = LegacyProfileApiAttributes.Companion.getEMPTY();
        }
        return legacyProfileApiAttributes;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiSection getProfileAttributeSection(@NotNull String profileId, @NotNull String sectionName) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)sectionName, (String)"sectionName");
        WebClient webClient = this.webClient;
        URI uri$iv = this.getProfileAttributeSectionUri(profileId, sectionName);
        boolean $i$f$get = false;
        return (LegacyProfileApiSection)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiConfiguration getProfileConfiguration(@NotNull String profileId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.profileConfigurationUri(profileId);
        boolean $i$f$get = false;
        return (LegacyProfileApiConfiguration)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiProfile updateUserImage(@NotNull String profileId, @NotNull MultipartFile image) {
        void file$iv;
        void name$iv;
        void uri$iv;
        void $this$post$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)image, (String)UPDATE_IMAGE_PARAMETER_NAME);
        WebClient webClient = this.webClient;
        URI uRI = this.updateUserImageUri(profileId);
        String string = UPDATE_IMAGE_PARAMETER_NAME;
        MultipartFile multipartFile = image;
        boolean $i$f$post = false;
        return (LegacyProfileApiProfile)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfileApiProfile deleteUserImage(@NotNull String profileId) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.deleteUserImageUri(profileId);
        boolean $i$f$delete = false;
        return (LegacyProfileApiProfile)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfilePersonalData getPersonalData(@NotNull String profileId) {
        void $this$get$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        WebClient webClient = this.webClient;
        URI uri$iv = this.personalDataUri(profileId);
        boolean $i$f$get = false;
        return (LegacyProfilePersonalData)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LegacyProfilePersonalData updatePersonalData(@NotNull String profileId, @NotNull LegacyProfilePersonalData personalData) {
        void uri$iv;
        void $this$put$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)personalData, (String)"personalData");
        WebClient webClient = this.webClient;
        URI uRI = this.personalDataUri(profileId);
        LegacyProfilePersonalData body$iv = personalData;
        boolean $i$f$put = false;
        return (LegacyProfilePersonalData)BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteAttributeBlock(@NotNull String profileId, @NotNull String sectionName, int blockIndex) {
        void $this$delete$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)sectionName, (String)"sectionName");
        WebClient webClient = this.webClient;
        URI uri$iv = this.deleteAttributeBlockUri(profileId, sectionName, blockIndex);
        boolean $i$f$delete = false;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* Unavailable Anonymous Inner Class!! */), (int)1, null);
    }

    private URI profileUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + profileId), null, null, (int)6, null);
    }

    private URI profileConfigurationUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/attributes/configuration/" + profileId), null, null, (int)6, null);
    }

    private URI updateUserImageUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + profileId + "/image"), null, null, (int)6, null);
    }

    private URI deleteUserImageUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + profileId + "/image"), null, null, (int)6, null);
    }

    private URI personalDataUri(String profileId) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + profileId + "/personal"), null, null, (int)6, null);
    }

    private URI getProfileAttributeSectionUri(String profileId, String sectionName) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + profileId + "/attributes/" + sectionName), null, null, (int)6, null);
    }

    private URI deleteAttributeBlockUri(String profileId, String sectionName, int blockIndex) {
        return UrisKt.buildUri$default((String)(this.toroBaseUrl + "/profile/api/v1/" + profileId + "/attributes/" + sectionName + "/" + blockIndex), null, null, (int)6, null);
    }
}

