/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security.oauth2;

import de.justsoftware.gateway.domain.login.UserLogin;
import de.justsoftware.gateway.domain.login.UserLoginId;
import de.justsoftware.gateway.domain.login.UserLoginRepository;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.web.server.DefaultServerRedirectStrategy;
import org.springframework.security.web.server.ServerRedirectStrategy;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.logout.RedirectServerLogoutSuccessHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@ParametersAreNonnullByDefault
public class JustServerLogoutSuccessHandler
implements ServerLogoutSuccessHandler {
    private final ServerRedirectStrategy _redirectStrategy = new DefaultServerRedirectStrategy();
    private final RedirectServerLogoutSuccessHandler _defaultLogoutSuccessHandler = new RedirectServerLogoutSuccessHandler();
    private final ReactiveClientRegistrationRepository _clientRegistrationRepository;
    private final UserLoginRepository _userLoginRepository;
    private String _postLogoutRedirectUri;

    public JustServerLogoutSuccessHandler(ReactiveClientRegistrationRepository clientRegistrationRepository, UserLoginRepository userLoginRepository) {
        this._userLoginRepository = userLoginRepository;
        this._clientRegistrationRepository = clientRegistrationRepository;
    }

    public Mono<Void> onLogoutSuccess(WebFilterExchange exchange, Authentication authentication) {
        return Mono.just((Object)authentication).transform(arg_0 -> this.extractUserLoginId(arg_0)).flatMap(arg_0 -> ((UserLoginRepository)this._userLoginRepository).findById(arg_0)).doOnSuccess(arg_0 -> this.deleteUserLogin(arg_0)).flatMap(userLogin -> this.getOIDCLogoutUri(userLogin, exchange)).switchIfEmpty(this._defaultLogoutSuccessHandler.onLogoutSuccess(exchange, authentication).then(Mono.empty())).flatMap(oidcLogoutUri -> this._redirectStrategy.sendRedirect(exchange.getExchange(), oidcLogoutUri));
    }

    private void deleteUserLogin(@Nullable UserLogin userLogin) {
        if (userLogin != null) {
            this._userLoginRepository.delete((Object)userLogin).subscribe();
        }
    }

    @Nonnull
    private Mono<UserLoginId> extractUserLoginId(Mono<Authentication> authentication) {
        return authentication.filter(JwtAuthenticationToken.class::isInstance).map(JwtAuthenticationToken.class::cast).map(JwtAuthenticationToken::getCustomJwtClaims).filter(claims -> claims.containsKey((Object)"login_id")).map(claims -> (String)claims.get((Object)"login_id")).filter(Objects::nonNull).map(UserLoginId::parse);
    }

    @Nonnull
    private Mono<URI> getOIDCLogoutUri(UserLogin userLogin, WebFilterExchange exchange) {
        return this._clientRegistrationRepository.findByRegistrationId(userLogin.getRegistrationId()).flatMap(arg_0 -> this.endSessionEndpoint(arg_0)).filter(Objects::nonNull).map(endSessionEndpoint -> {
            String idToken = userLogin.getIdToken();
            URI postLogoutRedirectUri = this.postLogoutRedirectUri(exchange.getExchange().getRequest());
            return this.endpointUri(endSessionEndpoint, idToken, postLogoutRedirectUri);
        });
    }

    @Nonnull
    private Mono<URI> endSessionEndpoint(ClientRegistration clientRegistration) {
        Object endSessionEndpoint = clientRegistration.getProviderDetails().getConfigurationMetadata().get("end_session_endpoint");
        if (endSessionEndpoint == null) {
            return Mono.empty();
        }
        return Mono.just((Object)URI.create(endSessionEndpoint.toString()));
    }

    @Nonnull
    private URI endpointUri(URI endSessionEndpoint, String idToken, @Nullable URI postLogoutRedirectUri) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)endSessionEndpoint);
        builder.queryParam("id_token_hint", new Object[]{idToken});
        if (postLogoutRedirectUri != null) {
            builder.queryParam("post_logout_redirect_uri", new Object[]{postLogoutRedirectUri});
        }
        return builder.encode(StandardCharsets.UTF_8).build().toUri();
    }

    @CheckForNull
    private URI postLogoutRedirectUri(ServerHttpRequest request) {
        if (this._postLogoutRedirectUri == null) {
            return null;
        }
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)request.getURI()).replacePath(request.getPath().contextPath().value()).replaceQuery(null).fragment(null).build();
        return UriComponentsBuilder.fromUriString((String)this._postLogoutRedirectUri).buildAndExpand(Collections.singletonMap("baseUrl", uriComponents.toUriString())).toUri();
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        Assert.notNull((Object)postLogoutRedirectUri, (String)"postLogoutRedirectUri cannot be null");
        this._postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public void setLogoutSuccessUrl(URI logoutSuccessUrl) {
        Assert.notNull((Object)logoutSuccessUrl, (String)"logoutSuccessUrl cannot be null");
        this._defaultLogoutSuccessHandler.setLogoutSuccessUrl(logoutSuccessUrl);
    }
}

