/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import de.justsoftware.gateway.security.JustAuthToken;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.authorization.AuthenticatedReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import reactor.core.publisher.Mono;

@ParametersAreNonnullByDefault
public class PublicApiClientReactiveAuthenticationManager<T> {
    public static final String PUBLIC_API_SCOPE_PREFIX = "user:";

    PublicApiClientReactiveAuthenticationManager() {
    }

    @Nonnull
    public static <T> ReactiveAuthorizationManager<T> onlyPublicClientAllowed() {
        return (authentication, object) -> authentication.map(auth -> {
            if (auth.isAuthenticated() && auth instanceof JustAuthToken) {
                JustAuthToken token = (JustAuthToken)auth;
                boolean allowed = token.getScope() != null && token.getScope().contains(PUBLIC_API_SCOPE_PREFIX);
                return new AuthorizationDecision(allowed);
            }
            return new AuthorizationDecision(false);
        });
    }

    @Nonnull
    public static <T> ReactiveAuthorizationManager<T> authenticatedButNotPublicClient() {
        AuthenticatedReactiveAuthorizationManager delegate = AuthenticatedReactiveAuthorizationManager.authenticated();
        return (arg_0, arg_1) -> PublicApiClientReactiveAuthenticationManager.lambda$authenticatedButNotPublicClient$4((ReactiveAuthorizationManager)delegate, arg_0, arg_1);
    }

    private static /* synthetic */ Mono lambda$authenticatedButNotPublicClient$4(ReactiveAuthorizationManager delegate, Mono authentication, Object object) {
        return authentication.filter(a -> a instanceof JustAuthToken).cast(JustAuthToken.class).map(token -> {
            boolean allowed = token.getScope() == null || !token.getScope().contains(PUBLIC_API_SCOPE_PREFIX);
            return new AuthorizationDecision(allowed);
        }).switchIfEmpty(delegate.check(authentication, object));
    }
}

