/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/shares/subscriptions"}, produces={"application/json"})
@Schema(description="Share Subscriptions")
@ParametersAreNonnullByDefault
@RestController
public class ShareSubscriptionController {
    private final SharesService _sharesService;

    @Autowired
    public ShareSubscriptionController(SharesService sharesService) {
        this._sharesService = sharesService;
    }

    @Operation(description="Subscribe the user to a share.")
    @RequestMapping(value={"/{shareId}/subscribe"}, method={RequestMethod.POST})
    public void subscribeToShare(AuthorizationContext authCtx, @PathVariable ItemId shareId) {
        authCtx.check((AbstractId)shareId, StaticAction.DOCUMENT_READ);
        this._sharesService.subscribeShare(shareId, authCtx.getPersonId());
    }

    @Operation(description="Unsubscribe the user from a share.")
    @RequestMapping(value={"/{shareId}/unsubscribe"}, method={RequestMethod.POST})
    public void unsubscribeFromShare(AuthorizationContext authCtx, @PathVariable ItemId shareId) {
        authCtx.check((AbstractId)shareId, StaticAction.DOCUMENT_READ);
        this._sharesService.unsubscribeShare(shareId, authCtx.getPersonId());
    }
}

