/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.event.FileVirusScanCleanEvent;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.file.VirusScannerService;
import de.justsoftware.drive.business.kafka.VirusScanKafkaDto;
import de.justsoftware.drive.business.kafka.VirusScanKafkaProducer;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanBo;
import de.justsoftware.drive.common.file.model.VirusScanStatus;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.file.VirusScanDAO;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class VirusScannerServiceImpl
implements VirusScannerService {
    private final VirusScanKafkaProducer _producer;
    private final VirusScanDAO _virusScanDAO;
    private final EventBus _eventBus;
    private final FileService _fileService;
    private final SettingsService _settingsService;

    @Autowired
    public VirusScannerServiceImpl(VirusScanKafkaProducer producer, VirusScanDAO virusScanDAO, EventBus eventBus, FileService fileService, SettingsService settingsService) {
        this._producer = producer;
        this._virusScanDAO = virusScanDAO;
        this._eventBus = eventBus;
        this._fileService = fileService;
        this._settingsService = settingsService;
    }

    public boolean sendFileToVirusScan(StorageId storageId, TenantId tenantId) {
        VirusScanBo virusScanBo = this._virusScanDAO.findVirusScanStatus(storageId);
        if (virusScanBo == null) {
            this._virusScanDAO.addVirusScanRequestIfNotExists(storageId);
            if (this._settingsService.isAntivirusEnabled(tenantId)) {
                this.sendToQueue(storageId);
                return true;
            }
        }
        return false;
    }

    private void sendToQueue(StorageId storageId) {
        String storageFileUrl = this._fileService.getFileStorageUrl(storageId);
        this._producer.publish(storageId, new VirusScanKafkaDto((String)storageId.getId(), storageFileUrl));
        this._virusScanDAO.setVirusScanStatus(new VirusScanBo(storageId, VirusScanStatus.QUEUED, null));
    }

    public void handleVirusScanResult(VirusScanBo virusScanBo) {
        this._virusScanDAO.setVirusScanStatus(virusScanBo);
        if (virusScanBo.getVirusScanStatus() == VirusScanStatus.CLEAN) {
            ImmutableMap fileVersions = (ImmutableMap)this._fileService.getFileVersionsByStorageId(virusScanBo.getStorageId()).stream().collect(ImmutableMap.toImmutableMap(DocumentVersionBO::getDocumentId, DocumentVersionBO::getId));
            this._eventBus.post((Object)new FileVirusScanCleanEvent(fileVersions));
        } else if (virusScanBo.getVirusScanStatus() == VirusScanStatus.INFECTED || virusScanBo.getVirusScanStatus() == VirusScanStatus.ERROR) {
            // empty if block
        }
    }

    public void deleteVirusScan(Set<StorageId> storageIds) {
        this._virusScanDAO.deleteVirusScanStatus(storageIds);
    }

    public void enqueueUnscannedFiles() {
        int virusScanBatchSize = 10000;
        int maxQueuedVirusScans = 100;
        if (this._virusScanDAO.countQueuedVirusScans() < 100) {
            this._virusScanDAO.findAllWithStatusNotScanned(10000).forEach(arg_0 -> this.sendToQueue(arg_0));
        }
    }
}

