/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.document.ByteSourceWithFilename;
import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.TempFileBO;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import java.time.Instant;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface TempFileService {
    @Nonnull
    public ImmutableMap<TempFileId, ByteSourceWithFilename> addTempFiles(Iterable<ByteSourceWithFilename> var1, PersonId var2, TenantId var3);

    @Nonnull
    public ImmutableMap<TempFileId, FileVersionBO> moveTempFilesToItem(Set<TempFileId> var1, ItemId var2, PersonId var3, TenantId var4);

    @Nonnull
    public ImmutableMap<TempFileId, TempFileBO> getTempFiles(Set<TempFileId> var1);

    @CheckForNull
    default public TempFileBO getTempFile(TempFileId tempFileId) {
        return (TempFileBO)this.getTempFiles((Set)ImmutableSet.of((Object)tempFileId)).get((Object)tempFileId);
    }

    public void deleteTempFileReferences(Set<TempFileId> var1);

    public void deleteTempfilesOlderThan(Instant var1);

    public void deletePreviewSources();

    public void setVideoTeaser(TempFileBO var1, VideoTeaserId var2);

    public void deleteVideoTeaser(TempFileId var1);
}

