/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.virus;

import de.justsoftware.drive.business.file.VirusScannerService;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.settings.model.SettingsBO;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class VirusScanQueueService {
    private final VirusScannerService _virusScannerService;
    private final SettingsService _settingsService;

    @Autowired
    public VirusScanQueueService(VirusScannerService virusScannerService, SettingsService settingsService) {
        this._virusScannerService = virusScannerService;
        this._settingsService = settingsService;
    }

    @Scheduled(fixedDelayString="${just.drive.virus.scan.queue.delay:PT5M}", initialDelayString="PT10M")
    public void sendFilesToVirusScans() {
        if (this._settingsService.getAllSettings().stream().anyMatch(SettingsBO::antivirusEnabled)) {
            this._virusScannerService.enqueueUnscannedFiles();
        }
    }
}

