/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.util;

import de.justsoftware.justdocumentz.config.JudoConfig;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/justdocumentz/util/StoragePaths;", "", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;)V", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "convertedVideo", "Ljava/nio/file/Path;", "fileId", "", "coverImage", "documentPreviewFile", "fileName", "just-documentz"})
public class StoragePaths {
    @NotNull
    private final JudoConfig config;

    public StoragePaths(@NotNull JudoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public Path documentPreviewFile(@NotNull String fileId, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Path path = this.getConfig().getStorageDirPath().resolve(fileId).resolve("HTML").resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public Path coverImage(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Path path = this.getConfig().getConvertedVideoDirPath().resolve(fileId + ".converted_cover.png");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    @NotNull
    public Path convertedVideo(@NotNull String fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        Path path = this.getConfig().getConvertedVideoDirPath().resolve(fileId + ".converted.mp4");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }
}

