/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.scheduled;

import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.scheduled.TempFileCleanupTask;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0012J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/justdocumentz/scheduled/TempFileCleanupTask;", "", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "cleanupOldTempFiles", "", "deleteFile", "", "path", "Ljava/nio/file/Path;", "isOlderThan", "cutoffTime", "Ljava/time/Instant;", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nTempFileCleanupTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TempFileCleanupTask.kt\nde/justsoftware/justdocumentz/scheduled/TempFileCleanupTask\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n9#2:49\n1#3:50\n*S KotlinDebug\n*F\n+ 1 TempFileCleanupTask.kt\nde/justsoftware/justdocumentz/scheduled/TempFileCleanupTask\n*L\n14#1:49\n*E\n"})
public class TempFileCleanupTask {
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final Logger logger;

    public TempFileCleanupTask(@NotNull JudoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        TempFileCleanupTask $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(TempFileCleanupTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Scheduled(fixedRateString="${judo.scheduled.tempFileCleanup.interval}")
    public void cleanupOldTempFiles() {
        this.getLogger().info("Starting temporary file cleanup...");
        try {
            Duration maxFileAge = this.config.getScheduled().getTempFileCleanup().getMaxAge();
            Instant cutoffTime = Instant.now().minusMillis(maxFileAge.toMillis());
            long deletedCount2 = Files.walk(this.config.getTempDirPath(), new FileVisitOption[0]).filter(arg_0 -> TempFileCleanupTask.cleanupOldTempFiles$lambda$0((Function1)cleanupOldTempFiles.deletedCount.1.INSTANCE, arg_0)).filter(arg_0 -> TempFileCleanupTask.cleanupOldTempFiles$lambda$1((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).mapToLong(arg_0 -> TempFileCleanupTask.cleanupOldTempFiles$lambda$2((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).sum();
            this.getLogger().info("File cleanup completed. Deleted " + deletedCount2 + " files older than " + maxFileAge);
        }
        catch (IOException e) {
            this.getLogger().error("Failed to cleanup temporary file cleanup.", (Throwable)e);
        }
    }

    private boolean isOlderThan(Path path, Instant cutoffTime) {
        Object object;
        Object object2 = this;
        try {
            TempFileCleanupTask $this$isOlderThan_u24lambda_u243 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Files.getLastModifiedTime(path, new LinkOption[0]).toInstant().isBefore(cutoffTime));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            this.getLogger().error("Error checking file date: " + path, (Throwable)e);
        }
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private boolean deleteFile(Path path) {
        Object object;
        Object object2 = this;
        try {
            TempFileCleanupTask $this$deleteFile_u24lambda_u245 = object2;
            boolean bl = false;
            Files.delete(path);
            object = Result.constructor-impl((Object)true);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            this.getLogger().error("Failed to delete file: " + path, (Throwable)e);
        }
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    private static final boolean cleanupOldTempFiles$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean cleanupOldTempFiles$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final long cleanupOldTempFiles$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    public static final /* synthetic */ boolean access$isOlderThan(TempFileCleanupTask $this, Path path, Instant cutoffTime) {
        return $this.isOlderThan(path, cutoffTime);
    }

    public static final /* synthetic */ boolean access$deleteFile(TempFileCleanupTask $this, Path path) {
        return $this.deleteFile(path);
    }
}

