/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions.video;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.justdocumentz.common.ContainerImageService;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.conversions.ConversionService;
import de.justsoftware.justdocumentz.conversions.video.FFProbeOutput;
import de.justsoftware.justdocumentz.conversions.video.FFProbeStream;
import de.justsoftware.justdocumentz.conversions.video.VideoProbeException;
import de.justsoftware.justdocumentz.util.CommandExecutionException;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import jakarta.annotation.PostConstruct;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J \u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0012J \u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0012J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001aH\u0012J\b\u0010#\u001a\u00020$H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lde/justsoftware/justdocumentz/conversions/video/VideoConversionService;", "Lde/justsoftware/justdocumentz/conversions/ConversionService;", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "containerImageService", "Lde/justsoftware/justdocumentz/common/ContainerImageService;", "environment", "Lorg/springframework/core/env/Environment;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/common/ContainerImageService;Lorg/springframework/core/env/Environment;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getContainerImageService", "()Lde/justsoftware/justdocumentz/common/ContainerImageService;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "ffmpegImage", "", "justContainerVersion", "logger", "Lorg/slf4j/Logger;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "convert", "", "Ljava/nio/file/Path;", "inputFile", "tempDir", "convertVideo", "info", "Lde/justsoftware/justdocumentz/conversions/video/FFProbeStream;", "createCoverImage", "videoPath", "getVideoInformation", "initialize", "", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nVideoConversionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoConversionService.kt\nde/justsoftware/justdocumentz/conversions/video/VideoConversionService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n9#2:215\n1#3:216\n223#4,2:217\n*S KotlinDebug\n*F\n+ 1 VideoConversionService.kt\nde/justsoftware/justdocumentz/conversions/video/VideoConversionService\n*L\n28#1:215\n92#1:217,2\n*E\n"})
public class VideoConversionService
implements ConversionService {
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final ContainerImageService containerImageService;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final Logger logger;
    @Nullable
    private final String justContainerVersion;
    @NotNull
    private final String ffmpegImage;

    public VideoConversionService(@NotNull JudoConfig config, @NotNull ContainerImageService containerImageService, @NotNull Environment environment, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)containerImageService, (String)"containerImageService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.config = config;
        this.containerImageService = containerImageService;
        this.environment = environment;
        this.objectMapper = objectMapper;
        VideoConversionService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(VideoConversionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.justContainerVersion = this.getEnvironment().getProperty("just.containerVersion");
        this.ffmpegImage = "docker.io/justsocial/just-ffmpeg-2:" + this.justContainerVersion;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public ContainerImageService getContainerImageService() {
        return this.containerImageService;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @PostConstruct
    public void initialize() {
        String[] stringArray = this.getEnvironment().getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        if (ArraysKt.contains((Object[])stringArray, (Object)"jenkins")) {
            this.logger.info("Skipping " + this.getClass().getSimpleName() + " initialization in Jenkins");
            return;
        }
        this.logger.info("Initializing " + this.getClass().getSimpleName() + "...");
        if (!this.getContainerImageService().isPodmanAvailable()) {
            boolean bl = false;
            String string = "Podman is not available on this system. Please install Podman to use PDF conversion.";
            throw new IllegalStateException(string.toString());
        }
        this.getContainerImageService().ensureImageAvailable(this.ffmpegImage);
    }

    @NotNull
    public List<Path> convert(@NotNull Path inputFile, @NotNull Path tempDir) {
        Object[] objectArray;
        FFProbeStream fFProbeStream;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Object it = fFProbeStream = this.getVideoInformation(inputFile);
        boolean bl = false;
        this.logger.debug("videoInformation: {}", it);
        FFProbeStream videoInformation = fFProbeStream;
        Object it2 = it = this.createCoverImage(inputFile, tempDir, videoInformation);
        boolean bl2 = false;
        this.logger.debug("coverImage: {}", it2);
        Object coverImage = it;
        Object[] it3 = objectArray = this.convertVideo(inputFile, tempDir, videoInformation);
        boolean bl3 = false;
        this.logger.debug("convertedVideo: {}", (Object)it3);
        Object[] convertedVideo = objectArray;
        objectArray = new Path[]{coverImage, convertedVideo};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private FFProbeStream getVideoInformation(Path videoPath) {
        Path inputDir = videoPath.getParent().toAbsolutePath();
        String containerInputDir = "/input";
        try {
            Object element$iv2;
            block3: {
                Object[] objectArray = new String[]{"-v", inputDir + ":" + containerInputDir + ":ro", "--entrypoint", "/usr/local/bin/ffprobe", this.ffmpegImage, "-hide_banner", "-of", "json", "-loglevel", "panic", "-show_streams", "-show_format", containerInputDir + "/" + videoPath.getFileName()};
                String output = CommandLineUtilsKt.podmanRun-5_5nbZA$default((List)CollectionsKt.listOf((Object[])objectArray), (PodmanConfig)this.getConfig().getPodman().getVideo(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), null, (int)8, null).component1();
                FFProbeOutput ffProbeOutput = (FFProbeOutput)this.getObjectMapper().readValue(output, FFProbeOutput.class);
                Iterable $this$first$iv = ffProbeOutput.getStreams();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    FFProbeStream it = (FFProbeStream)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getCodecType(), (Object)"video")) continue;
                    break block3;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            return (FFProbeStream)element$iv2;
        }
        catch (CommandExecutionException e) {
            throw new VideoProbeException("Failed to parse video information from: " + videoPath, (Throwable)e);
        }
    }

    private Path createCoverImage(Path videoPath, Path tempDir, FFProbeStream info) {
        Path inputDir = videoPath.getParent();
        String containerInputDir = "/input";
        String containerOutputDir = "/output";
        String outputFileName = "cover-image.png";
        Object[] objectArray = new String[]{"-v", inputDir + ":" + containerInputDir + ":ro", "-v", tempDir + ":" + containerOutputDir, this.ffmpegImage, "-y", "-ss", String.valueOf(MathKt.roundToInt((double)(info.getDuration() / (double)2))), "-i", containerInputDir + "/" + videoPath.getFileName(), "-frames:v", "1", containerOutputDir + "/" + outputFileName};
        CommandLineUtilsKt.podmanRun-5_5nbZA$default((List)CollectionsKt.listOf((Object[])objectArray), (PodmanConfig)this.getConfig().getPodman().getVideo(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), null, (int)8, null);
        Path coverImagePath = tempDir.resolve(outputFileName);
        if (!Files.exists(coverImagePath, new LinkOption[0])) {
            boolean bl = false;
            String string = "Cover image generation appeared to succeed but output file not found: " + coverImagePath;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)coverImagePath);
        return coverImagePath;
    }

    private Path convertVideo(Path inputFile, Path tempDir, FFProbeStream info) {
        Path inputDir = inputFile.getParent();
        String containerInputDir = "/input";
        String containerOutputDir = "/output";
        String outputFileName = "output.mp4";
        Object[] objectArray = new String[]{"-v", inputDir + ":" + containerInputDir + ":ro", "-v", tempDir + ":" + containerOutputDir, this.ffmpegImage, "-i", containerInputDir + "/" + inputFile.getFileName(), "-c:v", "libx264", "-preset", "fast", "-crf", "23", "-vf", info.getWidth() > info.getHeight() ? "scale=-2:720" : "scale=1280:-2", "-c:a", "aac", "-b:a", "128k", "-movflags", "+faststart", containerOutputDir + "/" + outputFileName};
        CommandLineUtilsKt.podmanRun-5_5nbZA$default((List)CollectionsKt.listOf((Object[])objectArray), (PodmanConfig)this.getConfig().getPodman().getVideo(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES)), null, (int)8, null);
        Path convertedVideoPath = tempDir.resolve(outputFileName);
        if (!Files.exists(convertedVideoPath, new LinkOption[0])) {
            boolean bl = false;
            String string = "Video conversion appeared to succeed but output file not found: " + convertedVideoPath;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)convertedVideoPath);
        return convertedVideoPath;
    }
}

