/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions.document;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.justdocumentz.common.ContainerImageService;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.conversions.ConversionService;
import de.justsoftware.justdocumentz.conversions.UnsupportedConversionException;
import de.justsoftware.justdocumentz.conversions.document.DocumentConversionService;
import de.justsoftware.justdocumentz.conversions.document.DocumentConversionService$convertToImages$;
import de.justsoftware.justdocumentz.conversions.document.FileTypeDetectionService;
import de.justsoftware.justdocumentz.conversions.document.PdfMetaData;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 02\u00020\u0001:\u00010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ6\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u0014H\u0012J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001aH\u0012J\u0018\u0010&\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001dH\u0012J\u001e\u0010'\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cH\u0012J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001dH\u0012J\b\u0010,\u001a\u00020-H\u0017J\u0018\u0010.\u001a\u00020-2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u001dH\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/justsoftware/justdocumentz/conversions/document/DocumentConversionService;", "Lde/justsoftware/justdocumentz/conversions/ConversionService;", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "containerImageService", "Lde/justsoftware/justdocumentz/common/ContainerImageService;", "fileTypeDetectionService", "Lde/justsoftware/justdocumentz/conversions/document/FileTypeDetectionService;", "environment", "Lorg/springframework/core/env/Environment;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/common/ContainerImageService;Lde/justsoftware/justdocumentz/conversions/document/FileTypeDetectionService;Lorg/springframework/core/env/Environment;)V", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getContainerImageService", "()Lde/justsoftware/justdocumentz/common/ContainerImageService;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "getFileTypeDetectionService", "()Lde/justsoftware/justdocumentz/conversions/document/FileTypeDetectionService;", "justContainerVersion", "", "justPdfToPpmImage", "libreOfficeImage", "logger", "Lorg/slf4j/Logger;", "pageLimit", "", "buildIframe", "", "Ljava/nio/file/Path;", "imageFiles", "tempDir", "originalPageCount", "title", "convert", "inputFile", "convertToImages", "pageCount", "convertToPdf", "generateIframeHtml", "fileNames", "getPdfMetaData", "Lde/justsoftware/justdocumentz/conversions/document/PdfMetaData;", "input", "initialize", "", "resizeImage", "output", "Companion", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentConversionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentConversionService.kt\nde/justsoftware/justdocumentz/conversions/document/DocumentConversionService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n9#2:337\n1#3:338\n1045#4:339\n1549#4:340\n1620#4,3:341\n1549#4:344\n1620#4,3:345\n*S KotlinDebug\n*F\n+ 1 DocumentConversionService.kt\nde/justsoftware/justdocumentz/conversions/document/DocumentConversionService\n*L\n68#1:337\n218#1:339\n219#1:340\n219#1:341,3\n234#1:344\n234#1:345,3\n*E\n"})
public class DocumentConversionService
implements ConversionService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final ContainerImageService containerImageService;
    @NotNull
    private final FileTypeDetectionService fileTypeDetectionService;
    @NotNull
    private final Environment environment;
    @NotNull
    private final Logger logger;
    private final int pageLimit;
    @Nullable
    private final String justContainerVersion;
    @NotNull
    private final String libreOfficeImage;
    @NotNull
    private final String justPdfToPpmImage;
    @NotNull
    private static final Set<String> fileTypeBlacklist;
    @NotNull
    private static final Set<String> fileTypeWhitelist;
    @NotNull
    private static final String pdfExportConfiguration;
    @NotNull
    private static final Pattern pdfInfoTitlePattern;
    @NotNull
    private static final Pattern pdfInfoPageCountPattern;
    @NotNull
    private static final Path endOfPreviewResource;

    public DocumentConversionService(@NotNull JudoConfig config, @NotNull ContainerImageService containerImageService, @NotNull FileTypeDetectionService fileTypeDetectionService, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)containerImageService, (String)"containerImageService");
        Intrinsics.checkNotNullParameter((Object)fileTypeDetectionService, (String)"fileTypeDetectionService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.config = config;
        this.containerImageService = containerImageService;
        this.fileTypeDetectionService = fileTypeDetectionService;
        this.environment = environment;
        DocumentConversionService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(DocumentConversionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.pageLimit = this.getConfig().getConverter().getPageLimit();
        this.justContainerVersion = this.getEnvironment().getProperty("just.containerVersion");
        this.libreOfficeImage = "docker.io/justsocial/just-libreoffice:" + this.justContainerVersion;
        this.justPdfToPpmImage = "docker.io/justsocial/just-pdftoppm:" + this.justContainerVersion;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public ContainerImageService getContainerImageService() {
        return this.containerImageService;
    }

    @NotNull
    public FileTypeDetectionService getFileTypeDetectionService() {
        return this.fileTypeDetectionService;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @PostConstruct
    public void initialize() {
        String[] stringArray = this.getEnvironment().getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        if (ArraysKt.contains((Object[])stringArray, (Object)"jenkins")) {
            this.logger.info("Skipping " + this.getClass().getSimpleName() + " initialization in Jenkins");
            return;
        }
        this.logger.info("Initializing " + this.getClass().getSimpleName() + "...");
        if (!this.getContainerImageService().isPodmanAvailable()) {
            boolean bl = false;
            String string = "Podman is not available on this system. Please install Podman to use PDF conversion.";
            throw new IllegalStateException(string.toString());
        }
        this.getContainerImageService().ensureImageAvailable(this.libreOfficeImage);
        this.getContainerImageService().ensureImageAvailable(this.justPdfToPpmImage);
    }

    @NotNull
    public List<Path> convert(@NotNull Path inputFile, @NotNull Path tempDir) throws UnsupportedConversionException {
        List list;
        Path path;
        String string;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        String it = string = this.getFileTypeDetectionService().detectType(inputFile);
        boolean bl = false;
        this.logger.debug("detectedType: {}", (Object)it);
        String detectedType = string;
        boolean isBlacklisted = fileTypeBlacklist.contains(detectedType);
        boolean isWhitelisted = fileTypeWhitelist.contains(detectedType);
        boolean isMsOffice = this.getFileTypeDetectionService().isMsOfficeArchive(inputFile);
        if (isBlacklisted || !isWhitelisted && !isMsOffice) {
            throw new UnsupportedConversionException(inputFile + " of type '" + detectedType + "' can not be converted to PDF.");
        }
        Path it2 = path = Intrinsics.areEqual((Object)detectedType, (Object)"PDF document") ? inputFile : this.convertToPdf(inputFile, tempDir);
        boolean bl2 = false;
        this.logger.debug("Path to PDF {}", (Object)it2);
        Path pdfFile = path;
        Path it3 = it2 = this.getPdfMetaData(pdfFile);
        boolean bl3 = false;
        this.logger.debug("pdfPageCount: {}, title: {}", (Object)it3.getPageCount(), (Object)it3.getTitle());
        path = it2;
        int pdfPageCount = path.component1();
        String title = path.component2();
        List it4 = list = this.convertToImages(pdfFile, tempDir, pdfPageCount);
        boolean bl4 = false;
        this.logger.debug("imageFiles {}", (Object)it4);
        List imageFiles = list;
        it4 = list = this.buildIframe(imageFiles, tempDir, pdfPageCount, title);
        boolean bl5 = false;
        this.logger.debug("iFrame: {}", (Object)it4);
        return list;
    }

    private Path convertToPdf(Path inputFile, Path tempDir) {
        if (!Files.exists(inputFile, new LinkOption[0])) {
            boolean $i$a$-require-DocumentConversionService$convertToPdf$22 = false;
            String $i$a$-require-DocumentConversionService$convertToPdf$22 = "File " + inputFile + " does not exist";
            throw new IllegalArgumentException($i$a$-require-DocumentConversionService$convertToPdf$22.toString());
        }
        String containerInputDir = "/tmp/libreoffice-input";
        String containerOutputDir = "/tmp/libreoffice-output";
        Object[] objectArray = new String[]{"-v", inputFile.getParent().toAbsolutePath() + ":" + containerInputDir + ":ro,z", "-v", tempDir.toAbsolutePath() + ":" + containerOutputDir + ":z", this.libreOfficeImage, "libreoffice", "--headless", "--convert-to", "pdf:draw_pdf_Export:" + pdfExportConfiguration, "--outdir", containerOutputDir, containerInputDir + "/" + inputFile.getFileName()};
        CommandLineUtilsKt.podmanRun-5_5nbZA$default((List)CollectionsKt.listOf((Object[])objectArray), (PodmanConfig)this.getConfig().getPodman().getDocument(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), null, (int)8, null);
        Path tempPdfFile = tempDir.resolve(PathsKt.getNameWithoutExtension((Path)inputFile) + ".pdf");
        if (!Files.exists(tempPdfFile, new LinkOption[0])) {
            boolean bl = false;
            String string = "PDF conversion appeared to succeed but output file not found: " + tempPdfFile;
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNull((Object)tempPdfFile);
        return tempPdfFile;
    }

    private PdfMetaData getPdfMetaData(Path input) {
        Object[] objectArray = new String[]{"pdfinfo", String.valueOf(input)};
        String pdfInfo = CommandLineUtilsKt.executeCommandLine-Kx4hsE0$default((List)CollectionsKt.listOf((Object[])objectArray), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS)), null, (int)4, null).component1();
        Matcher it = pdfInfoTitlePattern.matcher(pdfInfo);
        boolean bl = false;
        String title = it.find() ? it.group(1) : null;
        Matcher it2 = pdfInfoPageCountPattern.matcher(pdfInfo);
        boolean bl2 = false;
        if (!it2.find()) {
            boolean bl3 = false;
            String string = "can't read pdf: " + input;
            throw new IllegalStateException(string.toString());
        }
        String string = it2.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        int pageCount = Integer.parseInt(string);
        return new PdfMetaData(pageCount, title);
    }

    /*
     * WARNING - void declaration
     */
    private List<Path> convertToImages(Path inputFile, Path tempDir, int pageCount) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedBy$iv;
        List list;
        Object object;
        if (!Files.exists(inputFile, new LinkOption[0])) {
            boolean $i$a$-require-DocumentConversionService$convertToImages$22 = false;
            String $i$a$-require-DocumentConversionService$convertToImages$22 = "File " + inputFile + " does not exist";
            throw new IllegalArgumentException($i$a$-require-DocumentConversionService$convertToImages$22.toString());
        }
        Path inputDir = inputFile.getParent();
        String containerOutputDir = "/home/justsoftware/workspace";
        if (this.pageLimit >= 1 && pageCount >= this.pageLimit) {
            object = new String[]{"-l", String.valueOf(this.pageLimit)};
            list = CollectionsKt.listOf((Object[])object);
        } else {
            list = CollectionsKt.emptyList();
        }
        List extraParams = list;
        object = new String[]{"--name", "pdf2jpeghtml-" + PathsKt.getNameWithoutExtension((Path)inputFile), "-u", "justsoftware", "-v", inputDir + ":" + inputDir + ":Z", "-v", tempDir + ":" + containerOutputDir + ":Z", this.justPdfToPpmImage, "-c", "-m", "1024000", "pdftoppm", "-png", String.valueOf(inputFile), "-r", "100"};
        CommandLineUtilsKt.podmanRun-5_5nbZA$default((List)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])object), (Iterable)extraParams), (Object)(containerOutputDir + "/bg")), (PodmanConfig)this.getConfig().getPodman().getDocument(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), null, (int)8, null);
        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(tempDir, "bg-*.png");
        Intrinsics.checkNotNullExpressionValue(directoryStream, (String)"newDirectoryStream(...)");
        object = directoryStream;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new convertToImages$$inlined$sortedBy$1()));
        boolean $i$f$map = false;
        void var9_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Path path;
            void originalImage;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)originalImage);
            Path target = path = tempDir.resolve(PathsKt.getNameWithoutExtension((Path)originalImage) + ".jpg");
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)target);
            this.resizeImage((Path)originalImage, target);
            collection.add(path);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<Path> buildIframe(List<? extends Path> imageFiles, Path tempDir, int originalPageCount, String title) {
        List list;
        String string;
        void $this$mapTo$iv$iv;
        boolean addEndOfPreview = this.pageLimit >= 1 && originalPageCount >= this.pageLimit;
        Path htmlPath = tempDir.resolve("index.html");
        Iterable $this$map$iv = imageFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)it.getFileName()).toString());
        }
        List fileNames = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (addEndOfPreview) {
            Path endOfPreviewPath = tempDir.resolve("end_of_preview.png");
            Files.copy(endOfPreviewResource, endOfPreviewPath, new CopyOption[0]);
            fileNames.add("end_of_preview.png");
        }
        if ((string = title) == null) {
            string = "";
        }
        String previewIframe = this.generateIframeHtml(string, fileNames);
        Intrinsics.checkNotNull((Object)htmlPath);
        PathsKt.writeText((Path)htmlPath, (CharSequence)previewIframe, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
        List $this$buildIframe_u24lambda_u2416 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$buildIframe_u24lambda_u2416.add(htmlPath);
        $this$buildIframe_u24lambda_u2416.addAll((Collection)imageFiles);
        if (addEndOfPreview) {
            Path path = tempDir.resolve("end_of_preview.png");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            $this$buildIframe_u24lambda_u2416.add(path);
        }
        return CollectionsKt.build((List)list);
    }

    private void resizeImage(Path input, Path output) {
        Object[] objectArray = new String[]{"convert", String.valueOf(input), "-resize", "904800@", String.valueOf(output)};
        CommandLineUtilsKt.executeCommandLine-Kx4hsE0$default((List)CollectionsKt.listOf((Object[])objectArray), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS)), null, (int)4, null);
    }

    private String generateIframeHtml(String title, List<String> fileNames) {
        return StringsKt.trimIndent((String)("\n            <!DOCTYPE html>\n            <html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"\" xml:lang=\"\">\n                <head>\n                    <title>" + title + "</title>\n                    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n                    <style type=\"text/css\">\n                        html, body {\n                            height: 100%;\n                            width: 100%;\n                        }\n\n                        .siteStyle {\n                            background-color: transparent;\n                            margin: 0;\n                        }\n\n                        .judo-wrapper {\n                            height: 100%;\n                            width: 100%;\n                            overflow: auto;\n                        }\n\n                        .pageStyle {\n                            margin: auto;\n                            padding: 5px 5px 5px 5px;\n                            text-align: center;\n                        }\n\n                        .imageStyle {\n                            max-width: 100%;\n                            display: block;\n                        }\n                    </style>\n                    <script>\n                        function init() {\n                            const wrapperElement = document.createElement(\".judo-wrapper\");\n                            wrapperElement.addEventListener(\"click\", evt => {\n                                if (evt.target === wrapperElement) {\n                                    parent.postMessage(\"outerContentClicked\", parent.location.origin);\n                                }\n                            });\n                        }\n                    </script>\n                </head>\n                <body onload=\"init();\" class=\"siteStyle\">\n                    <div class=\"judo-wrapper\">\n                        " + CollectionsKt.joinToString$default((Iterable)fileNames, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)generateIframeHtml.1.INSTANCE), (int)30, null) + "\n                    </div>\n                </body>\n            </html>\n        "));
    }

    public static final /* synthetic */ Set access$getFileTypeBlacklist$cp() {
        return fileTypeBlacklist;
    }

    public static final /* synthetic */ Set access$getFileTypeWhitelist$cp() {
        return fileTypeWhitelist;
    }

    public static final /* synthetic */ String access$getPdfExportConfiguration$cp() {
        return pdfExportConfiguration;
    }

    public static final /* synthetic */ Pattern access$getPdfInfoTitlePattern$cp() {
        return pdfInfoTitlePattern;
    }

    public static final /* synthetic */ Pattern access$getPdfInfoPageCountPattern$cp() {
        return pdfInfoPageCountPattern;
    }

    public static final /* synthetic */ Path access$getEndOfPreviewResource$cp() {
        return endOfPreviewResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Set set;
        Object reader2;
        Companion = new Companion(null);
        InputStream inputStream = Companion.getClass().getClassLoader().getResourceAsStream("assets/default.blacklist");
        if (inputStream == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Object it = inputStream;
        boolean bl = false;
        Closeable closeable = new BufferedReader(new InputStreamReader((InputStream)it));
        Throwable throwable = null;
        try {
            reader2 = (BufferedReader)closeable;
            boolean bl2 = false;
            reader2 = CollectionsKt.toSet((Iterable)TextStreamsKt.readLines((Reader)((Reader)reader2)));
        }
        catch (Throwable reader2) {
            throwable = reader2;
            throw reader2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        fileTypeBlacklist = reader2;
        InputStream inputStream2 = Companion.getClass().getClassLoader().getResourceAsStream("assets/default.whitelist");
        if (inputStream2 == null) {
            it = "Required value was null.";
            throw new IllegalArgumentException(it.toString());
        }
        it = inputStream2;
        boolean bl32 = false;
        closeable = new BufferedReader(new InputStreamReader((InputStream)it));
        throwable = null;
        try {
            reader2 = (BufferedReader)closeable;
            boolean bl4 = false;
            set = CollectionsKt.toSet((Iterable)TextStreamsKt.readLines((Reader)((Reader)reader2)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        fileTypeWhitelist = set;
        URL uRL = Companion.getClass().getClassLoader().getResource("assets/libreoffice-pdf-export-config.json");
        if (uRL == null) {
            String bl32 = "Required value was null.";
            throw new IllegalArgumentException(bl32.toString());
        }
        URL it2 = uRL;
        boolean bl5 = false;
        ObjectMapper objectMapper = new ObjectMapper();
        String string = objectMapper.writeValueAsString((Object)objectMapper.readTree(it2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
        pdfExportConfiguration = string;
        Pattern pattern = Pattern.compile("Title:\\s*(.*)\\n");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        pdfInfoTitlePattern = pattern;
        Pattern pattern2 = Pattern.compile("Pages:\\s*(.*)\\n");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        pdfInfoPageCountPattern = pattern2;
        URL uRL2 = Companion.getClass().getClassLoader().getResource("assets/end_of_preview.png");
        if (uRL2 == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        URI uRI = uRL2.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        Path path = Paths.get(uRI);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        endOfPreviewResource = path;
    }
}

