/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions;

import de.justsoftware.justdocumentz.common.FileCacheService;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.conversions.ConversionStatusPublisher;
import de.justsoftware.justdocumentz.conversions.ConversionTask;
import de.justsoftware.justdocumentz.conversions.UnsupportedConversionException;
import de.justsoftware.justdocumentz.conversions.document.DocumentConversionService;
import de.justsoftware.justdocumentz.conversions.video.VideoConversionService;
import de.justsoftware.justdocumentz.util.FileUtilsKt;
import de.justsoftware.justdocumentz.util.StoragePaths;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006!"}, d2={"Lde/justsoftware/justdocumentz/conversions/ConversionJobService;", "", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "videoConversionService", "Lde/justsoftware/justdocumentz/conversions/video/VideoConversionService;", "documentConversionService", "Lde/justsoftware/justdocumentz/conversions/document/DocumentConversionService;", "conversionStatusPublisher", "Lde/justsoftware/justdocumentz/conversions/ConversionStatusPublisher;", "fileCacheService", "Lde/justsoftware/justdocumentz/common/FileCacheService;", "storagePaths", "Lde/justsoftware/justdocumentz/util/StoragePaths;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/conversions/video/VideoConversionService;Lde/justsoftware/justdocumentz/conversions/document/DocumentConversionService;Lde/justsoftware/justdocumentz/conversions/ConversionStatusPublisher;Lde/justsoftware/justdocumentz/common/FileCacheService;Lde/justsoftware/justdocumentz/util/StoragePaths;)V", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getConversionStatusPublisher", "()Lde/justsoftware/justdocumentz/conversions/ConversionStatusPublisher;", "getDocumentConversionService", "()Lde/justsoftware/justdocumentz/conversions/document/DocumentConversionService;", "getFileCacheService", "()Lde/justsoftware/justdocumentz/common/FileCacheService;", "logger", "Lorg/slf4j/Logger;", "getStoragePaths", "()Lde/justsoftware/justdocumentz/util/StoragePaths;", "getVideoConversionService", "()Lde/justsoftware/justdocumentz/conversions/video/VideoConversionService;", "convertDocument", "", "task", "Lde/justsoftware/justdocumentz/conversions/ConversionTask;", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nConversionJobRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversionJobRunner.kt\nde/justsoftware/justdocumentz/conversions/ConversionJobService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n9#2:106\n1#3:107\n1855#4,2:108\n*S KotlinDebug\n*F\n+ 1 ConversionJobRunner.kt\nde/justsoftware/justdocumentz/conversions/ConversionJobService\n*L\n34#1:106\n75#1:108,2\n*E\n"})
public class ConversionJobService {
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final VideoConversionService videoConversionService;
    @NotNull
    private final DocumentConversionService documentConversionService;
    @NotNull
    private final ConversionStatusPublisher conversionStatusPublisher;
    @NotNull
    private final FileCacheService fileCacheService;
    @NotNull
    private final StoragePaths storagePaths;
    @NotNull
    private final Logger logger;

    public ConversionJobService(@NotNull JudoConfig config, @NotNull VideoConversionService videoConversionService, @NotNull DocumentConversionService documentConversionService, @NotNull ConversionStatusPublisher conversionStatusPublisher, @NotNull FileCacheService fileCacheService, @NotNull StoragePaths storagePaths) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)videoConversionService, (String)"videoConversionService");
        Intrinsics.checkNotNullParameter((Object)documentConversionService, (String)"documentConversionService");
        Intrinsics.checkNotNullParameter((Object)conversionStatusPublisher, (String)"conversionStatusPublisher");
        Intrinsics.checkNotNullParameter((Object)fileCacheService, (String)"fileCacheService");
        Intrinsics.checkNotNullParameter((Object)storagePaths, (String)"storagePaths");
        this.config = config;
        this.videoConversionService = videoConversionService;
        this.documentConversionService = documentConversionService;
        this.conversionStatusPublisher = conversionStatusPublisher;
        this.fileCacheService = fileCacheService;
        this.storagePaths = storagePaths;
        ConversionJobService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(ConversionJobService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public VideoConversionService getVideoConversionService() {
        return this.videoConversionService;
    }

    @NotNull
    public DocumentConversionService getDocumentConversionService() {
        return this.documentConversionService;
    }

    @NotNull
    public ConversionStatusPublisher getConversionStatusPublisher() {
        return this.conversionStatusPublisher;
    }

    @NotNull
    public FileCacheService getFileCacheService() {
        return this.fileCacheService;
    }

    @NotNull
    public StoragePaths getStoragePaths() {
        return this.storagePaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void convertDocument(@NotNull ConversionTask task) {
        block15: {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            this.logger.info("Starting conversion for task: " + task.getId());
            this.getConversionStatusPublisher().publishProcessing(task);
            FileCacheService fileCacheService = this.getFileCacheService();
            String string = task.getStorageId();
            if (string == null) {
                string = task.getId();
            }
            if (Result.isSuccess-impl((Object)(object2 = fileCacheService.downloadToFileCache-0E7RQCE(string, task.getRemoteUrl(), false)))) {
                Object object3;
                object = object2;
                try {
                    object3 = object;
                    Path downloadedFile = (Path)object3;
                    boolean bl = false;
                    Iterable<Path> iterable = this.getConfig().getTempDirPath().resolve(task.getId());
                    Path it = iterable;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    FileUtilsKt.ensureDirectoryExists((Path)it);
                    Path jobTempDir = iterable;
                    try {
                        if (StringsKt.startsWith$default((String)task.getMimeType(), (String)"video", (boolean)false, (int)2, null)) {
                            Object it2;
                            VideoConversionService videoConversionService = this.getVideoConversionService();
                            Intrinsics.checkNotNull((Object)jobTempDir);
                            iterable = videoConversionService.convert(downloadedFile, jobTempDir);
                            Path coverImageTempPath = (Path)iterable.get(0);
                            Path convertedVideoTempPath = (Path)iterable.get(1);
                            Object object4 = this.getStoragePaths().coverImage(task.getId());
                            CopyOption[] copyOptionArray = object4;
                            Path path = coverImageTempPath;
                            boolean bl3 = false;
                            Path path2 = it2.getParent();
                            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
                            FileUtilsKt.ensureDirectoryExists((Path)path2);
                            CopyOption[] copyOptionArray2 = object4;
                            object4 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            Files.copy(path, (Path)copyOptionArray2, (CopyOption[])object4);
                            it2 = object4 = this.getStoragePaths().convertedVideo(task.getId());
                            path = convertedVideoTempPath;
                            boolean bl4 = false;
                            Path path3 = it2.getParent();
                            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
                            FileUtilsKt.ensureDirectoryExists((Path)path3);
                            Object object5 = object4;
                            object4 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            Files.copy(path, (Path)object5, (CopyOption[])object4);
                        } else {
                            DocumentConversionService documentConversionService = this.getDocumentConversionService();
                            Intrinsics.checkNotNull((Object)jobTempDir);
                            List previewTempFiles = documentConversionService.convert(downloadedFile, jobTempDir);
                            Iterable $this$forEach$iv = previewTempFiles;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                void it3;
                                CopyOption[] copyOptionArray;
                                Path previewTempFile = (Path)element$iv;
                                boolean bl5 = false;
                                CopyOption[] copyOptionArray3 = copyOptionArray = this.getStoragePaths().documentPreviewFile(task.getId(), ((Object)previewTempFile.getFileName()).toString());
                                Path path = previewTempFile;
                                boolean bl6 = false;
                                Path path4 = it3.getParent();
                                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"getParent(...)");
                                FileUtilsKt.ensureDirectoryExists((Path)path4);
                                CopyOption[] copyOptionArray4 = copyOptionArray;
                                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                                Files.copy(path, (Path)copyOptionArray4, copyOptionArray);
                            }
                        }
                        this.logger.info("Finished conversion for task: " + task.getId());
                        this.getConversionStatusPublisher().publishPresent(task);
                        FileUtilsKt.deleteDirectory((Path)jobTempDir);
                    }
                    catch (UnsupportedConversionException e) {
                        this.logger.info("Unsupported conversion for task: " + task.getId() + ". message: " + e.getMessage());
                        this.getConversionStatusPublisher().publishUnsupported(task);
                    }
                    finally {
                        Intrinsics.checkNotNull((Object)jobTempDir);
                        FileUtilsKt.deleteDirectory((Path)jobTempDir);
                    }
                    object3 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable downloadedFile) {
                    object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)downloadedFile));
                }
                v10 = object3;
            } else {
                v10 = object2 = Result.constructor-impl((Object)object2);
            }
            if (Result.isSuccess-impl((Object)object2)) {
                Unit it = (Unit)object2;
                boolean bl = false;
                this.getFileCacheService().removeFromFileCache(task.getId());
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block15;
            Object it = object = throwable;
            boolean bl = false;
            this.logger.error("Error during conversion for task: " + task.getId(), (Throwable)it);
            this.getConversionStatusPublisher().publishError(task);
        }
    }
}

