/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.controller;

import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.util.FileUtilsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u00020\n2\u0010\u0010\u000b\u001a\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\fH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/justdocumentz/controller/DocumentApiService;", "", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;)V", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "logger", "Lorg/slf4j/Logger;", "deleteAll", "", "documentIds", "", "Ljava/util/UUID;", "Lde/justsoftware/justdocumentz/model/DocumentId;", "deletePreviewSources", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentApiController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentApiController.kt\nde/justsoftware/justdocumentz/controller/DocumentApiService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,49:1\n9#2:50\n1#3:51\n*S KotlinDebug\n*F\n+ 1 DocumentApiController.kt\nde/justsoftware/justdocumentz/controller/DocumentApiService\n*L\n31#1:50\n*E\n"})
public class DocumentApiService {
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final Logger logger;

    public DocumentApiService(@NotNull JudoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        DocumentApiService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(DocumentApiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    public void deletePreviewSources() {
        this.logger.info("Deleting all preview sources.");
        FileUtilsKt.deleteDirectory((Path)this.getConfig().getCacheDirPath());
    }

    public void deleteAll(@NotNull List<UUID> documentIds) {
        Intrinsics.checkNotNullParameter(documentIds, (String)"documentIds");
        for (UUID documentId : documentIds) {
            Object object;
            Object object2 = this;
            try {
                DocumentApiService $this$deleteAll_u24lambda_u241 = object2;
                boolean bl = false;
                JudoConfig judoConfig = $this$deleteAll_u24lambda_u241.getConfig();
                String string = documentId.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                Path documentDir = judoConfig.outputDir(string);
                if (!Files.exists(documentDir, new LinkOption[0])) {
                    boolean bl2 = false;
                    $this$deleteAll_u24lambda_u241.logger.info("documentDir " + documentDir + " cannot be deleted as it does not exist: ");
                    Unit unit = Unit.INSTANCE;
                    throw new IllegalStateException(unit.toString());
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object e = object = throwable;
            boolean bl = false;
            this.logger.warn("Error while trying to delete " + documentId + ": " + ((Throwable)e).getMessage());
        }
    }
}

