/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.util;

import de.justsoftware.jdoc.util.JustDocUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class ZipUtil {
    private static final FileFilter ANY_FILE_FILTER = pathname -> true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzipFolder(ZipInputStream zipInput, File targetFolder) throws IOException {
        if (!targetFolder.exists() && !targetFolder.mkdirs()) {
            throw new IOException("targetFolder not accessible");
        }
        try {
            ZipEntry entry = zipInput.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    FileUtils.forceMkdir((File)new File(targetFolder, entry.getName()));
                } else {
                    FileOutputStream out = null;
                    try {
                        out = new FileOutputStream(new File(targetFolder, entry.getName()));
                        IOUtils.copy((InputStream)zipInput, (OutputStream)out);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        zipInput.closeEntry();
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                    zipInput.closeEntry();
                }
                entry = zipInput.getNextEntry();
            }
            return;
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFolder(File srcFolder, File destZipFile) throws IOException {
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        fileWriter = new FileOutputStream(destZipFile);
        zip = new ZipOutputStream(fileWriter);
        try {
            for (File file : JustDocUtil.listFiles((File)srcFolder, (FileFilter)ANY_FILE_FILTER)) {
                ZipUtil.addToZip(null, (File)file, (ZipOutputStream)zip);
            }
        }
        finally {
            zip.flush();
            IOUtils.closeQuietly((OutputStream)zip);
        }
    }

    private static void addToZip(@Nullable String path, File file, ZipOutputStream zip) throws IOException {
        if (file.isDirectory()) {
            ZipUtil.addFolderToZip((String)path, (File)file, (ZipOutputStream)zip);
        } else {
            ZipUtil.addFileToZip((String)path, (File)file, (ZipOutputStream)zip);
        }
    }

    @Nonnull
    private static String getZipPath(@Nullable String path, String name) {
        return path != null ? path + "/" + name : name;
    }

    private static void addFolderToZip(@Nullable String path, File folder, ZipOutputStream zip) throws IOException {
        for (File file : JustDocUtil.listFiles((File)folder, (FileFilter)ANY_FILE_FILTER)) {
            ZipUtil.addToZip((String)ZipUtil.getZipPath((String)path, (String)folder.getName()), (File)file, (ZipOutputStream)zip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToZip(@Nullable String path, File file, ZipOutputStream zip) throws IOException {
        FileInputStream in = null;
        try {
            zip.putNextEntry(new ZipEntry(ZipUtil.getZipPath((String)path, (String)file.getName())));
            in = new FileInputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)zip);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }
}

