/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import de.justsoftware.chat.config.ExceptionHandlerConfiguration;
import de.justsoftware.chat.exception.DeprecatedChangesException;
import de.justsoftware.chat.exception.InvalidSyncTokenException;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.UnauthorizedException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.exception.XmppException;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.tomcat.util.http.fileupload.impl.SizeLimitExceededException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@Configuration
@ControllerAdvice
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0017J\u0016\u0010\t\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0017J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0017J\u0016\u0010\f\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u0017J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u000eH\u0017J\u001e\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00102\u0006\u0010\u0006\u001a\u00020\u0011H\u0017J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0017J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001dH\u0017\u00a8\u0006 "}, d2={"Lde/justsoftware/chat/config/ExceptionHandlerConfiguration;", "", "<init>", "()V", "handleAllExceptions", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleNotFoundExceptions", "handleNotAllowedException", "Lde/justsoftware/chat/exception/NotAllowedException;", "handleBadRequestExceptions", "handleXmppException", "Lde/justsoftware/chat/exception/XmppException;", "handleValidationException", "", "Lde/justsoftware/chat/exception/ValidationException;", "handleUnauthorizedException", "Lde/justsoftware/chat/exception/UnauthorizedException;", "forwardRestClientExceptions", "", "Lorg/springframework/web/client/HttpStatusCodeException;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "forwardSizeLimitExceptions", "Lde/justsoftware/chat/config/ExceptionHandlerConfiguration$SizeExceeded;", "error", "Lorg/apache/tomcat/util/http/fileupload/impl/SizeLimitExceededException;", "Lorg/springframework/web/multipart/MaxUploadSizeExceededException;", "SizeExceeded", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nExceptionHandlerConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/chat/config/ExceptionHandlerConfiguration\n+ 2 ExceptionHandlerConfiguration.kt\nde/justsoftware/chat/config/ExceptionHandlerConfiguration$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n*L\n1#1,119:1\n110#2,6:120\n1#3:126\n9#4:127\n8#4,3:128\n*S KotlinDebug\n*F\n+ 1 ExceptionHandlerConfiguration.kt\nde/justsoftware/chat/config/ExceptionHandlerConfiguration\n*L\n100#1:120,6\n106#1:127\n106#1:128,3\n*E\n"})
public class ExceptionHandlerConfiguration {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DEFAULT_ERROR = "An unexpected error occurred.";

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    @NotNull
    public String handleAllExceptions(@NotNull Exception e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String it = string = DEFAULT_ERROR;
        boolean bl = false;
        LOG.error(DEFAULT_ERROR, (Throwable)e);
        return string;
    }

    @ExceptionHandler(value={NotFoundException.class, DeprecatedChangesException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    @Nullable
    public String handleNotFoundExceptions(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={NotAllowedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    @Nullable
    public String handleNotAllowedException(@NotNull NotAllowedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class, HttpMessageConversionException.class, InvalidSyncTokenException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @Nullable
    public String handleBadRequestExceptions(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={XmppException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    @Nullable
    public String handleXmppException(@NotNull XmppException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    @NotNull
    public Map<String, String> handleValidationException(@NotNull ValidationException e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"error", (Object)e.getMessage()), TuplesKt.to((Object)"errorCode", (Object)e.getErrorCode())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    @Nullable
    public String handleUnauthorizedException(@NotNull UnauthorizedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getMessage();
    }

    @ExceptionHandler(value={HttpClientErrorException.class, HttpServerErrorException.class})
    @ResponseBody
    @NotNull
    public byte[] forwardRestClientExceptions(@NotNull HttpStatusCodeException e, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        response.setStatus(e.getStatusCode().value());
        byte[] byArray = e.getResponseBodyAsByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getResponseBodyAsByteArray(...)");
        return byArray;
    }

    @ExceptionHandler(value={SizeLimitExceededException.class})
    @ResponseStatus(value=HttpStatus.PAYLOAD_TOO_LARGE)
    @ResponseBody
    @NotNull
    public SizeExceeded forwardSizeLimitExceptions(@NotNull SizeLimitExceededException error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return new SizeExceeded(error.getPermittedSize());
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    @ResponseStatus(value=HttpStatus.PAYLOAD_TOO_LARGE)
    @ResponseBody
    @NotNull
    public SizeExceeded forwardSizeLimitExceptions(@NotNull MaxUploadSizeExceededException error) {
        Throwable throwable;
        block2: {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Companion companion = Companion;
            Throwable $this$findCause$iv = (Throwable)error;
            boolean $i$f$findCause = false;
            for (Throwable current$iv = $this$findCause$iv.getCause(); current$iv != null; current$iv = current$iv.getCause()) {
                if (!(current$iv instanceof SizeLimitExceededException)) continue;
                throwable = current$iv;
                break block2;
            }
            throwable = null;
        }
        SizeLimitExceededException sizeLimitExceededException = (SizeLimitExceededException)throwable;
        if (sizeLimitExceededException != null) {
            SizeLimitExceededException it = sizeLimitExceededException;
            boolean bl = false;
            return new SizeExceeded(it.getPermittedSize());
        }
        return new SizeExceeded(error.getMaxUploadSize());
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

