/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.toolbox.result;

import com.google.common.collect.Iterables;
import de.justsoftware.admin.mybatis.toolbox.DAOSupport;
import de.justsoftware.admin.mybatis.toolbox.SupportedJdbcDriver;
import de.justsoftware.admin.mybatis.toolbox.result.ChunkedResultHandler;
import de.justsoftware.admin.mybatis.toolbox.result.CountingResultHandler;
import de.justsoftware.admin.mybatis.toolbox.result.DAOSupportImpl;
import de.justsoftware.admin.mybatis.toolbox.result.InternalDAOSupport;
import de.justsoftware.admin.mybatis.toolbox.result.NoResultQuery;
import de.justsoftware.admin.mybatis.toolbox.result.ResultHandlerBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.session.ResultHandler;

@ParametersAreNonnullByDefault
public class DAOSupportImpl
implements DAOSupport,
InternalDAOSupport {
    private final Supplier<SupportedJdbcDriver> _jdbcDriverSupplier;

    public DAOSupportImpl(Supplier<SupportedJdbcDriver> jdbcDriverSupplier) {
        this._jdbcDriverSupplier = jdbcDriverSupplier;
    }

    public int defaultPartitionSize() {
        SupportedJdbcDriver driver = (SupportedJdbcDriver)this._jdbcDriverSupplier.get();
        switch (1.$SwitchMap$de$justsoftware$admin$mybatis$toolbox$SupportedJdbcDriver[driver.ordinal()]) {
            case 1: {
                return 900;
            }
            case 2: {
                return 10000;
            }
        }
        throw new UnsupportedOperationException("no behavior for " + String.valueOf(driver) + " defined");
    }

    public <ID> ResultHandlerBuilder<ID> partition(Set<? extends ID> ids) {
        return new ResultHandlerBuilder((InternalDAOSupport)this, ids);
    }

    public <ID> void partition(Set<? extends ID> ids, NoResultQuery<ID> query) {
        for (List partition : Iterables.partition(ids, (int)this.defaultPartitionSize())) {
            query.query(Collections.unmodifiableList(partition));
        }
    }

    public <T> int forAllChunked(int chunkSize, Consumer<List<T>> consumer, Consumer<ResultHandler<T>> method) {
        return new ChunkedResultHandler(chunkSize, consumer).applyTo(method);
    }

    public <T> int forAll(Consumer<T> consumer, Consumer<ResultHandler<T>> method) {
        return new CountingResultHandler(consumer).applyTo(method);
    }
}

