/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.authorization.AuthorizationContextProvider;
import de.justsoftware.people.exceptions.UnauthorizedException;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class AuthorizationContextResolver
implements HandlerMethodArgumentResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationContextResolver.class);
    private static final String DEFAULT_ERROR_MESSAGE = "An error occurred authorizing your request.";
    private static final ImmutableSet<Class<?>> SUPPORTED = ImmutableSet.of(AuthorizationContext.class);
    private final AuthorizationContextProvider _authorizationContextProvider;

    public AuthorizationContextResolver(AuthorizationContextProvider authorizationContextProvider) {
        this._authorizationContextProvider = authorizationContextProvider;
    }

    @Nonnull
    private static ProfileId getProfileId(JwtAuthenticationToken authentication) throws UnauthorizedException {
        String principal = authentication.getPrincipal();
        try {
            return ProfileId.parse((String)principal);
        }
        catch (Exception ex) {
            LOGGER.warn("We received an unparsable profile ID: {}", (Object)principal);
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
    }

    @Nonnull
    private static TenantId getTenantId(JwtAuthenticationToken authentication) throws UnauthorizedException {
        Object tenantId = authentication.getCustomJwtClaims().get((Object)"tenantId");
        if (tenantId == null) {
            throw new UnauthorizedException("You must be logged in a valid tenant");
        }
        try {
            return TenantId.parse((String)tenantId.toString());
        }
        catch (Exception ex) {
            LOGGER.warn("We received an unparsable tenant ID: {}", tenantId);
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return SUPPORTED.contains((Object)parameter.getParameterType());
    }

    @Nonnull
    public AuthorizationContext resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws UnauthorizedException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new UnauthorizedException("You must be logged in to perform this request");
        }
        if (authentication instanceof JwtAuthenticationToken) {
            return this._authorizationContextProvider.forProfileAndTenant(AuthorizationContextResolver.getProfileId((JwtAuthenticationToken)((JwtAuthenticationToken)authentication)), AuthorizationContextResolver.getTenantId((JwtAuthenticationToken)((JwtAuthenticationToken)authentication)));
        }
        LOGGER.warn("We received an unknown type of authentication: {}", authentication.getClass());
        throw new UnauthorizedException("You must be logged in to perform this request");
    }
}

