/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.notification;

import de.justsoftware.notificationclient.NotificationProducer;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationclient.model.NotificationBuilder;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.people.business.notification.NotificationService;
import de.justsoftware.people.config.ApplicationConfiguration;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.utils.CollectionUtilsKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J6\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0016JX\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f0\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000f0\u0018H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/people/business/notification/NotificationService;", "", "notificationProducer", "Lde/justsoftware/notificationclient/NotificationProducer;", "resourceBundle", "Lorg/springframework/context/support/ResourceBundleMessageSource;", "<init>", "(Lde/justsoftware/notificationclient/NotificationProducer;Lorg/springframework/context/support/ResourceBundleMessageSource;)V", "sendBirthdayNotifications", "", "tenantId", "Lde/justsoftware/people/model/TenantId;", "profileId", "Lde/justsoftware/people/model/ProfileId;", "firstName", "", "fullName", "receiverIds", "", "sendNotifications", "targetId", "notificationType", "Lde/justsoftware/notificationclient/model/NotificationType;", "localTitle", "", "Ljava/util/Locale;", "localText", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationService.kt\nde/justsoftware/people/business/notification/NotificationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1279#2,2:85\n1293#2,4:87\n1279#2,2:91\n1293#2,4:93\n1628#2,3:98\n17#3:97\n1#4:101\n*S KotlinDebug\n*F\n+ 1 NotificationService.kt\nde/justsoftware/people/business/notification/NotificationService\n*L\n27#1:85,2\n27#1:87,4\n35#1:91,2\n35#1:93,4\n71#1:98,3\n71#1:97\n*E\n"})
public class NotificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotificationProducer notificationProducer;
    @NotNull
    private final ResourceBundleMessageSource resourceBundle;
    @NotNull
    public static final String APP_ID = "people";

    public NotificationService(@NotNull NotificationProducer notificationProducer, @NotNull ResourceBundleMessageSource resourceBundle) {
        Intrinsics.checkNotNullParameter((Object)notificationProducer, (String)"notificationProducer");
        Intrinsics.checkNotNullParameter((Object)resourceBundle, (String)"resourceBundle");
        this.notificationProducer = notificationProducer;
        this.resourceBundle = resourceBundle;
    }

    /*
     * WARNING - void declaration
     */
    public void sendBirthdayNotifications(@NotNull TenantId tenantId, @NotNull ProfileId profileId, @NotNull String firstName, @NotNull String fullName, @NotNull Set<ProfileId> receiverIds) {
        String string;
        Map map;
        Object t;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)firstName, (String)"firstName");
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Iterable $this$associateWith$iv = ApplicationConfiguration.Companion.getSUPPORTED_LOCALES();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void locale;
            Locale locale2 = (Locale)element$iv$iv;
            t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{firstName};
            string = this.resourceBundle.getMessage("people.notification.birthdayTitle", objectArray, (Locale)locale);
            map.put(t, string);
        }
        Map localeNotificationTitle = result$iv;
        Iterable $this$associateWith$iv2 = ApplicationConfiguration.Companion.getSUPPORTED_LOCALES();
        boolean $i$f$associateWith2 = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv2 = $this$associateWith$iv2;
        boolean $i$f$associateWithTo2 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv2) {
            void locale;
            Locale bl = (Locale)element$iv$iv;
            t = element$iv$iv;
            map = result$iv2;
            boolean bl2 = false;
            Object[] objectArray = new String[]{fullName};
            string = this.resourceBundle.getMessage("people.notification.birthdayText", objectArray, (Locale)locale);
            map.put(t, string);
        }
        Map localeNotificationText = result$iv2;
        this.sendNotifications(tenantId, profileId, receiverIds, NotificationType.PERSON_HAS_BIRTHDAY, localeNotificationTitle, localeNotificationText);
    }

    /*
     * WARNING - void declaration
     */
    private void sendNotifications(TenantId tenantId, ProfileId targetId, Set<ProfileId> receiverIds, NotificationType notificationType, Map<Locale, String> localTitle, Map<Locale, String> localText) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Iterable iterable = receiverIds;
        NotificationBuilder notificationBuilder = Notification.builder((UUID)((UUID)tenantId.getId()), (String)APP_ID, (String)((String)MapsKt.getValue(localTitle, (Object)ApplicationConfiguration.Companion.getDEFAULT_LOCALE())), (String)((String)MapsKt.getValue(localText, (Object)ApplicationConfiguration.Companion.getDEFAULT_LOCALE())), (NotificationType)notificationType).withLocalizedTitle(localTitle).withLocalizedText(localText);
        boolean $i$f$mapToSet = false;
        void var9_11 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$sendNotifications$stub_for_inlining = false;
            boolean bl = false;
            collection.add(p0.asString());
        }
        ProfileId profileId = targetId;
        iterable = notificationBuilder.withReceivers((Set)destination$iv$iv).withPayload(APP_ID).withTargetId(profileId != null ? profileId.asString() : null).build();
        NotificationProducer notificationProducer = this.notificationProducer;
        Iterable p0 = iterable;
        boolean $i$f$sendNotifications$stub_for_inlining$2 = false;
        boolean bl = false;
        notificationProducer.dispatchNotification((Notification)p0);
    }
}

