/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.business;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.notificationclient.model.NotificationConcern;
import de.justsoftware.notificationclient.model.NotificationType;
import de.justsoftware.notificationservice.exception.NotificationNotFoundException;
import de.justsoftware.notificationservice.mobile.persistence.DeletedDeliveryStatusForSyncRepository;
import de.justsoftware.notificationservice.mobile.persistence.model.DbDeletedDeliveryStatusForSync;
import de.justsoftware.notificationservice.mobile.service.MobilePushNotificationService;
import de.justsoftware.notificationservice.model.Notification;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.model.NotificationsCount;
import de.justsoftware.notificationservice.model.PageRequests;
import de.justsoftware.notificationservice.model.Profile;
import de.justsoftware.notificationservice.model.event.ProfileUpdateEvent;
import de.justsoftware.notificationservice.persistence.DeliveryStatusRepository;
import de.justsoftware.notificationservice.persistence.NotificationRepository;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatus;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusId;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusWithNotification;
import de.justsoftware.notificationservice.persistence.model.DbNotification;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import de.justsoftware.notificationservice.util.CollectionUtilKt;
import de.justsoftware.notificationservice.util.TransactionUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJH\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0018H\u0017J(\u0010'\u001a\b\u0012\u0004\u0012\u00020 0$2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0017J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J*\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001c0+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00120-2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J$\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020/0+2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u001aH\u0017J\u0018\u00101\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u00102\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u00103\u001a\u00020\u001e2\f\u00104\u001a\b\u0012\u0004\u0012\u00020 0\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u000207H\u0017JF\u00108\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u0010\u0011\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020<H\u0012J.\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\r2\u0006\u0010\u0011\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lde/justsoftware/notificationservice/business/NotificationService;", "", "notificationRepository", "Lde/justsoftware/notificationservice/persistence/NotificationRepository;", "deliveryStatusRepository", "Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;", "deletedDeliveryStatusRepository", "Lde/justsoftware/notificationservice/mobile/persistence/DeletedDeliveryStatusForSyncRepository;", "mobilePushNotificationService", "Lde/justsoftware/notificationservice/mobile/service/MobilePushNotificationService;", "<init>", "(Lde/justsoftware/notificationservice/persistence/NotificationRepository;Lde/justsoftware/notificationservice/persistence/DeliveryStatusRepository;Lde/justsoftware/notificationservice/mobile/persistence/DeletedDeliveryStatusForSyncRepository;Lde/justsoftware/notificationservice/mobile/service/MobilePushNotificationService;)V", "getNotifications", "", "Lde/justsoftware/notificationservice/model/Notification;", "locale", "Ljava/util/Locale;", "receiverId", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "status", "Lde/justsoftware/notificationservice/model/NotificationStatus;", "concern", "Lde/justsoftware/notificationclient/model/NotificationConcern;", "app", "", "before", "Ljava/time/Instant;", "maxElements", "", "archiveNotification", "", "notificationId", "Ljava/util/UUID;", "archiveAllNotificationsForTargetAndReceiver", "targetId", "types", "", "Lde/justsoftware/notificationclient/model/NotificationType;", "deleteForTarget", "archiveAllUnmarkedNotifications", "getNotificationsCount", "Lde/justsoftware/notificationservice/model/NotificationsCount;", "getNotificationCounts", "", "profileIds", "", "updated", "", "since", "markNotification", "unmarkNotification", "moveToOpen", "notificationIds", "onProfileUpdates", "event", "Lde/justsoftware/notificationservice/model/event/ProfileUpdateEvent;", "findWithNotificationsBefore", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/notificationservice/persistence/model/DbDeliveryStatusWithNotification;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findAllOpenAndUnmarked", "Lde/justsoftware/notificationservice/persistence/model/DbDeliveryStatus;", "notification-service"})
@SourceDebugExtension(value={"SMAP\nNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationService.kt\nde/justsoftware/notificationservice/business/NotificationService\n+ 2 CollectionUtil.kt\nde/justsoftware/notificationservice/util/CollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,270:1\n17#2:271\n17#2:275\n17#2:279\n1634#3,3:272\n1634#3,3:276\n1634#3,3:280\n1563#3:283\n1634#3,3:284\n1252#3,4:289\n478#4:287\n424#4:288\n*S KotlinDebug\n*F\n+ 1 NotificationService.kt\nde/justsoftware/notificationservice/business/NotificationService\n*L\n116#1:271\n117#1:275\n137#1:279\n116#1:272,3\n117#1:276,3\n137#1:280,3\n175#1:283\n175#1:284,3\n176#1:289,4\n176#1:287\n176#1:288\n*E\n"})
public class NotificationService {
    @NotNull
    private final NotificationRepository notificationRepository;
    @NotNull
    private final DeliveryStatusRepository deliveryStatusRepository;
    @NotNull
    private final DeletedDeliveryStatusForSyncRepository deletedDeliveryStatusRepository;
    @NotNull
    private final MobilePushNotificationService mobilePushNotificationService;

    public NotificationService(@NotNull NotificationRepository notificationRepository, @NotNull DeliveryStatusRepository deliveryStatusRepository, @NotNull DeletedDeliveryStatusForSyncRepository deletedDeliveryStatusRepository, @NotNull MobilePushNotificationService mobilePushNotificationService) {
        Intrinsics.checkNotNullParameter((Object)notificationRepository, (String)"notificationRepository");
        Intrinsics.checkNotNullParameter((Object)deliveryStatusRepository, (String)"deliveryStatusRepository");
        Intrinsics.checkNotNullParameter((Object)deletedDeliveryStatusRepository, (String)"deletedDeliveryStatusRepository");
        Intrinsics.checkNotNullParameter((Object)mobilePushNotificationService, (String)"mobilePushNotificationService");
        this.notificationRepository = notificationRepository;
        this.deliveryStatusRepository = deliveryStatusRepository;
        this.deletedDeliveryStatusRepository = deletedDeliveryStatusRepository;
        this.mobilePushNotificationService = mobilePushNotificationService;
    }

    @NotNull
    public List<Notification> getNotifications(@NotNull Locale locale, @NotNull ProfileId receiverId, @NotNull NotificationStatus status, @NotNull NotificationConcern concern, @Nullable String app, @NotNull Instant before, int maxElements) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)concern, (String)"concern");
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        ImmutableSet immutableSet = NotificationType.forConcern((NotificationConcern)concern);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"forConcern(...)");
        List<Notification> list = this.findWithNotificationsBefore(string, (Set)immutableSet, status, app, before, (Pageable)PageRequests.recentNotifications((int)maxElements)).get().map(arg_0 -> NotificationService.getNotifications$lambda$1(arg_0 -> NotificationService.getNotifications$lambda$0(locale, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    public void archiveNotification(@NotNull UUID notificationId, @NotNull ProfileId receiverId) throws NotificationNotFoundException {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        int updated = this.deliveryStatusRepository.setArchived(string, notificationId, instant);
        if (updated == 0) {
            throw new NotificationNotFoundException();
        }
        this.deliveryStatusRepository.flush();
        TransactionUtilsKt.afterCommit(() -> NotificationService.archiveNotification$lambda$2(this, receiverId));
    }

    @Transactional
    public void archiveAllNotificationsForTargetAndReceiver(@NotNull String targetId, @NotNull Set<? extends NotificationType> types, @NotNull ProfileId receiverId) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Iterable iterable = types;
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.deliveryStatusRepository.archiveAllByTarget(targetId, iterable, string, instant);
        this.deliveryStatusRepository.flush();
        TransactionUtilsKt.afterCommit(() -> NotificationService.archiveAllNotificationsForTargetAndReceiver$lambda$3(this, receiverId));
    }

    @Transactional
    public int deleteForTarget(@NotNull String targetId) {
        String p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv;
        DbDeletedDeliveryStatusForSync deletedDeliveryStatus;
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        List deliveryStatusList = this.deliveryStatusRepository.findIdByTargetId(targetId);
        Iterator iterator = ((Iterable)deliveryStatusList).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            DbDeliveryStatusId deliveryStatus = (DbDeliveryStatusId)iterator.next();
            deletedDeliveryStatus = new DbDeletedDeliveryStatusForSync(deliveryStatus.getNotificationId(), deliveryStatus.getReceiverId());
            this.deletedDeliveryStatusRepository.save((Object)deletedDeliveryStatus);
            if (index % 100 != 0) continue;
            this.deletedDeliveryStatusRepository.flush();
        }
        int count = this.notificationRepository.deleteByTargetId(targetId);
        Iterable index = deliveryStatusList;
        boolean $i$f$mapToSet = false;
        deletedDeliveryStatus = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DbDeliveryStatusId dbDeliveryStatusId = (DbDeliveryStatusId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getReceiverId());
        }
        $this$mapToSet$iv = (Set)destination$iv$iv;
        $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ProfileId.fromString((String)p0));
        }
        Set receiverIds = (Set)destination$iv$iv;
        if (!receiverIds.isEmpty()) {
            TransactionUtilsKt.afterCommit(() -> NotificationService.deleteForTarget$lambda$5(this, receiverIds));
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Set<UUID> archiveAllUnmarkedNotifications(@NotNull ProfileId receiverId, @NotNull NotificationConcern concern, @Nullable String app) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)concern, (String)"concern");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        ImmutableSet immutableSet = NotificationType.forConcern((NotificationConcern)concern);
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"forConcern(...)");
        Iterable iterable = this.findAllOpenAndUnmarked(string, (Set)immutableSet, app);
        boolean $i$f$mapToSet = false;
        void var7_6 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbDeliveryStatus dbDeliveryStatus = (DbDeliveryStatus)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getNotificationId());
        }
        Set notificationIds = (Set)destination$iv$iv;
        if (notificationIds.isEmpty()) {
            return notificationIds;
        }
        Iterable iterable2 = notificationIds;
        String string2 = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.deliveryStatusRepository.setArchived(iterable2, string2, instant);
        this.deliveryStatusRepository.flush();
        TransactionUtilsKt.afterCommit(() -> NotificationService.archiveAllUnmarkedNotifications$lambda$7(this, receiverId));
        return notificationIds;
    }

    @Transactional
    @NotNull
    public NotificationsCount getNotificationsCount(@NotNull ProfileId receiverId) {
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        int open = this.deliveryStatusRepository.countByReceiverIdAndStatus(string, NotificationStatus.OPEN);
        String string2 = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        int archived = this.deliveryStatusRepository.countByReceiverIdAndStatus(string2, NotificationStatus.ARCHIVED);
        return new NotificationsCount(open, archived);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ProfileId, Integer> getNotificationCounts(@NotNull Collection<? extends ProfileId> profileIds, @NotNull NotificationStatus status) {
        void $this$mapKeysTo$iv$iv;
        Map $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Iterable iterable = profileIds;
        Object object = this.deliveryStatusRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p0;
            Object item$iv$iv = iterator.next();
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toString());
        }
        Map $this$mapKeys$iv = object.countByReceiverIdsAndStatusAsMap((Iterable)((List)destination$iv$iv), status);
        boolean $i$f$mapKeys = false;
        $this$mapTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            ProfileId profileId;
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)ProfileId.fromString((String)((String)it.getKey())), (String)"fromString(...)");
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object object2 = object;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            object2.put(profileId, entry);
        }
        return destination$iv$iv;
    }

    @Transactional
    @NotNull
    public Map<String, Boolean> updated(@NotNull ProfileId receiverId, @NotNull Instant since) {
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        int updatesCount = this.deliveryStatusRepository.countUpdatesForReceiverSinceTimestamp(string, since);
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"updated", (Object)(updatesCount > 0 ? 1 : 0)));
    }

    public void markNotification(@NotNull UUID notificationId, @NotNull ProfileId receiverId) throws NotificationNotFoundException {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        int updated = this.deliveryStatusRepository.mark(string, notificationId, instant);
        if (updated == 0) {
            throw new NotificationNotFoundException();
        }
        TransactionUtilsKt.afterCommit(() -> NotificationService.markNotification$lambda$10(this, receiverId));
    }

    public void unmarkNotification(@NotNull UUID notificationId, @NotNull ProfileId receiverId) throws NotificationNotFoundException {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        int updated = this.deliveryStatusRepository.unmark(string, notificationId, instant);
        if (updated == 0) {
            throw new NotificationNotFoundException();
        }
        TransactionUtilsKt.afterCommit(() -> NotificationService.unmarkNotification$lambda$11(this, receiverId));
    }

    public void moveToOpen(@NotNull List<UUID> notificationIds, @NotNull ProfileId receiverId) {
        Intrinsics.checkNotNullParameter(notificationIds, (String)"notificationIds");
        Intrinsics.checkNotNullParameter((Object)receiverId, (String)"receiverId");
        Iterable iterable = notificationIds;
        String string = receiverId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        this.deliveryStatusRepository.setOpen(iterable, string, instant);
        TransactionUtilsKt.afterCommit(() -> NotificationService.moveToOpen$lambda$12(this, receiverId));
    }

    @EventListener
    @Transactional
    public void onProfileUpdates(@NotNull ProfileUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Profile profile = event.getProfile();
        if (profile.getDeleted()) {
            String string = profile.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.deliveryStatusRepository.deleteByReceiverId(string);
        }
    }

    private Page<DbDeliveryStatusWithNotification> findWithNotificationsBefore(String receiverId, Set<? extends NotificationType> types, NotificationStatus status, String app, Instant before, Pageable pageable) {
        DeliveryStatusRepository $this$findWithNotificationsBefore_u24lambda_u2413 = this.deliveryStatusRepository;
        boolean bl = false;
        return app == null ? $this$findWithNotificationsBefore_u24lambda_u2413.findWithNotificationsBefore(receiverId, (Iterable)types, status, before, pageable) : $this$findWithNotificationsBefore_u24lambda_u2413.findWithNotificationsBeforeByApp(receiverId, (Iterable)types, status, app, before, pageable);
    }

    private List<DbDeliveryStatus> findAllOpenAndUnmarked(String receiverId, Set<? extends NotificationType> types, String app) {
        DeliveryStatusRepository $this$findAllOpenAndUnmarked_u24lambda_u2414 = this.deliveryStatusRepository;
        boolean bl = false;
        return app == null ? $this$findAllOpenAndUnmarked_u24lambda_u2414.findAllOpenAndUnmarked(receiverId, (Iterable)types) : $this$findAllOpenAndUnmarked_u24lambda_u2414.findAllOpenAndUnmarkedByApp(receiverId, (Iterable)types, app);
    }

    private static final Notification getNotifications$lambda$0(Locale $locale, DbDeliveryStatusWithNotification dbDeliveryStatusWithNotification) {
        DbDeliveryStatus deliveryStatus = dbDeliveryStatusWithNotification.component1();
        DbNotification notification = dbDeliveryStatusWithNotification.component2();
        return Notification.fromDBNotification((Locale)$locale, (DbNotification)notification, (boolean)deliveryStatus.getMarked());
    }

    private static final Notification getNotifications$lambda$1(Function1 $tmp0, Object p0) {
        return (Notification)$tmp0.invoke(p0);
    }

    private static final Unit archiveNotification$lambda$2(NotificationService this$0, ProfileId $receiverId) {
        this$0.mobilePushNotificationService.sendNotificationsUpdatePushNotifications(SetsKt.setOf((Object)$receiverId));
        return Unit.INSTANCE;
    }

    private static final Unit archiveAllNotificationsForTargetAndReceiver$lambda$3(NotificationService this$0, ProfileId $receiverId) {
        this$0.mobilePushNotificationService.sendNotificationsUpdatePushNotifications(SetsKt.setOf((Object)$receiverId));
        return Unit.INSTANCE;
    }

    private static final Unit deleteForTarget$lambda$5(NotificationService this$0, Set $receiverIds) {
        this$0.mobilePushNotificationService.sendNotificationsUpdatePushNotifications($receiverIds);
        return Unit.INSTANCE;
    }

    private static final Unit archiveAllUnmarkedNotifications$lambda$7(NotificationService this$0, ProfileId $receiverId) {
        this$0.mobilePushNotificationService.sendNotificationsUpdatePushNotifications(SetsKt.setOf((Object)$receiverId));
        return Unit.INSTANCE;
    }

    private static final Unit markNotification$lambda$10(NotificationService this$0, ProfileId $receiverId) {
        this$0.mobilePushNotificationService.sendNotificationsUpdatePushNotifications(SetsKt.setOf((Object)$receiverId));
        return Unit.INSTANCE;
    }

    private static final Unit unmarkNotification$lambda$11(NotificationService this$0, ProfileId $receiverId) {
        this$0.mobilePushNotificationService.sendNotificationsUpdatePushNotifications(SetsKt.setOf((Object)$receiverId));
        return Unit.INSTANCE;
    }

    private static final Unit moveToOpen$lambda$12(NotificationService this$0, ProfileId $receiverId) {
        this$0.mobilePushNotificationService.sendNotificationsUpdatePushNotifications(SetsKt.setOf((Object)$receiverId));
        return Unit.INSTANCE;
    }
}

