/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.WindowStoreIterator;

class KeyValueIterators {
    private static final KeyValueIterator EMPTY_ITERATOR = new EmptyKeyValueIterator();
    private static final WindowStoreIterator EMPTY_WINDOW_STORE_ITERATOR = new EmptyWindowStoreIterator();

    KeyValueIterators() {
    }

    static <K, V> KeyValueIterator<K, V> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    static <V> WindowStoreIterator<V> emptyWindowStoreIterator() {
        return EMPTY_WINDOW_STORE_ITERATOR;
    }

    private static class EmptyWindowStoreIterator<V>
    extends EmptyKeyValueIterator<Long, V>
    implements WindowStoreIterator<V> {
        private EmptyWindowStoreIterator() {
        }
    }

    private static class EmptyKeyValueIterator<K, V>
    implements KeyValueIterator<K, V> {
        private EmptyKeyValueIterator() {
        }

        @Override
        public void close() {
        }

        @Override
        public K peekNextKey() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public KeyValue<K, V> next() {
            throw new NoSuchElementException();
        }
    }
}

