/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.config;

import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.config.AuthContextResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lde/justsoftware/wikiservice/config/WikiWebConfiguration;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "authService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "<init>", "(Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/business/WikiService;)V", "addArgumentResolvers", "", "argumentResolvers", "", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "wiki-service"})
public class WikiWebConfiguration
implements WebMvcConfigurer {
    @NotNull
    private final AuthorizationService authService;
    @NotNull
    private final WikiService wikiService;

    public WikiWebConfiguration(@NotNull AuthorizationService authService, @NotNull WikiService wikiService) {
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        this.authService = authService;
        this.wikiService = wikiService;
    }

    public void addArgumentResolvers(@NotNull List<HandlerMethodArgumentResolver> argumentResolvers) {
        Intrinsics.checkNotNullParameter(argumentResolvers, (String)"argumentResolvers");
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthContextResolver(this.authService, this.wikiService));
    }
}

