/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.event;

import de.justsoftware.news.domain.event.Event;
import de.justsoftware.news.id.EventId;
import de.justsoftware.news.id.PostId;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010JJ\u0010 \u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00020\u00062\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\bH\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006'"}, d2={"Lde/justsoftware/news/domain/event/EventUpdate;", "", "startDate", "Ljava/time/Instant;", "endDate", "attendanceEnabled", "", "maxAttendees", "", "removeMaxAttendees", "<init>", "(Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Boolean;)V", "getStartDate", "()Ljava/time/Instant;", "getEndDate", "getAttendanceEnabled", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getMaxAttendees", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getRemoveMaxAttendees", "upsert", "Lde/justsoftware/news/domain/event/Event;", "postId", "Lde/justsoftware/news/id/PostId;", "origin", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Boolean;)Lde/justsoftware/news/domain/event/EventUpdate;", "equals", "other", "hashCode", "toString", "", "news-service"})
public final class EventUpdate {
    @Nullable
    private final Instant startDate;
    @Nullable
    private final Instant endDate;
    @Nullable
    private final Boolean attendanceEnabled;
    @Nullable
    private final Integer maxAttendees;
    @Nullable
    private final Boolean removeMaxAttendees;

    public EventUpdate(@Nullable Instant startDate, @Nullable Instant endDate, @Nullable Boolean attendanceEnabled, @Nullable Integer maxAttendees, @Nullable Boolean removeMaxAttendees) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.attendanceEnabled = attendanceEnabled;
        this.maxAttendees = maxAttendees;
        this.removeMaxAttendees = removeMaxAttendees;
    }

    @Nullable
    public final Instant getStartDate() {
        return this.startDate;
    }

    @Nullable
    public final Instant getEndDate() {
        return this.endDate;
    }

    @Nullable
    public final Boolean getAttendanceEnabled() {
        return this.attendanceEnabled;
    }

    @Nullable
    public final Integer getMaxAttendees() {
        return this.maxAttendees;
    }

    @Nullable
    public final Boolean getRemoveMaxAttendees() {
        return this.removeMaxAttendees;
    }

    @NotNull
    public final Event upsert(@NotNull PostId postId, @Nullable Event origin) {
        Integer n;
        Instant instant;
        Instant instant2;
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        if (origin == null) {
            Instant instant3 = this.startDate;
            if (instant3 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            Instant instant4 = this.endDate;
            if (instant4 == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            Boolean bl = this.attendanceEnabled;
            return new Event(EventId.Companion.random(), postId, instant3, instant4, bl != null ? bl : false, this.maxAttendees);
        }
        if (this.maxAttendees != null) {
            Integer n2 = origin.getMaxAttendees();
            if (!(this.maxAttendees >= (n2 != null ? n2 : 0))) {
                boolean bl = false;
                String string = "The number of attendees can't be reduced";
                throw new IllegalArgumentException(string.toString());
            }
        }
        if ((instant2 = this.startDate) == null) {
            instant2 = origin.getStartDate();
        }
        if ((instant = this.endDate) == null) {
            instant = origin.getEndDate();
        }
        Boolean bl = this.attendanceEnabled;
        boolean bl2 = bl != null ? bl.booleanValue() : origin.getAttendanceEnabled();
        if (Intrinsics.areEqual((Object)this.removeMaxAttendees, (Object)true) || Intrinsics.areEqual((Object)this.attendanceEnabled, (Object)false)) {
            n = null;
        } else {
            n = this.maxAttendees;
            if (n == null) {
                n = origin.getMaxAttendees();
            }
        }
        return Event.copy$default((Event)origin, null, null, (Instant)instant2, (Instant)instant, (boolean)bl2, n, (int)3, null);
    }

    @Nullable
    public final Instant component1() {
        return this.startDate;
    }

    @Nullable
    public final Instant component2() {
        return this.endDate;
    }

    @Nullable
    public final Boolean component3() {
        return this.attendanceEnabled;
    }

    @Nullable
    public final Integer component4() {
        return this.maxAttendees;
    }

    @Nullable
    public final Boolean component5() {
        return this.removeMaxAttendees;
    }

    @NotNull
    public final EventUpdate copy(@Nullable Instant startDate, @Nullable Instant endDate, @Nullable Boolean attendanceEnabled, @Nullable Integer maxAttendees, @Nullable Boolean removeMaxAttendees) {
        return new EventUpdate(startDate, endDate, attendanceEnabled, maxAttendees, removeMaxAttendees);
    }

    public static /* synthetic */ EventUpdate copy$default(EventUpdate eventUpdate, Instant instant, Instant instant2, Boolean bl, Integer n, Boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            instant = eventUpdate.startDate;
        }
        if ((n2 & 2) != 0) {
            instant2 = eventUpdate.endDate;
        }
        if ((n2 & 4) != 0) {
            bl = eventUpdate.attendanceEnabled;
        }
        if ((n2 & 8) != 0) {
            n = eventUpdate.maxAttendees;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = eventUpdate.removeMaxAttendees;
        }
        return eventUpdate.copy(instant, instant2, bl, n, bl2);
    }

    @NotNull
    public String toString() {
        return "EventUpdate(startDate=" + this.startDate + ", endDate=" + this.endDate + ", attendanceEnabled=" + this.attendanceEnabled + ", maxAttendees=" + this.maxAttendees + ", removeMaxAttendees=" + this.removeMaxAttendees + ")";
    }

    public int hashCode() {
        int result = this.startDate == null ? 0 : this.startDate.hashCode();
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.attendanceEnabled == null ? 0 : ((Object)this.attendanceEnabled).hashCode());
        result = result * 31 + (this.maxAttendees == null ? 0 : ((Object)this.maxAttendees).hashCode());
        result = result * 31 + (this.removeMaxAttendees == null ? 0 : ((Object)this.removeMaxAttendees).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EventUpdate)) {
            return false;
        }
        EventUpdate eventUpdate = (EventUpdate)other;
        if (!Intrinsics.areEqual((Object)this.startDate, (Object)eventUpdate.startDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.endDate, (Object)eventUpdate.endDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.attendanceEnabled, (Object)eventUpdate.attendanceEnabled)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.maxAttendees, (Object)eventUpdate.maxAttendees)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.removeMaxAttendees, (Object)eventUpdate.removeMaxAttendees);
    }
}

