/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.domain.event;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import de.justsoftware.news.auth.AuthorizationContext;
import de.justsoftware.news.domain.csv.CsvExport;
import de.justsoftware.news.domain.csv.CsvExportContext;
import de.justsoftware.news.domain.csv.CsvExportEntry;
import de.justsoftware.news.domain.csv.CsvExportLanguage;
import de.justsoftware.news.domain.event.Event;
import de.justsoftware.news.domain.event.EventAttendance;
import de.justsoftware.news.domain.event.EventAttendanceRepo;
import de.justsoftware.news.domain.event.EventRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.post.model.PostAction;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.id.EventId;
import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0012J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0012J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/news/domain/event/EventCsvExportService;", "", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "eventRepo", "Lde/justsoftware/news/domain/event/EventRepo;", "eventAttendanceRepo", "Lde/justsoftware/news/domain/event/EventAttendanceRepo;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "<init>", "(Lde/justsoftware/news/domain/user/ProfileRepo;Lde/justsoftware/news/domain/event/EventRepo;Lde/justsoftware/news/domain/event/EventAttendanceRepo;Lde/justsoftware/news/domain/post/PostRepo;)V", "export", "Lde/justsoftware/news/domain/csv/CsvExport;", "eventId", "Lde/justsoftware/news/id/EventId;", "language", "Lde/justsoftware/news/domain/csv/CsvExportLanguage;", "authContext", "Lde/justsoftware/news/auth/AuthorizationContext;", "buildHeadersRow", "", "", "fetchAndBuildCsvExportEntries", "Lde/justsoftware/news/domain/csv/CsvExportEntry;", "eventAttendance", "", "Lde/justsoftware/news/domain/event/EventAttendance;", "buildRow", "rowData", "news-service"})
@SourceDebugExtension(value={"SMAP\nEventCsvExportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventCsvExportService.kt\nde/justsoftware/news/domain/event/EventCsvExportService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1#2:112\n1563#3:113\n1634#3,3:114\n1563#3:117\n1634#3,3:118\n1056#3:121\n1573#3:122\n1604#3,4:123\n1563#3:127\n1634#3,3:128\n*S KotlinDebug\n*F\n+ 1 EventCsvExportService.kt\nde/justsoftware/news/domain/event/EventCsvExportService\n*L\n53#1:113\n53#1:114,3\n76#1:117\n76#1:118,3\n79#1:121\n80#1:122\n80#1:123,4\n92#1:127\n92#1:128,3\n*E\n"})
public class EventCsvExportService {
    @NotNull
    private final ProfileRepo profileRepo;
    @NotNull
    private final EventRepo eventRepo;
    @NotNull
    private final EventAttendanceRepo eventAttendanceRepo;
    @NotNull
    private final PostRepo postRepo;

    public EventCsvExportService(@NotNull ProfileRepo profileRepo, @NotNull EventRepo eventRepo, @NotNull EventAttendanceRepo eventAttendanceRepo, @NotNull PostRepo postRepo) {
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        Intrinsics.checkNotNullParameter((Object)eventRepo, (String)"eventRepo");
        Intrinsics.checkNotNullParameter((Object)eventAttendanceRepo, (String)"eventAttendanceRepo");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        this.profileRepo = profileRepo;
        this.eventRepo = eventRepo;
        this.eventAttendanceRepo = eventAttendanceRepo;
        this.postRepo = postRepo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public CsvExport export(@NotNull EventId eventId, @NotNull CsvExportLanguage language, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Event event = this.eventRepo.getById(eventId);
        Post post = this.postRepo.getByIdAndDeletedFalse(event.getPostId());
        authContext.checkPostAction(post, PostAction.POLL_EXPORT);
        Set attendees = this.eventAttendanceRepo.getByEventId(eventId);
        Closeable closeable = new StringWriter();
        Throwable throwable = null;
        try {
            CsvExport csvExport;
            StringWriter stringWriter = (StringWriter)closeable;
            boolean bl = false;
            stringWriter.write("\ufeff");
            Closeable closeable2 = (Closeable)new CsvMapper().writer((FormatSchema)CsvSchema.emptySchema().withColumnSeparator(';')).writeValues((Writer)stringWriter);
            Throwable throwable2 = null;
            try {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                SequenceWriter sequenceWriter = (SequenceWriter)closeable2;
                boolean bl2 = false;
                List it = this.buildHeadersRow(language);
                boolean $i$a$-let-EventCsvExportService$export$1$1$22 = false;
                sequenceWriter.write((Object)it);
                Iterable iterable = this.fetchAndBuildCsvExportEntries(attendees);
                boolean $i$f$map = false;
                void $i$a$-let-EventCsvExportService$export$1$1$22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    CsvExportEntry csvExportEntry = (CsvExportEntry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.buildRow((CsvExportEntry)it2, language));
                }
                it = (List)destination$iv$iv;
                boolean bl4 = false;
                sequenceWriter.write((Object)it);
                String string = post.getTitle();
                String string2 = stringWriter.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                csvExport = new CsvExport(string, ((Object)StringsKt.trim((CharSequence)string2)).toString());
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            CsvExport csvExport2 = csvExport;
            return csvExport2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private List<String> buildHeadersRow(CsvExportLanguage language) {
        List list;
        if (language == CsvExportLanguage.DE) {
            Object[] objectArray = new String[]{"Teilnehmer-Nr.", "Datum der Antwort", "Profile-ID", "Titel", "Vorname", "Nachname", "Nachtitel", "Teilnahme"};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            Object[] objectArray = new String[]{"No.", "Date of response", "Profile ID", "Title", "First name", "Last name", "Additional title", "Attending"};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private List<CsvExportEntry> fetchAndBuildCsvExportEntries(Set<EventAttendance> eventAttendance) {
        void $this$mapIndexedTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = eventAttendance;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EventAttendance eventAttendance2 = (EventAttendance)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getProfileId());
        }
        Iterable it = (List)destination$iv$iv;
        boolean bl = false;
        Iterable iterable2 = this.profileRepo.findAllById(it);
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"let(...)");
        Iterable profiles = iterable2;
        Iterable $this$sortedBy$iv = eventAttendance;
        boolean $i$f$sortedBy = false;
        Iterable $this$mapIndexed$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
        boolean $i$f$mapIndexed = false;
        it = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Object v1;
            void var17_25;
            Instant instant;
            void vote;
            block4: {
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EventAttendance bl2 = (EventAttendance)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                Iterable iterable3 = profiles;
                instant = vote.getUpdatedAt();
                var17_25 = index + true;
                Iterable iterable4 = iterable3;
                for (Object t : iterable4) {
                    Profile it2 = (Profile)t;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)vote.getProfileId())) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            Object var23_31 = v1;
            List list = CollectionsKt.listOf((Object)new Pair((Object)vote.getProfileId(), (Object)vote.getAttending()));
            Profile profile = var23_31;
            Instant instant2 = instant;
            void var28_35 = var17_25;
            collection.add(new CsvExportEntry((int)var28_35, instant2, profile, list));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> buildRow(CsvExportEntry rowData, CsvExportLanguage language) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = rowData.getVotes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Boolean)it.getSecond() != false ? CsvExportContext.INSTANCE.getYesTranslation(language) : CsvExportContext.INSTANCE.getNoTranslation(language));
        }
        List translatedVotes = (List)destination$iv$iv;
        String index = String.valueOf(rowData.getIndex());
        String voteDate = CsvExportContext.INSTANCE.getDateTimeFormatter().format(rowData.getVoteDate());
        Profile profile = rowData.getProfile();
        Intrinsics.checkNotNull((Object)profile);
        Profile profile2 = profile;
        Object[] objectArray = new String[7];
        objectArray[0] = index;
        objectArray[1] = voteDate;
        objectArray[2] = profile2.getId().toTypedString();
        String string = profile2.getPrefix();
        if (string == null) {
            string = "";
        }
        objectArray[3] = string;
        objectArray[4] = profile2.getFirstName();
        objectArray[5] = profile2.getLastName();
        String string2 = profile2.getSuffix();
        if (string2 == null) {
            string2 = "";
        }
        objectArray[6] = string2;
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)translatedVotes);
    }
}

