/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.notification;

import de.justsoftware.news.connector.notification.MailInfo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.id.PostId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.notificationclient.NotificationProducer;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationclient.model.NotificationBuilder;
import de.justsoftware.notificationclient.model.NotificationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0013\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J@\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J6\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J6\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J6\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J6\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016JV\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00110#2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u001aH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/news/connector/notification/NewsNotificationProducer;", "", "notificationProducer", "Lde/justsoftware/notificationclient/NotificationProducer;", "<init>", "(Lde/justsoftware/notificationclient/NotificationProducer;)V", "archiveAll", "", "postId", "Lde/justsoftware/news/id/PostId;", "profileId", "Lde/justsoftware/news/id/ProfileId;", "deleteAll", "sendForPublishedPost", "tenantId", "Lde/justsoftware/news/id/TenantId;", "channelTitle", "", "post", "Lde/justsoftware/news/domain/post/Post;", "author", "Lde/justsoftware/news/domain/user/Profile;", "receiverIds", "", "Lde/justsoftware/news/id/UserId;", "additionalMailInfo", "Lde/justsoftware/news/connector/notification/MailInfo;", "sendForMentionedInComment", "sendForMentionedInPost", "sendForNewCommentResponse", "sendForNewComment", "sendNotifications", "notificationType", "Lde/justsoftware/notificationclient/model/NotificationType;", "localText", "", "Ljava/util/Locale;", "mailInfo", "news-service"})
@SourceDebugExtension(value={"SMAP\nNotificationConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationConnector.kt\nde/justsoftware/news/connector/notification/NewsNotificationProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,408:1\n1563#2:409\n1634#2,3:410\n1#3:413\n*S KotlinDebug\n*F\n+ 1 NotificationConnector.kt\nde/justsoftware/news/connector/notification/NewsNotificationProducer\n*L\n374#1:409\n374#1:410,3\n*E\n"})
class NewsNotificationProducer {
    @NotNull
    private final NotificationProducer notificationProducer;

    public NewsNotificationProducer(@NotNull NotificationProducer notificationProducer) {
        Intrinsics.checkNotNullParameter((Object)notificationProducer, (String)"notificationProducer");
        this.notificationProducer = notificationProducer;
    }

    public void archiveAll(@NotNull PostId postId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.notificationProducer.archiveAllNotificationsFor(postId.toTypedString(), SetsKt.setOf((Object)NotificationType.POSTING_ON_SUBSCRIPTION), profileId.toTypedString());
    }

    public void deleteAll(@NotNull PostId postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.notificationProducer.deleteAllNotificationsFor(postId.toTypedString());
    }

    public void sendForPublishedPost(@NotNull TenantId tenantId, @NotNull String channelTitle, @NotNull Post post, @NotNull Profile author, @NotNull Collection<? extends UserId> receiverIds, @Nullable MailInfo additionalMailInfo) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)channelTitle, (String)"channelTitle");
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat den Beitrag ver\u00f6ffentlicht.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " has published a post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        this.sendNotifications(tenantId, channelTitle, post, receiverIds, NotificationType.POSTING_ON_SUBSCRIPTION, localText, additionalMailInfo);
    }

    public void sendForMentionedInComment(@NotNull TenantId tenantId, @NotNull String channelTitle, @NotNull Post post, @NotNull Profile author, @NotNull Collection<? extends UserId> receiverIds) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)channelTitle, (String)"channelTitle");
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat dich in einem Kommentar erw\u00e4hnt.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " mentioned you in a comment."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        NewsNotificationProducer.sendNotifications$default((NewsNotificationProducer)this, (TenantId)tenantId, (String)channelTitle, (Post)post, receiverIds, (NotificationType)NotificationType.COMMENT_ON_WORKSTREAM_WITH_MENTION, (Map)localText, null, (int)64, null);
    }

    public void sendForMentionedInPost(@NotNull TenantId tenantId, @NotNull String channelTitle, @NotNull Post post, @NotNull Profile author, @NotNull Collection<? extends UserId> receiverIds) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)channelTitle, (String)"channelTitle");
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat dich in einem Beitrag erw\u00e4hnt.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " mentioned you in a post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        NewsNotificationProducer.sendNotifications$default((NewsNotificationProducer)this, (TenantId)tenantId, (String)channelTitle, (Post)post, receiverIds, (NotificationType)NotificationType.POSTING_WITH_MENTION, (Map)localText, null, (int)64, null);
    }

    public void sendForNewCommentResponse(@NotNull TenantId tenantId, @NotNull String channelTitle, @NotNull Post post, @NotNull Profile author, @NotNull Collection<? extends UserId> receiverIds) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)channelTitle, (String)"channelTitle");
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat einen Kommentar des Beitrages beantwortet.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " answered a comment of this post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        NewsNotificationProducer.sendNotifications$default((NewsNotificationProducer)this, (TenantId)tenantId, (String)channelTitle, (Post)post, receiverIds, (NotificationType)NotificationType.COMMENT_ON_ENTITY_SUBSCRIPTION, (Map)localText, null, (int)64, null);
    }

    public void sendForNewComment(@NotNull TenantId tenantId, @NotNull String channelTitle, @NotNull Post post, @NotNull Profile author, @NotNull Collection<? extends UserId> receiverIds) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)channelTitle, (String)"channelTitle");
        Intrinsics.checkNotNullParameter((Object)post, (String)"post");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(receiverIds, (String)"receiverIds");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat den Beitrag kommentiert.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " commented on this post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        NewsNotificationProducer.sendNotifications$default((NewsNotificationProducer)this, (TenantId)tenantId, (String)channelTitle, (Post)post, receiverIds, (NotificationType)NotificationType.COMMENT_ON_ENTITY_SUBSCRIPTION, (Map)localText, null, (int)64, null);
    }

    /*
     * WARNING - void declaration
     */
    private void sendNotifications(TenantId tenantId, String channelTitle, Post post, Collection<? extends UserId> receiverIds, NotificationType notificationType, Map<Locale, String> localText, MailInfo mailInfo) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (receiverIds.isEmpty()) {
            return;
        }
        String appId = "news";
        Iterable iterable = receiverIds;
        NotificationBuilder notificationBuilder = Notification.builder((UUID)tenantId.getValue(), (String)appId, (String)post.getTitle(), (String)((String)MapsKt.getValue(localText, (Object)Locale.GERMAN)), (NotificationType)notificationType).withLocalizedText(localText);
        boolean $i$f$map = false;
        void var11_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserId userId = (UserId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toTypedString());
        }
        MailInfo mailInfo2 = mailInfo;
        MailInfo mailInfo3 = mailInfo;
        iterable = notificationBuilder.withReceivers(CollectionsKt.toSet((Iterable)((List)destination$iv$iv))).withPayload(appId).withTargetId(post.getId().toTypedString()).withDefaultMailContainerName(channelTitle).withMailAuthorName(mailInfo2 != null ? mailInfo2.getAuthorName() : null).withDefaultMailReplacementText(mailInfo3 != null ? mailInfo3.getPreviewText() : null).build();
        NotificationProducer notificationProducer = this.notificationProducer;
        Iterable p0 = iterable;
        boolean bl = false;
        notificationProducer.dispatchNotification((Notification)p0);
    }

    static /* synthetic */ void sendNotifications$default(NewsNotificationProducer newsNotificationProducer, TenantId tenantId, String string, Post post, Collection collection, NotificationType notificationType, Map map, MailInfo mailInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendNotifications");
        }
        if ((n & 0x40) != 0) {
            mailInfo = null;
        }
        newsNotificationProducer.sendNotifications(tenantId, string, post, collection, notificationType, map, mailInfo);
    }
}

