/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.auth;

import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.settings.SettingsRepo;
import de.justsoftware.news.id.ChannelId;
import de.justsoftware.news.id.TenantId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/news/auth/AuthSettingsService;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "settingsRepo", "Lde/justsoftware/news/domain/settings/SettingsRepo;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/settings/SettingsRepo;)V", "allMayReadSubscribers", "", "tenantId", "Lde/justsoftware/news/id/TenantId;", "filterOnlyManagersMayPin", "", "Lde/justsoftware/news/id/ChannelId;", "channelIds", "", "news-service"})
@SourceDebugExtension(value={"SMAP\nAuthSettingsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthSettingsService.kt\nde/justsoftware/news/auth/AuthSettingsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n774#2:32\n865#2,2:33\n1563#2:35\n1634#2,3:36\n*S KotlinDebug\n*F\n+ 1 AuthSettingsService.kt\nde/justsoftware/news/auth/AuthSettingsService\n*L\n27#1:32\n27#1:33,2\n28#1:35\n28#1:36,3\n*E\n"})
public class AuthSettingsService {
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final SettingsRepo settingsRepo;

    public AuthSettingsService(@NotNull ChannelRepo channelRepo, @NotNull SettingsRepo settingsRepo) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)settingsRepo, (String)"settingsRepo");
        this.channelRepo = channelRepo;
        this.settingsRepo = settingsRepo;
    }

    public boolean allMayReadSubscribers(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.settingsRepo.getByTenantId(tenantId).getAllMayReadSubscriptionProfiles();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChannelId> filterOnlyManagersMayPin(@NotNull Collection<ChannelId> channelIds) {
        void $this$mapTo$iv$iv;
        Channel it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        Iterable $this$filter$iv = this.channelRepo.getByIdInAndDeletedFalse(channelIds);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Channel)element$iv$iv;
            boolean bl = false;
            if (!it.getOnlyManagersMayPin()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Channel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

