/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.desktop.controller;

import de.justsoftware.mobile.gateway.desktop.model.ResolvedDesktopHash;
import de.justsoftware.mobile.gateway.desktop.service.DesktopHashResolverService;
import java.net.URLDecoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/desktop"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/justsoftware/mobile/gateway/desktop/controller/DesktopController;", "", "desktopHashResolverService", "Lde/justsoftware/mobile/gateway/desktop/service/DesktopHashResolverService;", "<init>", "(Lde/justsoftware/mobile/gateway/desktop/service/DesktopHashResolverService;)V", "getResolvedDesktopHash", "Lde/justsoftware/mobile/gateway/desktop/model/ResolvedDesktopHash;", "token", "", "mobile-gateway"})
public class DesktopController {
    @NotNull
    private final DesktopHashResolverService desktopHashResolverService;

    public DesktopController(@NotNull DesktopHashResolverService desktopHashResolverService) {
        Intrinsics.checkNotNullParameter((Object)desktopHashResolverService, (String)"desktopHashResolverService");
        this.desktopHashResolverService = desktopHashResolverService;
    }

    @GetMapping(value={"/token/resolve"})
    @NotNull
    public ResolvedDesktopHash getResolvedDesktopHash(@RequestParam(value="token") @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = URLDecoder.decode(token, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        return this.desktopHashResolverService.resolveDesktopHash(string);
    }
}

