/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.common.configuration;

import de.justsoftware.mobile.gateway.auth.model.local.TotpCodeVerificationError;
import de.justsoftware.mobile.gateway.common.configuration.MobileGatewayExceptionHandler;
import de.justsoftware.mobile.gateway.exception.BadRequestException;
import de.justsoftware.mobile.gateway.exception.CommentTooLongException;
import de.justsoftware.mobile.gateway.exception.CommentWrongMimeTypeException;
import de.justsoftware.mobile.gateway.exception.ForbiddenException;
import de.justsoftware.mobile.gateway.exception.InvalidClientVersionException;
import de.justsoftware.mobile.gateway.exception.NotFoundException;
import de.justsoftware.mobile.gateway.exception.PostAlreadyUpdatedException;
import de.justsoftware.mobile.gateway.exception.ThrowablesKt;
import de.justsoftware.mobile.gateway.exception.TotpCodeVerificationException;
import de.justsoftware.mobile.gateway.util.RestClientsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.client.RestClientResponseException;

/*
 * Exception performing whole class analysis ignored.
 */
@ControllerAdvice(value={"de.justsoftware.mobile.gateway"})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\nH\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\fH\u0017J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u000eH\u0017J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0010H\u0017J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0012H\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00052\u0006\u0010\u0007\u001a\u00020\u0015H\u0017J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0017H\u0017J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0019H\u0017J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0017\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/mobile/gateway/common/configuration/MobileGatewayExceptionHandler;", "", "<init>", "()V", "handleBadRequestException", "Lorg/springframework/http/ResponseEntity;", "", "e", "Lde/justsoftware/mobile/gateway/exception/BadRequestException;", "handleNotFoundException", "Lde/justsoftware/mobile/gateway/exception/NotFoundException;", "handleForbiddenException", "Lde/justsoftware/mobile/gateway/exception/ForbiddenException;", "handlePostAlreadyUpdatedException", "Lde/justsoftware/mobile/gateway/exception/PostAlreadyUpdatedException;", "handleCommentWrongMimeTypeException", "Lde/justsoftware/mobile/gateway/exception/CommentWrongMimeTypeException;", "handleCommentTooLongException", "Lde/justsoftware/mobile/gateway/exception/CommentTooLongException;", "handleTotpCodeVerificationException", "Lde/justsoftware/mobile/gateway/auth/model/local/TotpCodeVerificationError;", "Lde/justsoftware/mobile/gateway/exception/TotpCodeVerificationException;", "handleRestClientResponseException", "Lorg/springframework/web/client/RestClientResponseException;", "handleInvalidClientVersionException", "Lde/justsoftware/mobile/gateway/exception/InvalidClientVersionException;", "handleThrowable", "t", "", "Companion", "mobile-gateway"})
public class MobileGatewayExceptionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @ExceptionHandler(value={BadRequestException.class})
    @NotNull
    public ResponseEntity<String> handleBadRequestException(@NotNull BadRequestException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)BadRequestException.Companion.getErrorTypeNameOrMessage(e), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={NotFoundException.class})
    @NotNull
    public ResponseEntity<String> handleNotFoundException(@NotNull NotFoundException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)ThrowablesKt.getErrorMessage((Throwable)((Throwable)e)), (HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={ForbiddenException.class})
    @NotNull
    public ResponseEntity<String> handleForbiddenException(@NotNull ForbiddenException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)ThrowablesKt.getErrorMessage((Throwable)((Throwable)e)), (HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @ExceptionHandler(value={PostAlreadyUpdatedException.class})
    @NotNull
    public ResponseEntity<String> handlePostAlreadyUpdatedException(@NotNull PostAlreadyUpdatedException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)ThrowablesKt.getErrorMessage((Throwable)((Throwable)e)), (HttpStatusCode)HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={CommentWrongMimeTypeException.class})
    @NotNull
    public ResponseEntity<String> handleCommentWrongMimeTypeException(@NotNull CommentWrongMimeTypeException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)ThrowablesKt.getErrorMessage((Throwable)((Throwable)e)), (HttpStatusCode)HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    @ExceptionHandler(value={CommentTooLongException.class})
    @NotNull
    public ResponseEntity<String> handleCommentTooLongException(@NotNull CommentTooLongException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)ThrowablesKt.getErrorMessage((Throwable)((Throwable)e)), (HttpStatusCode)HttpStatus.PAYLOAD_TOO_LARGE);
    }

    @ExceptionHandler(value={TotpCodeVerificationException.class})
    @NotNull
    public ResponseEntity<TotpCodeVerificationError> handleTotpCodeVerificationException(@NotNull TotpCodeVerificationException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)new TotpCodeVerificationError(e.getReason()), (HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={RestClientResponseException.class})
    @NotNull
    public ResponseEntity<String> handleRestClientResponseException(@NotNull RestClientResponseException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        HttpStatusCode httpStatusCode = e.getStatusCode();
        return httpStatusCode == HttpStatus.BAD_REQUEST ? new ResponseEntity((Object)RestClientsKt.errorTypeNameOrMessage((RestClientResponseException)e), (HttpStatusCode)HttpStatus.BAD_REQUEST) : (httpStatusCode == HttpStatus.FORBIDDEN || httpStatusCode == HttpStatus.NOT_FOUND ? new ResponseEntity((Object)ThrowablesKt.getErrorMessage((Throwable)((Throwable)e)), e.getStatusCode()) : new ResponseEntity((Object)Companion.access$getErrorBody((Companion)Companion, (Throwable)((Throwable)e)), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR));
    }

    @ExceptionHandler(value={InvalidClientVersionException.class})
    @NotNull
    public ResponseEntity<String> handleInvalidClientVersionException(@NotNull InvalidClientVersionException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new ResponseEntity((Object)ThrowablesKt.getErrorMessage((Throwable)((Throwable)e)), (HttpStatusCode)HttpStatus.PRECONDITION_FAILED);
    }

    @ExceptionHandler(value={Throwable.class})
    @NotNull
    public ResponseEntity<String> handleThrowable(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return new ResponseEntity((Object)Companion.access$getErrorBody((Companion)Companion, (Throwable)t), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

