/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.common.ZookeeperUtil;
import de.justsoftware.drive.business.document.DocumentVersionCountService;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.person.PersonService;
import de.justsoftware.drive.business.publiclinks.PublicLinkService;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.person.model.PersonBO;
import de.justsoftware.drive.common.publiclinks.model.PublicLinkBO;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.rest.document.DocumentFrontendService;
import de.justsoftware.drive.rest.exceptions.UnknownResourceException;
import de.justsoftware.drive.rest.exceptions.ZipException;
import de.justsoftware.drive.rest.models.PublicLink;
import de.justsoftware.drive.rest.models.PublicLinkCreate;
import de.justsoftware.drive.rest.models.PublicLinkUpdate;
import de.justsoftware.drive.rest.util.ContentDispositionUtil;
import de.justsoftware.drive.rest.util.PersonUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Clock;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@Schema(description="Public link sharing")
@ParametersAreNonnullByDefault
public class PublicLinkController {
    private static final String MAV_MESSAGE = "message";
    private static final String PUBLIC_LINKS_DISABLED_MSG = "Public links are disabled";
    private static final String FILE_NOT_FOUND_MSG = "Requested file was not found";
    private static final String NOT_PUBLISHED_MSG = "A published version of this file does not exist.";
    private static final String SYSTEM_DOMAIN_PREFIX_PATH = "/just/config/just/common/system/domainprefix";
    @VisibleForTesting
    NodeCache _systemDomainPrefixCache;
    private final SettingsService _settingsService;
    private final FileService _fileService;
    private final FolderService _folderService;
    private final PublicLinkService _publicLinkService;
    private final PersonService _personService;
    private final DocumentFrontendService _documentFrontendService;
    private final Clock _clock;
    private final DocumentVersionCountService _documentVersionCountService;
    private final ItemReadService _itemReadService;

    @Autowired
    public PublicLinkController(CuratorFramework zookeeperClient, SettingsService settingsService, FileService fileService, FolderService folderService, PublicLinkService publicLinkService, PersonService personService, DocumentFrontendService documentFrontendService, Clock clock, DocumentVersionCountService documentVersionCountService, ItemReadService itemReadService) {
        this._documentFrontendService = documentFrontendService;
        this._systemDomainPrefixCache = ZookeeperUtil.createNodeCache((CuratorFramework)zookeeperClient, (String)SYSTEM_DOMAIN_PREFIX_PATH);
        this._settingsService = settingsService;
        this._fileService = fileService;
        this._folderService = folderService;
        this._publicLinkService = publicLinkService;
        this._personService = personService;
        this._clock = clock;
        this._documentVersionCountService = documentVersionCountService;
        this._itemReadService = itemReadService;
    }

    @RequestMapping(value={"/api/documents/file/{fileId}/publicLink"}, method={RequestMethod.POST}, produces={"application/json"})
    @Nonnull
    public PublicLink createPublicLink(AuthorizationContext authCtx, @PathVariable DocumentId fileId, @Nullable @RequestBody PublicLinkCreate createModel) {
        this.checkIfPublicLinksAreEnabled(authCtx.getNonnullTenantId());
        this._documentFrontendService.checkRead(authCtx, (AbstractId)fileId);
        Instant expires = createModel != null && createModel.expirationDate() != null ? createModel.expirationDate() : ZonedDateTime.now(this._clock).plusMonths(1L).toInstant();
        String password = createModel != null ? createModel.password() : null;
        PublicLinkBO link = this._publicLinkService.createPublicLink(authCtx, fileId, expires, password);
        return this.convertSingleBONullSafe(link);
    }

    @Nonnull
    private String linkIdToURL(String linkId) {
        String urlPrefix = ZookeeperUtil.getStringFromNodeCache((String)SYSTEM_DOMAIN_PREFIX_PATH, (NodeCache)this._systemDomainPrefixCache).orElse("");
        return urlPrefix + "/drive/s/" + linkId;
    }

    @RequestMapping(value={"/api/documents/file/{fileId}/publicLink"}, method={RequestMethod.GET}, produces={"application/json"})
    @Nonnull
    public List<PublicLink> getAllLinks(AuthorizationContext authCtx, @PathVariable DocumentId fileId) {
        this.checkIfPublicLinksAreEnabled(authCtx.getNonnullTenantId());
        if (!authCtx.may((AbstractId)fileId, StaticAction.DOCUMENT_READ)) {
            return ImmutableList.of();
        }
        ImmutableList linkBOs = this._publicLinkService.getLinks(fileId);
        return this.convertBOsToAPIModels(linkBOs);
    }

    @Nonnull
    private ImmutableList<PublicLink> convertBOsToAPIModels(ImmutableList<PublicLinkBO> linkBOs) {
        ImmutableMap creators = this._personService.getPersonsByIds((Set)linkBOs.stream().map(PublicLinkBO::getCreator).collect(ImmutableSet.toImmutableSet()));
        return (ImmutableList)linkBOs.stream().filter(input -> creators.containsKey((Object)input.getCreator())).map(input -> new PublicLink(input.getId(), input.getDocumentId(), input.getExpirationDate(), PersonUtil.personFromBO((PersonBO)((PersonBO)creators.get((Object)input.getCreator()))), input.getCreationDate(), this.linkIdToURL(input.getId()), input.isPasswordProtected())).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private PublicLink convertSingleBONullSafe(PublicLinkBO link) {
        PublicLink publicLink = (PublicLink)this.convertBOsToAPIModels(ImmutableList.of((Object)link)).get(0);
        if (publicLink == null) {
            throw new RuntimeException("Could not convert link BO to API model.");
        }
        return publicLink;
    }

    @RequestMapping(value={"/api/documents/file/{fileID}/publicLink/{linkID}"}, method={RequestMethod.DELETE})
    public void deleteLink(AuthorizationContext authCtx, @PathVariable DocumentId fileID, @PathVariable String linkID) {
        this.checkIfPublicLinksAreEnabled(authCtx.getNonnullTenantId());
        authCtx.check((AbstractId)fileID, StaticAction.DOCUMENT_READ);
        this._publicLinkService.deleteLink(fileID, linkID);
    }

    @Operation(description="Updates the expiration date or password of the public link.")
    @RequestMapping(value={"/api/documents/file/{fileID}/publicLink/{linkID}"}, method={RequestMethod.PATCH}, produces={"application/json"})
    @Nonnull
    public PublicLink updateLink(AuthorizationContext authCtx, @PathVariable DocumentId fileID, @PathVariable String linkID, @RequestBody PublicLinkUpdate updateModel) {
        this.checkIfPublicLinksAreEnabled(authCtx.getNonnullTenantId());
        authCtx.check((AbstractId)fileID, StaticAction.DOCUMENT_READ);
        this._publicLinkService.updateLink(fileID, linkID, updateModel.expirationDate(), updateModel.password());
        PublicLinkBO link = this._publicLinkService.getLink(linkID);
        if (link == null) {
            throw new UnknownResourceException(FILE_NOT_FOUND_MSG);
        }
        return this.convertSingleBONullSafe(link);
    }

    @RequestMapping(value={"/s/{linkID}"}, method={RequestMethod.POST})
    @CheckForNull
    public ModelAndView getProtectedLink(HttpServletResponse response, @PathVariable String linkID, @RequestParam(name="password", required=true) String password) throws IOException {
        return this.getLink(response, linkID, password);
    }

    @RequestMapping(value={"/s/{linkID}"}, method={RequestMethod.GET})
    @CheckForNull
    public ModelAndView getLink(HttpServletResponse response, @PathVariable String linkID, @Nullable String password) {
        try {
            PublicLinkBO link = this._publicLinkService.getLink(linkID);
            if (link == null) {
                throw new UnknownResourceException(FILE_NOT_FOUND_MSG);
            }
            this.checkIfPublicLinksAreEnabled(link.getTenantId());
            String encodedPassword = link.getPassword();
            if (encodedPassword == null || !Strings.isNullOrEmpty((String)password) && this._publicLinkService.passwordMatches(password, encodedPassword)) {
                this.downloadDocument(response, link);
                return null;
            }
            ModelAndView mav = new ModelAndView("publiclink/passwordentry");
            if (!Strings.isNullOrEmpty((String)password)) {
                mav.addObject(MAV_MESSAGE, (Object)"Wrong password");
            }
            return mav;
        }
        catch (PermissionDeniedException | UnknownResourceException | IOException e) {
            ModelAndView mav = new ModelAndView("publiclink/notfound");
            mav.setStatus((HttpStatusCode)HttpStatus.NOT_FOUND);
            return mav;
        }
    }

    private void downloadDocument(HttpServletResponse response, PublicLinkBO link) throws IOException, ZipException {
        DocumentId documentId = link.getDocumentId();
        DocumentVersionId documentVersionId = (DocumentVersionId)this._folderService.getCurrentVersionsOfDocuments((Set)ImmutableSet.of((Object)documentId)).get((Object)documentId);
        if (documentVersionId == null) {
            throw new UnknownResourceException(FILE_NOT_FOUND_MSG);
        }
        FileVersionBO fileVersion = (FileVersionBO)this._fileService.getVersionsByIds((Set)ImmutableSet.of((Object)documentVersionId)).get((Object)documentVersionId);
        if (fileVersion != null) {
            this.assertItemNotDeleted(fileVersion.getItemId());
            this.downloadFile(response, fileVersion, link.getTenantId());
            return;
        }
        FolderVersionBO folderVersionBO = (FolderVersionBO)this._folderService.getFolderVersionsByIds((Set)ImmutableSet.of((Object)documentVersionId)).get((Object)documentVersionId);
        if (folderVersionBO == null) {
            throw new UnknownResourceException(FILE_NOT_FOUND_MSG);
        }
        this.assertItemNotDeleted(folderVersionBO.getItemId());
        this._documentFrontendService.downloadFolderAsZip(response, documentVersionId, folderVersionBO);
    }

    private void assertItemNotDeleted(ItemId itemId) throws UnknownResourceException {
        ItemBO parent = (ItemBO)this._itemReadService.getItems(Set.of(itemId)).get((Object)itemId);
        if (parent != null && parent.isDeleted()) {
            throw new UnknownResourceException(FILE_NOT_FOUND_MSG);
        }
    }

    private void downloadFile(HttpServletResponse response, FileVersionBO fileVersion, TenantId tenantId) {
        ByteSource fileSource = this._fileService.getFileByteSource(fileVersion, tenantId);
        try {
            response.setContentType(fileVersion.getMimeType());
            response.setContentLengthLong(fileVersion.getFileSize());
            ContentDispositionUtil.setContentDispositionAttachment((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1), (String)fileVersion.getName());
            fileSource.copyTo((OutputStream)response.getOutputStream());
            this._documentVersionCountService.increment((Set)ImmutableSet.of((Object)fileVersion.getId()));
        }
        catch (IOException e) {
            throw new UnknownResourceException(FILE_NOT_FOUND_MSG);
        }
    }

    private void checkIfPublicLinksAreEnabled(TenantId tenantId) {
        if (!this._settingsService.isPublicLinksEnabled(tenantId)) {
            throw new PermissionDeniedException(PUBLIC_LINKS_DISABLED_MSG);
        }
    }
}

