/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanStatus;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.file.FileVersionCreateModel;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@ParametersAreNonnullByDefault
@Mapper
public interface FileVersionMapper {
    public static final String FILE_VERSION_BO_MAP = "FileBoMap";
    public static final String FILE_VERSION_BO_COLS = "    d.document_id, d.version, d.name, d.change_id, d.first_published_change_id, d.owner, d.change_date,\n    f.id, f.storage_id, f.mime_type, f.file_size, f.deleted, f.video_teaser_id,\n    c.item_id, v.status\n";

    @Insert(value={"INSERT INTO file_version(id, storage_id, mime_type, file_size, deleted, video_teaser_id)\nVALUES (#{_id}, #{_storageId}, #{_mimeType}, #{_fileSize}, #{_deleted}, #{_videoTeaserId})\n"})
    public void insertFileVersion(FileVersionCreateModel var1);

    @Select(value={"<script>", "SELECT     d.document_id, d.version, d.name, d.change_id, d.first_published_change_id, d.owner, d.change_date,\n    f.id, f.storage_id, f.mime_type, f.file_size, f.deleted, f.video_teaser_id,\n    c.item_id, v.status\n", "FROM file_version f", "JOIN document_version d ON f.id = d.id", "JOIN change c ON c.folder_version_id = d.change_id", "LEFT JOIN virus_scan_status v on v.storage_id = f.storage_id", "WHERE f.id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=FileVersionBO.class)
    @ConstructorArgs(value={@Arg(column="id", id=true, javaType=DocumentVersionId.class), @Arg(column="document_id", javaType=DocumentId.class), @Arg(column="version", javaType=int.class), @Arg(column="name", javaType=String.class), @Arg(column="change_id", javaType=DocumentVersionId.class), @Arg(column="owner", javaType=PersonId.class), @Arg(column="change_date", javaType=Instant.class), @Arg(column="item_id", javaType=ItemId.class), @Arg(column="first_published_change_id", javaType=DocumentVersionId.class), @Arg(column="storage_id", javaType=StorageId.class), @Arg(column="mime_type", javaType=String.class), @Arg(column="file_size", javaType=long.class), @Arg(column="deleted", javaType=boolean.class), @Arg(column="video_teaser_id", javaType=VideoTeaserId.class), @Arg(column="status", javaType=VirusScanStatus.class)})
    @Results(id="FileBoMap")
    public void getVersionsByIds(ResultHandler<FileVersionBO> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Select(value={"<script>", "SELECT     d.document_id, d.version, d.name, d.change_id, d.first_published_change_id, d.owner, d.change_date,\n    f.id, f.storage_id, f.mime_type, f.file_size, f.deleted, f.video_teaser_id,\n    c.item_id, v.status\n", "FROM file_version f", "JOIN document_version d ON f.id = d.id", "JOIN change c ON c.folder_version_id = d.change_id", "LEFT JOIN virus_scan_status v on v.storage_id = f.storage_id", "WHERE d.change_id IN (<foreach collection='changeIds' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=FileVersionBO.class)
    @ResultMap(value={"FileBoMap"})
    public void getFileVersionsByChangeIds(ResultHandler<FileVersionBO> var1, @Param(value="changeIds") List<? extends DocumentVersionId> var2);

    @Select(value={"<script>", "SELECT     d.document_id, d.version, d.name, d.change_id, d.first_published_change_id, d.owner, d.change_date,\n    f.id, f.storage_id, f.mime_type, f.file_size, f.deleted, f.video_teaser_id,\n    c.item_id, v.status\n", "FROM file_version f", "JOIN document_version d ON f.id = d.id", "JOIN change c ON c.folder_version_id = d.change_id", "LEFT JOIN virus_scan_status v on v.storage_id = f.storage_id", "WHERE d.document_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "ORDER BY d.version ASC", "</script>"})
    @ResultType(value=FileVersionBO.class)
    @ResultMap(value={"FileBoMap"})
    public void getVersionsByDocumentIds(ResultHandler<FileVersionBO> var1, @Param(value="ids") List<? extends DocumentId> var2);

    @Select(value={"<script>", "SELECT     d.document_id, d.version, d.name, d.change_id, d.first_published_change_id, d.owner, d.change_date,\n    f.id, f.storage_id, f.mime_type, f.file_size, f.deleted, f.video_teaser_id,\n    c.item_id, v.status\n", "FROM file_version f", "JOIN document_version d ON f.id = d.id", "JOIN change c ON c.folder_version_id = d.change_id", "LEFT JOIN virus_scan_status v on v.storage_id = f.storage_id", "WHERE d.document_id = #{id}", "ORDER BY d.version DESC", "</script>"})
    @ResultType(value=FileVersionBO.class)
    @ResultMap(value={"FileBoMap"})
    @Nonnull
    public List<FileVersionBO> getLastVersionsByDocumentId(@Param(value="id") DocumentId var1, @Nullable RowBounds var2);

    @Delete(value={"<script>", "DELETE FROM file_version WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deleteByIds(@Param(value="ids") List<DocumentVersionId> var1);

    @Delete(value={"DELETE FROM file_version f", "WHERE f.id IN (", "   SELECT f2.id", "   FROM file_version f2", "       JOIN document_version dv ON dv.id = f2.id", "       JOIN change c ON c.folder_version_id = dv.change_id", "   WHERE c.item_id = #{itemId}", ")"})
    public void deleteAllForItem(ItemId var1);

    @Select(value={"<script>", "SELECT DISTINCT storage_id", "FROM file_version", "WHERE storage_id IN (<foreach collection='storageIds' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @ResultType(value=StorageId.class)
    public void isStorageIdReferenced(ResultHandler<StorageId> var1, @Param(value="storageIds") List<StorageId> var2);

    @Nonnull
    @Select(value={"SELECT     d.document_id, d.version, d.name, d.change_id, d.first_published_change_id, d.owner, d.change_date,\n    f.id, f.storage_id, f.mime_type, f.file_size, f.deleted, f.video_teaser_id,\n    c.item_id, v.status\n", "FROM file_version f", "   JOIN document_version d ON f.id = d.id", "   JOIN document_version dv ON f.id = dv.id", "   JOIN change c ON c.folder_version_id = dv.change_id", "   LEFT JOIN virus_scan_status v ON v.storage_id = f.storage_id", "WHERE c.item_id = #{id}"})
    @ResultType(value=FileVersionBO.class)
    @ResultMap(value={"FileBoMap"})
    public List<FileVersionBO> getAllVersionsForItem(@Param(value="id") ItemId var1);

    @Select(value={"SELECT setA.storage_id", "FROM (", "       SELECT storage_id", "       FROM file_version fv", "       JOIN document_version dv on dv.id = fv.id", "       JOIN change c on dv.change_id = c.folder_version_id", "       WHERE item_id = #{id}", ") setA", "LEFT JOIN (", "       SELECT storage_id", "       FROM file_version fv", "       JOIN document_version dv on dv.id = fv.id", "       JOIN change c on dv.change_id = c.folder_version_id", "       WHERE item_id != #{id}", "       AND storage_id IN (", "               SELECT storage_id", "               FROM file_version fv", "               JOIN document_version dv on dv.id = fv.id", "               JOIN change c on dv.change_id = c.folder_version_id", "               WHERE item_id = #{id}", "       )", ") setB ON (setB.storage_id = setA.storage_id)", "WHERE setB.storage_id IS NULL"})
    @ResultType(value=StorageId.class)
    @Nonnull
    public Set<StorageId> getExclusiveStorageIdsForItem(@Param(value="id") ItemId var1);

    @Update(value={"    UPDATE file_version\n    SET video_teaser_id = #{videoTeaserId}\n    WHERE id = #{videoItemId}\n"})
    public void setVideoTeaser(DocumentVersionId var1, VideoTeaserId var2);

    @Update(value={"    UPDATE file_version\n    SET video_teaser_id = null\n    WHERE id = #{videoItemId}\n"})
    public void deleteVideoTeaser(DocumentVersionId var1);
}

