/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.shares.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.shares.PermissionShareItemPublisher;
import de.justsoftware.drive.business.shares.ShareRoleAssignmentPublisher;
import de.justsoftware.drive.business.shares.SharesPublisher;
import de.justsoftware.drive.common.authorization.model.SharePrivilege;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import de.justsoftware.permission.client.model.Role;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@ParametersAreNonnullByDefault
@Service
public class SharesPublisherImpl
implements SharesPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SharesPublisherImpl.class);
    private final PermissionShareItemPublisher _permissionShareItemPublisher;
    private final ShareRoleAssignmentPublisher _sharePermissionPublisher;

    @Autowired
    public SharesPublisherImpl(PermissionShareItemPublisher permissionShareItemPublisher, ShareRoleAssignmentPublisher sharePermissionPublisher) {
        this._permissionShareItemPublisher = permissionShareItemPublisher;
        this._sharePermissionPublisher = sharePermissionPublisher;
    }

    public WaitForOffsets publishDeletedShare(ItemId shareId, ImmutableSet<Role> deletedMembers) {
        ImmutableMap.Builder deletedMembersForNotification = ImmutableMap.builder();
        deletedMembers.forEach(role -> deletedMembersForNotification.put(role, Optional.empty()));
        WaitForOffsets waiter = this._sharePermissionPublisher.publishSharePermission(shareId, (Map)deletedMembersForNotification.build());
        this._permissionShareItemPublisher.publishDeletedShare(shareId);
        return waiter;
    }

    public void publishNewShare(ItemId shareId, TenantId tenantId) {
        this._permissionShareItemPublisher.publishNewShare(shareId, tenantId);
    }

    public WaitForOffsets publishMemberPermissionChanges(ItemId shareId, Map<Role, Optional<SharePrivilege>> changedMembers) {
        return this._sharePermissionPublisher.publishSharePermission(shareId, changedMembers);
    }

    public void publishAllSharePermissions() {
        StopWatch watch = new StopWatch("Publish all share permissions to permission service");
        watch.start("Publish share items");
        this._permissionShareItemPublisher.publishAllShares();
        watch.stop();
        watch.start("Publish all share role assignments");
        this._sharePermissionPublisher.publishAllShareRoleAssignments();
        watch.stop();
        LOG.info(watch.prettyPrint());
    }
}

