/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.change.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.drive.business.change.ChangeService;
import de.justsoftware.drive.business.change.ChangeTrigger;
import de.justsoftware.drive.business.change.ChangeWithTree;
import de.justsoftware.drive.business.change.ChangeWithTriggers;
import de.justsoftware.drive.business.change.DeleteFileTrigger;
import de.justsoftware.drive.business.change.NewFileTrigger;
import de.justsoftware.drive.business.change.impl.ChangeServiceImpl;
import de.justsoftware.drive.business.document.DocumentVersionTree;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.change.ChangeDAO;
import de.justsoftware.drive.persistence.document.DocumentVersionDAO;
import de.justsoftware.drive.persistence.file.DocumentSupportDAO;
import de.justsoftware.drive.persistence.folder.SubFolderDAO;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class ChangeServiceImpl
implements ChangeService {
    private static final int CHANGES_PARTITION_SIZE = 100;
    private final ChangeDAO _changeDAO;
    private final SubFolderDAO _subFolderDAO;
    private final DocumentSupportDAO _documentSupportDAO;
    private final DocumentVersionDAO _documentVersionDAO;

    @Autowired
    public ChangeServiceImpl(ChangeDAO changeDAO, SubFolderDAO subFolderDAO, DocumentVersionDAO documentVersionDAO, DocumentSupportDAO documentSupportDAO) {
        this._changeDAO = changeDAO;
        this._subFolderDAO = subFolderDAO;
        this._documentVersionDAO = documentVersionDAO;
        this._documentSupportDAO = documentSupportDAO;
    }

    public ImmutableMap<ItemId, ChangeBO> getNewestChangePerItem(Set<? extends ItemId> items) {
        return this._changeDAO.getNewestChangePerItem(items);
    }

    public ImmutableMap<DocumentVersionId, ChangeBO> getChangesByIds(Set<DocumentVersionId> ids) {
        return this._changeDAO.getChangesByIds(ids);
    }

    @Nonnull
    private Iterator<ChangeWithDocuments> getAllChangesWithDocuments(ItemId itemId) {
        return this.convertChangesToChangeWithDocuments((List)this._changeDAO.getAllChangesForItem(itemId));
    }

    @Nonnull
    private Iterator<ChangeWithDocuments> convertChangesToChangeWithDocuments(List<ChangeBO> changes) {
        List changeChunks = Lists.partition(changes, (int)100);
        return Iterators.concat((Iterator)Iterators.transform(changeChunks.iterator(), (Function)new /* Unavailable Anonymous Inner Class!! */));
    }

    public Iterator<ChangeWithTree> getAllChangesWithDocumentTree(ItemId itemId) {
        return new AllChangesWithTreeIterator(this.getAllChangesWithDocuments(itemId));
    }

    @Nonnull
    public ImmutableList<ChangeWithTree> getAllChangesWithDocumentTree(List<ChangeBO> changes) {
        Iterator concat = this.convertChangesToChangeWithDocuments(changes);
        return ImmutableList.copyOf((Iterator)new AllChangesWithTreeIterator(concat));
    }

    @Nonnull
    private Iterator<ChangeWithDocuments> changeWithDocumentsIterator(List<ChangeBO> changeChunk) {
        ImmutableSet changeIds = FluentIterable.from(changeChunk).transform(ChangeBO::getId).toSet();
        ImmutableSet newDocumentIds = ImmutableSet.copyOf((Collection)this._documentVersionDAO.getNewDocumentsForChange((Set)changeIds).values());
        ImmutableSetMultimap childrenById = this._subFolderDAO.getSubFoldersByIds((Set)newDocumentIds);
        ImmutableSet allDocuments = ImmutableSet.builder().addAll((Iterable)childrenById.values()).addAll((Iterable)newDocumentIds).build();
        ImmutableMap documentsById = this._documentSupportDAO.getDocumentVersionsByIds((Set)allDocuments);
        return Iterators.transform(changeChunk.iterator(), (Function)ChangeWithDocuments.createFunction((ImmutableSetMultimap)childrenById, (ImmutableMap)documentsById));
    }

    @Nonnull
    private static Function<DocumentVersionId, DocumentVersionTree> createTreeFunction(Map<DocumentVersionId, DocumentVersionTree> oldTrees, Map<DocumentVersionId, DocumentVersionBO> documentsById, SetMultimap<DocumentVersionId, DocumentVersionId> childrenById) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    @VisibleForTesting
    static ImmutableSet<ChangeTrigger> getChangesBetweenTrees(@Nullable DocumentVersionTree oldTree, DocumentVersionTree newTree) {
        FluentIterable oldFiles = oldTree == null ? FluentIterable.of() : oldTree.getAllFiles();
        ImmutableListMultimap oldFilesByDocumentId = oldFiles.index(DocumentVersionBO.GET_DOCUMENT_ID);
        ImmutableMap oldFilesByVersionId = oldFiles.uniqueIndex(DocumentVersionBO::getId);
        ImmutableMap newFilesByVersionId = newTree.getAllFiles().uniqueIndex(DocumentVersionBO::getId);
        ImmutableListMultimap newFilesByDocumentId = newTree.getAllFiles().index(DocumentVersionBO.GET_DOCUMENT_ID);
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (DocumentId deleted : Sets.difference((Set)oldFilesByDocumentId.keySet(), (Set)newFilesByDocumentId.keySet())) {
            result.add((Object)new DeleteFileTrigger(deleted));
        }
        for (DocumentVersionId added : Sets.difference((Set)newFilesByVersionId.keySet(), (Set)oldFilesByVersionId.keySet())) {
            FileVersionBO newFileVersion = (FileVersionBO)newFilesByVersionId.get((Object)added);
            if (newFileVersion == null) continue;
            result.add((Object)new NewFileTrigger(newFileVersion));
        }
        return result.build();
    }

    public Iterator<ChangeWithTriggers> getAllChangesWithTriggers(ItemId itemId) {
        return new AllChangesWithTriggersIterator(this.getAllChangesWithDocumentTree(itemId));
    }

    public Iterable<Supplier<Iterator<ChangeWithTriggers>>> getAllChangesWithTriggers() {
        ImmutableSet allItemIds = this._changeDAO.getAllItemIds();
        return (Iterable)allItemIds.stream().map(itemId -> () -> this.getAllChangesWithTriggers(itemId)).collect(ImmutableList.toImmutableList());
    }

    public ImmutableMap<ItemId, PersonId> loadAuthorOfFirstChange(Set<ItemId> itemIds) {
        return this._changeDAO.loadAuthorOfFirstChange(itemIds);
    }
}

