/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2.passwordGrant;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustAuthenticationProvider;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.passwordGrant.OAuth2PasswordGrantAuthenticationConverter;
import de.justsoftware.authorization.oauth2.passwordGrant.OAuth2PasswordGrantAuthenticationProviderKt;
import de.justsoftware.authorization.oauth2.passwordGrant.OAuth2PasswordGrantAuthenticationToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.token.DefaultOAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/authorization/oauth2/passwordGrant/OAuth2PasswordGrantAuthenticationProvider;", "Lorg/springframework/security/authentication/AuthenticationProvider;", "justAuthenticationProvider", "Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;", "authorizationService", "Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;", "tokenGenerator", "Lorg/springframework/security/oauth2/server/authorization/token/OAuth2TokenGenerator;", "Lorg/springframework/security/oauth2/core/OAuth2Token;", "<init>", "(Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;Lorg/springframework/security/oauth2/server/authorization/token/OAuth2TokenGenerator;)V", "authenticate", "Lorg/springframework/security/core/Authentication;", "authentication", "supports", "", "Ljava/lang/Class;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nOAuth2PasswordGrantAuthenticationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2PasswordGrantAuthenticationProvider.kt\nde/justsoftware/authorization/oauth2/passwordGrant/OAuth2PasswordGrantAuthenticationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1557#2:125\n1628#2,3:126\n1557#2:129\n1628#2,3:130\n*S KotlinDebug\n*F\n+ 1 OAuth2PasswordGrantAuthenticationProvider.kt\nde/justsoftware/authorization/oauth2/passwordGrant/OAuth2PasswordGrantAuthenticationProvider\n*L\n66#1:125\n66#1:126,3\n93#1:129\n93#1:130,3\n*E\n"})
public final class OAuth2PasswordGrantAuthenticationProvider
implements AuthenticationProvider {
    @NotNull
    private final JustAuthenticationProvider justAuthenticationProvider;
    @NotNull
    private final OAuth2AuthorizationService authorizationService;
    @NotNull
    private final OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator;

    public OAuth2PasswordGrantAuthenticationProvider(@NotNull JustAuthenticationProvider justAuthenticationProvider, @NotNull OAuth2AuthorizationService authorizationService, @NotNull OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator) {
        Intrinsics.checkNotNullParameter((Object)justAuthenticationProvider, (String)"justAuthenticationProvider");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter(tokenGenerator, (String)"tokenGenerator");
        this.justAuthenticationProvider = justAuthenticationProvider;
        this.authorizationService = authorizationService;
        this.tokenGenerator = tokenGenerator;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Authentication authenticate(@NotNull Authentication authentication) throws AuthenticationException {
        void $this$mapTo$iv$iv;
        Collection<String> collection;
        Object item$iv$iv;
        Map $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        OAuth2PasswordGrantAuthenticationToken passwordToken = (OAuth2PasswordGrantAuthenticationToken)authentication;
        OAuth2ClientAuthenticationToken clientPrincipal = OAuth2PasswordGrantAuthenticationProviderKt.access$getAuthenticatedClientElseThrowInvalidClient((Authentication)((Authentication)passwordToken));
        RegisteredClient registeredClient = clientPrincipal.getRegisteredClient();
        if (registeredClient == null || !registeredClient.getAuthorizationGrantTypes().contains(passwordToken.getGrantType())) {
            throw new OAuth2AuthenticationException("unauthorized_client");
        }
        for (String requestedScope : passwordToken.getScopes()) {
            if (registeredClient.getScopes().contains(requestedScope)) continue;
            throw new OAuth2AuthenticationException("invalid_scope");
        }
        Set authorizedScopes = CollectionsKt.toMutableSet((Iterable)passwordToken.getScopes());
        JustUser justUser = this.justAuthenticationProvider.retrieveUser(passwordToken.getUsername(), passwordToken.getPassword());
        UsernamePasswordAuthenticationToken userPrincipal = new UsernamePasswordAuthenticationToken((Object)justUser, null, (Collection)justUser.getAuthorities());
        Iterable iterable = justUser.getAuthorities();
        String string = "roles";
        Object object = (DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)((DefaultOAuth2TokenContext.Builder)DefaultOAuth2TokenContext.builder().registeredClient(registeredClient)).principal((Authentication)userPrincipal)).authorizationServerContext(AuthorizationServerContextHolder.getContext())).authorizedScopes(authorizedScopes)).tokenType(OAuth2TokenType.ACCESS_TOKEN)).authorizationGrantType(OAuth2PasswordGrantAuthenticationConverter.Companion.getPASSWORD_GRANT_TYPE())).authorizationGrant((Authentication)passwordToken);
        boolean $i$f$map = false;
        void var12_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void obj;
            item$iv$iv = iterator.next();
            GrantedAuthority grantedAuthority = (GrantedAuthority)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.getAuthority());
        }
        collection = (List)destination$iv$iv;
        DefaultOAuth2TokenContext defaultOAuth2TokenContext = ((DefaultOAuth2TokenContext.Builder)object.put((Object)string, (Object)CollectionsKt.toSet((Iterable)collection))).build();
        Intrinsics.checkNotNullExpressionValue((Object)defaultOAuth2TokenContext, (String)"build(...)");
        OAuth2TokenContext tokenContext = (OAuth2TokenContext)defaultOAuth2TokenContext;
        OAuth2Token generatedAccessToken = this.tokenGenerator.generate(tokenContext);
        if (generatedAccessToken == null) {
            OAuth2Error error = new OAuth2Error("server_error", "The token generator failed to generate the access token.", "ACCESS_TOKEN_REQUEST_ERROR_URI");
            throw new OAuth2AuthenticationException(error);
        }
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, generatedAccessToken.getTokenValue(), generatedAccessToken.getIssuedAt(), generatedAccessToken.getExpiresAt(), tokenContext.getAuthorizedScopes());
        Map tokenMetadata = new HashMap();
        tokenMetadata.put(ProfileId.Companion.getJsonKey(), justUser.getProfileId().toTypedString());
        if (justUser.getTenantId() != null) {
            tokenMetadata.put(TenantId.Companion.getJsonKey(), justUser.getTenantId().toTypedString());
        }
        tokenMetadata.put("username", justUser.getUsername());
        if (!((Collection)authorizedScopes).isEmpty()) {
            tokenMetadata.put("scope", authorizedScopes);
        }
        $this$mapTo$iv$iv2 = tokenMetadata;
        String string2 = "roles";
        Iterable $this$map$iv2 = justUser.getAuthorities();
        boolean $i$f$map2 = false;
        item$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void obj;
            GrantedAuthority grantedAuthority = (GrantedAuthority)item$iv$iv2;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(obj.getAuthority());
        }
        Set set = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
        $this$mapTo$iv$iv2.put(string2, set);
        OAuth2Authorization authorization = OAuth2Authorization.withRegisteredClient((RegisteredClient)registeredClient).principalName(justUser.getUsername()).authorizationGrantType(OAuth2PasswordGrantAuthenticationConverter.Companion.getPASSWORD_GRANT_TYPE()).token((OAuth2Token)accessToken, arg_0 -> OAuth2PasswordGrantAuthenticationProvider.authenticate$lambda$2(tokenMetadata, arg_0)).build();
        this.authorizationService.save(authorization);
        return (Authentication)new OAuth2AccessTokenAuthenticationToken(registeredClient, (Authentication)clientPrincipal, accessToken);
    }

    public boolean supports(@NotNull Class<?> authentication) {
        Intrinsics.checkNotNullParameter(authentication, (String)"authentication");
        return OAuth2PasswordGrantAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private static final void authenticate$lambda$2(Map $tokenMetadata, Map it) {
        Intrinsics.checkNotNull((Object)it);
        it.put(OAuth2Authorization.Token.CLAIMS_METADATA_NAME, $tokenMetadata);
    }
}

