/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustToroUser;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.JustUserDetailService;
import de.justsoftware.authorization.oauth2.JustUserDetailService$loadUserCurrentlyAuthenticated$;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/authorization/oauth2/JustUserDetailService;", "Lorg/springframework/security/core/userdetails/UserDetailsService;", "toroInternalUrl", "", "internalRestClient", "Lorg/springframework/web/client/RestClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient;)V", "getToroInternalUrl", "()Ljava/lang/String;", "restClient", "getRestClient", "()Lorg/springframework/web/client/RestClient;", "userDetailsChecker", "Lorg/springframework/security/authentication/AccountStatusUserDetailsChecker;", "getUserDetailsChecker", "()Lorg/springframework/security/authentication/AccountStatusUserDetailsChecker;", "loadUserByUsername", "Lde/justsoftware/authorization/oauth2/JustUser;", "username", "loadUserCurrentlyAuthenticated", "mapToroUserToJustUser", "toroUser", "Lde/justsoftware/authorization/oauth2/JustToroUser;", "Companion", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nJustUserDetailService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JustUserDetailService.kt\nde/justsoftware/authorization/oauth2/JustUserDetailService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n*L\n1#1,89:1\n1#2:90\n43#3:91\n43#3:92\n*S KotlinDebug\n*F\n+ 1 JustUserDetailService.kt\nde/justsoftware/authorization/oauth2/JustUserDetailService\n*L\n44#1:91\n65#1:92\n*E\n"})
public class JustUserDetailService
implements UserDetailsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String toroInternalUrl;
    @NotNull
    private final RestClient internalRestClient;
    @NotNull
    private final RestClient restClient;
    @NotNull
    private final AccountStatusUserDetailsChecker userDetailsChecker;
    @NotNull
    private static final Logger LOG;

    public JustUserDetailService(@Value(value="${just.toro.internal}") @NotNull String toroInternalUrl, @Qualifier(value="internalRestClient") @NotNull RestClient internalRestClient) {
        Intrinsics.checkNotNullParameter((Object)toroInternalUrl, (String)"toroInternalUrl");
        Intrinsics.checkNotNullParameter((Object)internalRestClient, (String)"internalRestClient");
        this.toroInternalUrl = toroInternalUrl;
        this.internalRestClient = internalRestClient;
        RestClient restClient = RestClient.create();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"create(...)");
        this.restClient = restClient;
        this.userDetailsChecker = new AccountStatusUserDetailsChecker();
    }

    @NotNull
    public String getToroInternalUrl() {
        return this.toroInternalUrl;
    }

    @NotNull
    public RestClient getRestClient() {
        return this.restClient;
    }

    @NotNull
    public AccountStatusUserDetailsChecker getUserDetailsChecker() {
        return this.userDetailsChecker;
    }

    @NotNull
    public JustUser loadUserByUsername(@Nullable String username) throws UsernameNotFoundException {
        JustToroUser justToroUser;
        CharSequence charSequence = username;
        if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) {
            boolean bl = false;
            throw new UsernameNotFoundException("Username cannot be blank");
        }
        try {
            Object[] objectArray = new Object[]{username};
            RestClient.RequestHeadersSpec requestHeadersSpec = this.getRestClient().get().uri(this.getToroInternalUrl() + "/auth/user/{username}", objectArray);
            objectArray = new MediaType[]{MediaType.APPLICATION_JSON};
            RestClient.ResponseSpec responseSpec = requestHeadersSpec.accept((MediaType[])objectArray).retrieve().onStatus(JustUserDetailService::loadUserByUsername$lambda$1, (arg_0, arg_1) -> JustUserDetailService.loadUserByUsername$lambda$2(username, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"onStatus(...)");
            RestClient.ResponseSpec $this$body$iv = responseSpec;
            boolean $i$f$body = false;
            justToroUser = (JustToroUser)$this$body$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RestClientException ex) {
            LOG.error("Unexpected error when loading user " + username + " from toro");
            throw new InternalAuthenticationServiceException("Unexpected error when loading user " + username + " from toro", (Throwable)ex);
        }
        JustToroUser toroUser = justToroUser;
        if (toroUser == null) {
            LOG.error("No Just Social user found with username " + username);
            throw new UsernameNotFoundException("No Just Social user found with username " + username);
        }
        return this.mapToroUserToJustUser(toroUser);
    }

    @NotNull
    public JustUser loadUserCurrentlyAuthenticated() throws UsernameNotFoundException {
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.APPLICATION_JSON};
        RestClient.ResponseSpec responseSpec = this.internalRestClient.get().uri(this.getToroInternalUrl() + "/auth/user", new Object[0]).accept(mediaTypeArray).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec $this$body$iv = responseSpec;
        boolean $i$f$body = false;
        JustToroUser toroUser = (JustToroUser)$this$body$iv.body((ParameterizedTypeReference)new loadUserCurrentlyAuthenticated$$inlined$body$1());
        if (toroUser == null) {
            throw new UsernameNotFoundException("No Just Social user found");
        }
        return this.mapToroUserToJustUser(toroUser);
    }

    private JustUser mapToroUserToJustUser(JustToroUser toroUser) {
        this.getUserDetailsChecker().check((UserDetails)toroUser);
        String string = toroUser.getUsername();
        List list = toroUser.getAuthorities();
        ProfileId profileId = toroUser.getProfileId();
        TenantId tenantId = toroUser.getTenantId();
        boolean bl = toroUser.isAccountNonExpired();
        boolean bl2 = toroUser.isAccountNonLocked();
        boolean bl3 = toroUser.isCredentialsNonExpired();
        boolean bl4 = toroUser.isEnabled();
        return new JustUser(profileId, tenantId, string, null, list, bl, bl2, bl3, bl4);
    }

    private static final boolean loadUserByUsername$lambda$1(HttpStatusCode it) {
        return it.is4xxClientError();
    }

    private static final void loadUserByUsername$lambda$2(String $username, HttpRequest req, ClientHttpResponse resp) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)resp, (String)"resp");
        LOG.error(resp.getStatusCode() + " error when loading user " + $username + " from toro");
        throw new UsernameNotFoundException("error when loading user " + $username + " from toro");
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Logger logger = LoggerFactory.getLogger(JustUserDetailService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
    }
}

