/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.neural;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.DenseVectorField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SyntaxError;

public class KnnQParser
extends QParser {
    static final String PRE_FILTER = "preFilter";
    static final String EXCLUDE_TAGS = "excludeTags";
    static final String INCLUDE_TAGS = "includeTags";
    static final String TOP_K = "topK";
    static final int DEFAULT_TOP_K = 10;

    public KnnQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        String denseVectorField = this.localParams.get("f");
        String vectorToSearch = this.localParams.get("v");
        int topK = this.localParams.getInt(TOP_K, 10);
        if (denseVectorField == null || denseVectorField.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "the Dense Vector field 'f' is missing");
        }
        if (vectorToSearch == null || vectorToSearch.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "the Dense Vector value 'v' to search is missing");
        }
        SchemaField schemaField = this.req.getCore().getLatestSchema().getField(denseVectorField);
        FieldType fieldType = schemaField.getType();
        if (!(fieldType instanceof DenseVectorField)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "only DenseVectorField is compatible with Knn Query Parser");
        }
        DenseVectorField denseVectorType = (DenseVectorField)fieldType;
        return denseVectorType.getKnnVectorQuery(schemaField.getName(), vectorToSearch, topK, this.getFilterQuery());
    }

    private Query getFilterQuery() throws SolrException, SyntaxError {
        String[] preFilters;
        boolean haveGlobalFQTags;
        boolean isSubQuery = this.recurseCount != 0;
        List<String> includedGlobalFQTags = this.getLocalParamTags(INCLUDE_TAGS);
        List<String> excludedGlobalFQTags = this.getLocalParamTags(EXCLUDE_TAGS);
        boolean bl = haveGlobalFQTags = !includedGlobalFQTags.isEmpty() || !excludedGlobalFQTags.isEmpty();
        if (haveGlobalFQTags) {
            if (this.isFilter()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Knn Query Parser used as a filter does not support includeTags or excludeTags localparams");
            }
            if (isSubQuery) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Knn Query Parser used as a sub-query does not support includeTags or excludeTags localparams");
            }
        }
        if (null != (preFilters = this.getLocalParams().getParams(PRE_FILTER))) {
            assert (0 != preFilters.length) : "SolrParams.getParams should return null, never zero len array";
            if (haveGlobalFQTags) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Knn Query Parser does not support combining preFilter localparam with either includeTags or excludeTags localparams");
            }
            ArrayList<Query> preFilterQueries = new ArrayList<Query>(preFilters.length);
            for (String f : preFilters) {
                QParser parser = this.subQuery(f, null);
                parser.setIsFilter(true);
                Query filter = parser.getQuery();
                if (null == filter) continue;
                preFilterQueries.add(filter);
            }
            try {
                return this.req.getSearcher().getProcessedFilter(null, preFilterQueries).filter;
            }
            catch (IOException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        if (this.isFilter() || isSubQuery) {
            return null;
        }
        try {
            List<Query> globalFQs = QueryUtils.parseFilterQueries(this.req);
            if (!includedGlobalFQTags.isEmpty()) {
                globalFQs = new ArrayList<Query>(QueryUtils.getTaggedQueries(this.req, includedGlobalFQTags));
            }
            if (null != excludedGlobalFQTags) {
                globalFQs.removeAll(QueryUtils.getTaggedQueries(this.req, excludedGlobalFQTags));
            }
            return this.req.getSearcher().getProcessedFilter(null, globalFQs).filter;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private List<String> getLocalParamTags(String param) {
        String[] strVals = this.localParams.getParams(param);
        if (null == strVals) {
            return Collections.emptyList();
        }
        ArrayList<String> tags = new ArrayList<String>(strVals.length * 2);
        for (String val : strVals) {
            if (0 < val.indexOf(44)) {
                tags.addAll(StrUtils.splitSmart((String)val, (char)','));
                continue;
            }
            tags.add(val);
        }
        return tags;
    }
}

