/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.servlet.RateLimitManager;

public class RateLimiterConfig {
    public static final String RL_CONFIG_KEY = "rate-limiters";
    public SolrRequest.SolrRequestType requestType;
    public boolean isEnabled;
    public long waitForSlotAcquisition;
    public int allowedRequests;
    public boolean isSlotBorrowingEnabled;
    public int guaranteedSlotsThreshold;

    public RateLimiterConfig(SolrRequest.SolrRequestType requestType) {
        this.requestType = requestType;
        this.isEnabled = false;
        this.allowedRequests = RateLimitManager.DEFAULT_CONCURRENT_REQUESTS;
        this.isSlotBorrowingEnabled = false;
        this.guaranteedSlotsThreshold = this.allowedRequests / 2;
        this.waitForSlotAcquisition = -1L;
    }

    public RateLimiterConfig(SolrRequest.SolrRequestType requestType, boolean isEnabled, int guaranteedSlotsThreshold, long waitForSlotAcquisition, int allowedRequests, boolean isSlotBorrowingEnabled) {
        this.requestType = requestType;
        this.isEnabled = isEnabled;
        this.guaranteedSlotsThreshold = guaranteedSlotsThreshold;
        this.waitForSlotAcquisition = waitForSlotAcquisition;
        this.allowedRequests = allowedRequests;
        this.isSlotBorrowingEnabled = isSlotBorrowingEnabled;
    }
}

