/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.auth.Credentials;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.IdToken;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

class IamUtils {
    private static final String SIGN_BLOB_URL_FORMAT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:signBlob";
    private static final String ID_TOKEN_URL_FORMAT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateIdToken";
    private static final String PARSE_ERROR_MESSAGE = "Error parsing error message response. ";
    private static final String PARSE_ERROR_SIGNATURE = "Error parsing signature response. ";

    IamUtils() {
    }

    static byte[] sign(String serviceAccountEmail, Credentials credentials, HttpTransport transport, byte[] toSign, Map<String, ?> additionalFields) {
        String signature;
        BaseEncoding base64 = BaseEncoding.base64();
        try {
            signature = IamUtils.getSignature(serviceAccountEmail, credentials, transport, base64.encode(toSign), additionalFields);
        }
        catch (IOException ex) {
            throw new ServiceAccountSigner.SigningException("Failed to sign the provided bytes", (Exception)ex);
        }
        return base64.decode((CharSequence)signature);
    }

    private static String getSignature(String serviceAccountEmail, Credentials credentials, HttpTransport transport, String bytes, Map<String, ?> additionalFields) throws IOException {
        String signBlobUrl = String.format(SIGN_BLOB_URL_FORMAT, serviceAccountEmail);
        GenericUrl genericUrl = new GenericUrl(signBlobUrl);
        GenericData signRequest = new GenericData();
        signRequest.set("payload", (Object)bytes);
        for (Map.Entry<String, ?> entry : additionalFields.entrySet()) {
            signRequest.set(entry.getKey(), entry.getValue());
        }
        JsonHttpContent signContent = new JsonHttpContent(OAuth2Utils.JSON_FACTORY, (Object)signRequest);
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter(credentials);
        HttpRequest request = transport.createRequestFactory((HttpRequestInitializer)adapter).buildPostRequest(genericUrl, (HttpContent)signContent);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        request.setParser((ObjectParser)parser);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            GenericData responseError = (GenericData)response.parseAs(GenericData.class);
            Map<String, Object> error = OAuth2Utils.validateMap((Map<String, Object>)responseError, "error", PARSE_ERROR_MESSAGE);
            String errorMessage = OAuth2Utils.validateString(error, "message", PARSE_ERROR_MESSAGE);
            throw new IOException(String.format("Error code %s trying to sign provided bytes: %s", statusCode, errorMessage));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to sign provided bytes: %s", statusCode, response.parseAsString()));
        }
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from sign blob server request.");
        }
        GenericData responseData = (GenericData)response.parseAs(GenericData.class);
        return OAuth2Utils.validateString((Map<String, Object>)responseData, "signedBlob", PARSE_ERROR_SIGNATURE);
    }

    static IdToken getIdToken(String serviceAccountEmail, Credentials credentials, HttpTransport transport, String targetAudience, boolean includeEmail, Map<String, ?> additionalFields) throws IOException {
        String idTokenUrl = String.format(ID_TOKEN_URL_FORMAT, serviceAccountEmail);
        GenericUrl genericUrl = new GenericUrl(idTokenUrl);
        GenericData idTokenRequest = new GenericData();
        idTokenRequest.set("audience", (Object)targetAudience);
        idTokenRequest.set("includeEmail", (Object)includeEmail);
        for (Map.Entry<String, ?> entry : additionalFields.entrySet()) {
            idTokenRequest.set(entry.getKey(), entry.getValue());
        }
        JsonHttpContent idTokenContent = new JsonHttpContent(OAuth2Utils.JSON_FACTORY, (Object)idTokenRequest);
        HttpCredentialsAdapter adapter = new HttpCredentialsAdapter(credentials);
        HttpRequest request = transport.createRequestFactory((HttpRequestInitializer)adapter).buildPostRequest(genericUrl, (HttpContent)idTokenContent);
        JsonObjectParser parser = new JsonObjectParser(OAuth2Utils.JSON_FACTORY);
        request.setParser((ObjectParser)parser);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            GenericData responseError = (GenericData)response.parseAs(GenericData.class);
            Map<String, Object> error = OAuth2Utils.validateMap((Map<String, Object>)responseError, "error", PARSE_ERROR_MESSAGE);
            String errorMessage = OAuth2Utils.validateString(error, "message", PARSE_ERROR_MESSAGE);
            throw new IOException(String.format("Error code %s trying to getIDToken: %s", statusCode, errorMessage));
        }
        if (statusCode != 200) {
            throw new IOException(String.format("Unexpected Error code %s trying to getIDToken: %s", statusCode, response.parseAsString()));
        }
        InputStream content = response.getContent();
        if (content == null) {
            throw new IOException("Empty content from generateIDToken server request.");
        }
        GenericJson responseData = (GenericJson)response.parseAs(GenericJson.class);
        String rawToken = OAuth2Utils.validateString((Map<String, Object>)responseData, "token", PARSE_ERROR_MESSAGE);
        return IdToken.create(rawToken);
    }
}

