/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import de.justsoftware.people.application.ProfileApplicationService;
import de.justsoftware.people.application.SearchApplicationService;
import de.justsoftware.people.application.model.AbsenceDto;
import de.justsoftware.people.application.model.AbsenceNoteUpdateDto;
import de.justsoftware.people.application.model.AbsenceStatusUpdateDto;
import de.justsoftware.people.application.model.ProfileCsvInputStream;
import de.justsoftware.people.application.model.ProfileSearchModel;
import de.justsoftware.people.application.model.ProfileSearchResult;
import de.justsoftware.people.application.model.SearchFilterModel;
import de.justsoftware.people.authorization.AuthorizationContext;
import de.justsoftware.people.business.profile.model.BirthdayProfile;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.usergroup.model.UserGroup;
import de.justsoftware.people.controller.ProfileController;
import de.justsoftware.people.controller.model.PagedResultModel;
import de.justsoftware.people.controller.model.ProfileAttributeSearchConfigurationDto;
import de.justsoftware.people.model.PagedResult;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.model.UserGroupId;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/profiles"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\b\u0017\u0018\u0000 :2\u00020\u0001:\u0001:B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JB\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012H\u0017JB\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00122\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0017JL\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u001a\u001a\u00020\u000e2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u00102\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0010\b\u0001\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0017J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u0010#\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010%\u001a\u00020&H\u0017J \u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010%\u001a\u00020&H\u0017J\u001a\u0010*\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010+\u001a\u00020&H\u0017J\u001a\u0010,\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010+\u001a\u00020&H\u0017J4\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\t2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010/\u001a\u0002002\b\b\u0001\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0012H\u0017J\u001a\u00101\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010%\u001a\u00020&H\u0017J$\u00103\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u00104\u001a\u000205H\u0017J$\u00103\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010%\u001a\u00020&2\b\b\u0001\u00106\u001a\u000207H\u0017J,\u00101\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u000202082\u0006\u0010\u000b\u001a\u00020\f2\u000e\b\u0001\u00109\u001a\b\u0012\u0004\u0012\u00020&0(H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lde/justsoftware/people/controller/ProfileController;", "", "searchApplicationService", "Lde/justsoftware/people/application/SearchApplicationService;", "profileApplicationService", "Lde/justsoftware/people/application/ProfileApplicationService;", "<init>", "(Lde/justsoftware/people/application/SearchApplicationService;Lde/justsoftware/people/application/ProfileApplicationService;)V", "getProfiles", "Lde/justsoftware/people/model/PagedResult;", "Lde/justsoftware/people/application/model/ProfileSearchResult;", "authCtx", "Lde/justsoftware/people/authorization/AuthorizationContext;", "query", "", "contextGroupId", "Lde/justsoftware/people/model/UserGroupId;", "offset", "", "limit", "searchProfiles", "Lde/justsoftware/people/controller/model/PagedResultModel;", "requestSearchModel", "Lde/justsoftware/people/application/model/ProfileSearchModel;", "exportProfiles", "", "locale", "groupId", "searchFilters", "", "Lde/justsoftware/people/application/model/SearchFilterModel;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "getSearchConfiguration", "Lde/justsoftware/people/controller/model/ProfileAttributeSearchConfigurationDto;", "getProfile", "Lde/justsoftware/people/business/profile/model/Profile;", "profileId", "Lde/justsoftware/people/model/ProfileId;", "getProfileGroups", "", "Lde/justsoftware/people/business/usergroup/model/UserGroup;", "saveBirthdayReminderForProfile", "reminderProfileId", "deleteBirthdayReminderForProfile", "getBirthdayProfiles", "Lde/justsoftware/people/business/profile/model/BirthdayProfile;", "currentDate", "Ljava/time/LocalDate;", "getAbsenceInformation", "Lde/justsoftware/people/application/model/AbsenceDto;", "changeAbsenceStatus", "absenceStatusUpdate", "Lde/justsoftware/people/application/model/AbsenceStatusUpdateDto;", "absenceNoteUpdate", "Lde/justsoftware/people/application/model/AbsenceNoteUpdateDto;", "", "profileIds", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nProfileController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileController.kt\nde/justsoftware/people/controller/ProfileController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1#2:231\n1557#3:232\n1628#3,3:233\n*S KotlinDebug\n*F\n+ 1 ProfileController.kt\nde/justsoftware/people/controller/ProfileController\n*L\n137#1:232\n137#1:233,3\n*E\n"})
public class ProfileController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SearchApplicationService searchApplicationService;
    @NotNull
    private final ProfileApplicationService profileApplicationService;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("uuuuMMdd_HHmmss");

    public ProfileController(@NotNull SearchApplicationService searchApplicationService, @NotNull ProfileApplicationService profileApplicationService) {
        Intrinsics.checkNotNullParameter((Object)searchApplicationService, (String)"searchApplicationService");
        Intrinsics.checkNotNullParameter((Object)profileApplicationService, (String)"profileApplicationService");
        this.searchApplicationService = searchApplicationService;
        this.profileApplicationService = profileApplicationService;
    }

    @GetMapping
    @NotNull
    public PagedResult<ProfileSearchResult> getProfiles(@NotNull AuthorizationContext authCtx, @RequestParam(value="query", required=false) @Nullable String query, @RequestParam(value="contextGroupId", required=false) @Nullable UserGroupId contextGroupId, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="50") int limit) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        String string = Strings.nullToEmpty((String)query);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nullToEmpty(...)");
        return this.searchApplicationService.allProfiles(authCtx, string, CollectionsKt.emptyList(), null, contextGroupId, null, offset, limit);
    }

    @PostMapping
    @NotNull
    public PagedResultModel<ProfileSearchResult> searchProfiles(@NotNull AuthorizationContext authCtx, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="50") int limit, @RequestParam(value="contextGroupId", required=false) @Nullable UserGroupId contextGroupId, @RequestBody(required=false) @Nullable ProfileSearchModel requestSearchModel) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        ProfileSearchModel profileSearchModel = Optional.ofNullable(requestSearchModel).orElse(ProfileSearchModel.EMPTY);
        String string = profileSearchModel.getSearchString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSearchString(...)");
        ImmutableList immutableList = profileSearchModel.getSearchFilter();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getSearchFilter(...)");
        PagedResult result = this.searchApplicationService.allProfiles(authCtx, string, (List)immutableList, profileSearchModel.getFacetFilter(), contextGroupId, null, offset, limit);
        return result.toPagedResultModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/export"})
    public void exportProfiles(@NotNull AuthorizationContext authCtx, @RequestParam(value="locale") @NotNull String locale, @RequestParam(value="groupId", required=false) @Nullable UserGroupId groupId, @RequestParam(value="query", required=false) @Nullable String query, @RequestParam(value="searchFilters", required=false) @Nullable List<? extends SearchFilterModel> searchFilters, @NotNull HttpServletResponse response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        LocalDateTime now = LocalDateTime.now();
        response.setHeader("Content-Disposition", "attachment; filename=\"" + DATE_TIME_FORMATTER.format(now) + "_people_export.csv\"");
        response.setHeader("Content-Type", "text/csv");
        response.setHeader("Content-Transfer-Encoding", "binary");
        Closeable closeable = new BufferedOutputStream((OutputStream)response.getOutputStream());
        Throwable throwable = null;
        try {
            List list;
            BufferedOutputStream bos = (BufferedOutputStream)closeable;
            boolean bl = false;
            TenantId tenantId = authCtx.getTenantId();
            Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
            String string = query;
            if (string == null) {
                string = "";
            }
            if ((list = searchFilters) == null) {
                list = CollectionsKt.emptyList();
            }
            ProfileCsvInputStream pagedResultInputStream = this.searchApplicationService.exportProfiles(authCtx, tenantId, string, list, groupId, locale);
            int len = 0;
            int bufferLength = 1024;
            byte[] buf = new byte[bufferLength];
            while (true) {
                int n;
                int it = n = pagedResultInputStream.read(buf);
                boolean bl2 = false;
                len = it;
                if (n <= 0) break;
                bos.write(buf, 0, len);
                bos.flush();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        response.flushBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/searchConfig"})
    @NotNull
    public List<ProfileAttributeSearchConfigurationDto> getSearchConfiguration(@NotNull AuthorizationContext authCtx) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        TenantId tenantId = authCtx.getTenantId();
        Intrinsics.checkNotNullExpressionValue((Object)tenantId, (String)"getTenantId(...)");
        Iterable $this$map$iv = this.searchApplicationService.getSearchConfiguration(authCtx, tenantId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void c;
            ProfileAttributeConfig profileAttributeConfig = (ProfileAttributeConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = c.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection.add(new ProfileAttributeSearchConfigurationDto(string, c.isVisibleOnBadge(), c.isSearchable(), c.isFacetable(), c.isClickable(), (String)c.getSearchField().map(arg_0 -> ProfileController.getSearchConfiguration$lambda$3$lambda$2((Function1)getSearchConfiguration.1.1.INSTANCE, arg_0)).orElse(null), c.isSearchInFacetsSupported(), c.isTranslated()));
        }
        return (List)destination$iv$iv;
    }

    @GetMapping(value={"/{profileId}"})
    @NotNull
    public Profile getProfile(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return this.searchApplicationService.getProfile(authCtx, profileId);
    }

    @GetMapping(value={"/{profileId}/groups"})
    @NotNull
    public Set<UserGroup> getProfileGroups(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return this.searchApplicationService.getProfileGroups(authCtx, profileId);
    }

    @PostMapping(value={"/birthdayList/reminder/{reminderProfileId}"})
    public void saveBirthdayReminderForProfile(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        this.profileApplicationService.saveBirthdayReminderForProfile(authCtx, reminderProfileId);
    }

    @DeleteMapping(value={"/birthdayList/reminder/{reminderProfileId}"})
    public void deleteBirthdayReminderForProfile(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull ProfileId reminderProfileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)reminderProfileId, (String)"reminderProfileId");
        this.profileApplicationService.deleteBirthdayReminderForProfile(authCtx, reminderProfileId);
    }

    @GetMapping(value={"/birthdayList"})
    @NotNull
    public PagedResult<BirthdayProfile> getBirthdayProfiles(@NotNull AuthorizationContext authCtx, @RequestParam(value="currentDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @NotNull LocalDate currentDate, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="50") int limit) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"currentDate");
        return this.searchApplicationService.getBirthdayList(authCtx, currentDate, offset, limit);
    }

    @GetMapping(value={"/{profileId}/absence"})
    @NotNull
    public AbsenceDto getAbsenceInformation(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return this.profileApplicationService.getAbsenceInformation(authCtx, profileId);
    }

    @PostMapping(value={"/{profileId}/absence/status"})
    @NotNull
    public AbsenceDto changeAbsenceStatus(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull ProfileId profileId, @RequestBody @NotNull AbsenceStatusUpdateDto absenceStatusUpdate) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)absenceStatusUpdate, (String)"absenceStatusUpdate");
        return this.profileApplicationService.changeAbsenceStatus(authCtx, profileId, absenceStatusUpdate.isAbsent());
    }

    @PostMapping(value={"/{profileId}/absence/note"})
    @NotNull
    public AbsenceDto changeAbsenceStatus(@NotNull AuthorizationContext authCtx, @PathVariable @NotNull ProfileId profileId, @RequestBody @NotNull AbsenceNoteUpdateDto absenceNoteUpdate) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)absenceNoteUpdate, (String)"absenceNoteUpdate");
        return this.profileApplicationService.changeAbsenceNote(authCtx, profileId, absenceNoteUpdate.getAbsenceNote());
    }

    @PostMapping(value={"/absence"})
    @NotNull
    public Map<ProfileId, AbsenceDto> getAbsenceInformation(@NotNull AuthorizationContext authCtx, @RequestBody @NotNull Set<ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter((Object)authCtx, (String)"authCtx");
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        return this.profileApplicationService.getAbsenceInformation(authCtx, profileIds);
    }

    private static final String getSearchConfiguration$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }
}

