/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.controller;

import de.justsoftware.notificationclient.model.NotificationConcern;
import de.justsoftware.notificationservice.business.NotificationService;
import de.justsoftware.notificationservice.exception.NotificationNotFoundException;
import de.justsoftware.notificationservice.model.Notification;
import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.model.NotificationsCount;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import de.justsoftware.notificationservice.util.ControllerUtil;
import io.swagger.v3.oas.annotations.Operation;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/api/notification"})
@ParametersAreNonnullByDefault
public class NotificationController {
    private final NotificationService _notificationService;
    private final int _pollIntervalMs;

    @Autowired
    public NotificationController(NotificationService notificationService, @Value(value="${service.pollIntervalMs:300000}") int pollIntervalMs) {
        this._notificationService = notificationService;
        this._pollIntervalMs = pollIntervalMs;
    }

    @Nonnull
    private static ProfileId getCurrentProfileId() {
        return ControllerUtil.INSTANCE.getCurrentProfileId();
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    @ResponseBody
    @Nonnull
    @Operation(summary="Return localized notifications for the current user", description="Only notification with the given status and before the given date are returned. If date isn't given, the current time will be used.")
    public List<Notification> getNotifications(@RequestParam(name="locale", defaultValue="en") String locale, @RequestParam(name="status", defaultValue="OPEN") NotificationStatus status, @Nullable @RequestParam(value="date", required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime date, @RequestParam(value="maxElements", defaultValue="20") int maxElements, @RequestParam(value="concern", defaultValue="ALL", required=false) NotificationConcern concern, @Nullable @RequestParam(value="app", required=false) String app) {
        Instant localDate = date != null ? date.toInstant(ZoneOffset.UTC) : Instant.now();
        return this._notificationService.getNotifications(Locale.forLanguageTag(locale), NotificationController.getCurrentProfileId(), status, concern, app, localDate, maxElements);
    }

    @RequestMapping(value={"/archive/{notificationId}"}, method={RequestMethod.PUT})
    @Operation(summary="Move notification into archive")
    @ResponseStatus(value=HttpStatus.OK)
    public void archiveNotification(@PathVariable UUID notificationId) {
        try {
            ProfileId receiverId = NotificationController.getCurrentProfileId();
            this._notificationService.archiveNotification(notificationId, receiverId);
        }
        catch (NotificationNotFoundException ex) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Notification " + notificationId + " not found", (Throwable)ex);
        }
    }

    @RequestMapping(value={"/archive"}, method={RequestMethod.PUT})
    @ResponseBody
    @Nonnull
    @Operation(summary="Archive all unread and unmarked notifications.", description="Returns the ids of the modified notifications.")
    @ResponseStatus(value=HttpStatus.OK)
    public Set<UUID> archiveAllNotifications(@RequestParam(value="concern", defaultValue="ALL", required=false) NotificationConcern concern, @Nullable @RequestParam(value="app", required=false) String app) {
        ProfileId receiverId = NotificationController.getCurrentProfileId();
        return this._notificationService.archiveAllUnmarkedNotifications(receiverId, concern, app);
    }

    @RequestMapping(value={"/{notificationId}/mark"}, method={RequestMethod.PUT})
    @Operation(summary="Setting a marker for a specific notification and move its status to OPEN if it was previously ARCHIVED")
    @ResponseStatus(value=HttpStatus.OK)
    public void markNotification(@PathVariable UUID notificationId) {
        try {
            ProfileId receiverId = NotificationController.getCurrentProfileId();
            this._notificationService.markNotification(notificationId, receiverId);
        }
        catch (NotificationNotFoundException ex) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Notification " + notificationId + " not found", (Throwable)ex);
        }
    }

    @RequestMapping(value={"/{notificationId}/unmark"}, method={RequestMethod.PUT})
    @Operation(summary="Remove a previously set marker from a specific notification")
    @ResponseStatus(value=HttpStatus.OK)
    public void unmarkNotification(@PathVariable UUID notificationId) {
        try {
            ProfileId receiverId = NotificationController.getCurrentProfileId();
            this._notificationService.unmarkNotification(notificationId, receiverId);
        }
        catch (NotificationNotFoundException ex) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Notification " + notificationId + " not found", (Throwable)ex);
        }
    }

    @RequestMapping(value={"/open"}, method={RequestMethod.PUT})
    @Operation(summary="Set the status of the provided notifications to OPEN")
    @ResponseStatus(value=HttpStatus.OK)
    public void moveToOpen(@RequestBody List<UUID> notificationIds2) {
        ProfileId receiverId = NotificationController.getCurrentProfileId();
        this._notificationService.moveToOpen(notificationIds2, receiverId);
    }

    @RequestMapping(value={"/count"}, method={RequestMethod.GET})
    @ResponseBody
    @Nonnull
    @Operation(summary="Return count of open and archived notifications")
    public NotificationsCount getNotificationsCount() {
        return this._notificationService.getNotificationsCount(NotificationController.getCurrentProfileId());
    }

    @RequestMapping(value={"/updated"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @Nonnull
    @Operation(summary="Return whether there were changes since a specific date")
    public Map<String, Object> updatedSince(@RequestParam(value="since") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime since) {
        Instant localSince = since.toInstant(ZoneOffset.UTC);
        HashMap<String, Object> result = new HashMap<String, Object>(this._notificationService.updated(NotificationController.getCurrentProfileId(), localSince));
        result.put("nextPollIntervalMs", this._pollIntervalMs);
        return result;
    }
}

