/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogSegmentMetadataSnapshot;
import org.apache.kafka.server.log.remote.metadata.storage.serialization.RemoteLogMetadataSerde;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLogMetadataSnapshotFile {
    private static final Logger log = LoggerFactory.getLogger(RemoteLogMetadataSnapshotFile.class);
    public static final String COMMITTED_LOG_METADATA_SNAPSHOT_FILE_NAME = "remote_log_snapshot";
    private static final int HEADER_SIZE = 18;
    private final File metadataStoreFile;
    private final RemoteLogMetadataSerde serde = new RemoteLogMetadataSerde();

    RemoteLogMetadataSnapshotFile(Path metadataStoreDir) {
        this.metadataStoreFile = new File(metadataStoreDir.toFile(), COMMITTED_LOG_METADATA_SNAPSHOT_FILE_NAME);
        try {
            boolean fileExists = Files.exists(this.metadataStoreFile.toPath(), new LinkOption[0]);
            if (!fileExists) {
                Files.createFile(this.metadataStoreFile.toPath(), new FileAttribute[0]);
            }
            log.info("Remote log metadata snapshot file: [{}], newFileCreated: [{}]", (Object)this.metadataStoreFile, (Object)(!fileExists ? 1 : 0));
        }
        catch (IOException e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public synchronized void write(Snapshot snapshot) throws IOException {
        Path newMetadataSnapshotFilePath = new File(this.metadataStoreFile.getAbsolutePath() + ".tmp").toPath();
        try (FileChannel fileChannel = FileChannel.open(newMetadataSnapshotFilePath, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            ByteBuffer headerBuffer = ByteBuffer.allocate(18);
            headerBuffer.putShort(snapshot.version());
            headerBuffer.putInt(snapshot.metadataPartition());
            headerBuffer.putLong(snapshot.metadataPartitionOffset());
            Collection<RemoteLogSegmentMetadataSnapshot> metadataSnapshots = snapshot.remoteLogSegmentMetadataSnapshots();
            headerBuffer.putInt(metadataSnapshots.size());
            headerBuffer.flip();
            fileChannel.write(headerBuffer);
            ByteBuffer lenBuffer = ByteBuffer.allocate(4);
            for (RemoteLogSegmentMetadataSnapshot metadataSnapshot : metadataSnapshots) {
                byte[] serializedBytes = this.serde.serialize(metadataSnapshot);
                lenBuffer.putInt(serializedBytes.length);
                lenBuffer.flip();
                fileChannel.write(lenBuffer);
                lenBuffer.rewind();
                fileChannel.write(ByteBuffer.wrap(serializedBytes));
            }
            fileChannel.force(true);
        }
        Utils.atomicMoveWithFallback((Path)newMetadataSnapshotFilePath, (Path)this.metadataStoreFile.toPath());
    }

    public synchronized Optional<Snapshot> read() throws IOException {
        if (this.metadataStoreFile.length() == 0L) {
            return Optional.empty();
        }
        try (ReadableByteChannel channel = Channels.newChannel(new FileInputStream(this.metadataStoreFile));){
            int lenBufferReadCt;
            ByteBuffer headerBuffer = ByteBuffer.allocate(18);
            channel.read(headerBuffer);
            headerBuffer.rewind();
            short version = headerBuffer.getShort();
            int metadataPartition = headerBuffer.getInt();
            long metadataPartitionOffset = headerBuffer.getLong();
            int metadataSnapshotsSize = headerBuffer.getInt();
            ArrayList<RemoteLogSegmentMetadataSnapshot> result = new ArrayList<RemoteLogSegmentMetadataSnapshot>(metadataSnapshotsSize);
            ByteBuffer lenBuffer = ByteBuffer.allocate(4);
            while ((lenBufferReadCt = channel.read(lenBuffer)) > 0) {
                lenBuffer.rewind();
                if (lenBufferReadCt != lenBuffer.capacity()) {
                    throw new IOException("Invalid amount of data read for the length of an entry, file may have been corrupted.");
                }
                int len = lenBuffer.getInt();
                lenBuffer.rewind();
                ByteBuffer data = ByteBuffer.allocate(len);
                int read = channel.read(data);
                if (read != len) {
                    throw new IOException("Invalid amount of data read, file may have been corrupted.");
                }
                RemoteLogSegmentMetadataSnapshot remoteLogSegmentMetadata = (RemoteLogSegmentMetadataSnapshot)this.serde.deserialize(data.array());
                result.add(remoteLogSegmentMetadata);
            }
            if (metadataSnapshotsSize != result.size()) {
                throw new IOException("Unexpected entries in the snapshot file. Expected size: " + metadataSnapshotsSize + ", but found: " + result.size());
            }
            Optional<Snapshot> optional = Optional.of(new Snapshot(version, metadataPartition, metadataPartitionOffset, result));
            return optional;
        }
    }

    public static final class Snapshot {
        private static final short CURRENT_VERSION = 0;
        private final short version;
        private final int metadataPartition;
        private final long metadataPartitionOffset;
        private final Collection<RemoteLogSegmentMetadataSnapshot> remoteLogSegmentMetadataSnapshots;

        public Snapshot(int metadataPartition, long metadataPartitionOffset, Collection<RemoteLogSegmentMetadataSnapshot> remoteLogSegmentMetadataSnapshots) {
            this(0, metadataPartition, metadataPartitionOffset, remoteLogSegmentMetadataSnapshots);
        }

        public Snapshot(short version, int metadataPartition, long metadataPartitionOffset, Collection<RemoteLogSegmentMetadataSnapshot> remoteLogSegmentMetadataSnapshots) {
            if (version != 0) {
                throw new IllegalArgumentException("Unexpected version received: " + version);
            }
            this.version = version;
            this.metadataPartition = metadataPartition;
            this.metadataPartitionOffset = metadataPartitionOffset;
            this.remoteLogSegmentMetadataSnapshots = remoteLogSegmentMetadataSnapshots;
        }

        public short version() {
            return this.version;
        }

        public int metadataPartition() {
            return this.metadataPartition;
        }

        public long metadataPartitionOffset() {
            return this.metadataPartitionOffset;
        }

        public Collection<RemoteLogSegmentMetadataSnapshot> remoteLogSegmentMetadataSnapshots() {
            return this.remoteLogSegmentMetadataSnapshots;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Snapshot)) {
                return false;
            }
            Snapshot snapshot = (Snapshot)o;
            return this.version == snapshot.version && this.metadataPartition == snapshot.metadataPartition && this.metadataPartitionOffset == snapshot.metadataPartitionOffset && Objects.equals(this.remoteLogSegmentMetadataSnapshots, snapshot.remoteLogSegmentMetadataSnapshots);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.metadataPartition, this.metadataPartitionOffset, this.remoteLogSegmentMetadataSnapshots);
        }

        public String toString() {
            return "Snapshot{version=" + this.version + ", metadataPartition=" + this.metadataPartition + ", metadataPartitionOffset=" + this.metadataPartitionOffset + ", remoteLogSegmentMetadataSnapshotsSize" + this.remoteLogSegmentMetadataSnapshots.size() + '}';
        }
    }
}

